/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation;

import cn.hutool.core.annotation.CombinationAnnotationElement;
import cn.hutool.core.annotation.GenericSynthesizedAggregateAnnotation;
import cn.hutool.core.annotation.SynthesizedAggregateAnnotation;
import cn.hutool.core.annotation.SynthesizedAnnotationProxy;
import cn.hutool.core.annotation.scanner.AnnotationScanner;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Opt;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.lang.func.LambdaUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AnnotationUtil {
    static final Set<Class<? extends Annotation>> META_ANNOTATIONS = CollUtil.newHashSet(Target.class, Retention.class, Inherited.class, Documented.class, SuppressWarnings.class, Override.class, Deprecated.class);

    public static boolean isJdkMetaAnnotation(Class<? extends Annotation> annotationType) {
        Class<? extends Annotation> clazz;
        return META_ANNOTATIONS.contains(clazz);
    }

    public static boolean isNotJdkMateAnnotation(Class<? extends Annotation> annotationType) {
        Class<? extends Annotation> clazz;
        return false == AnnotationUtil.isJdkMetaAnnotation(clazz);
    }

    public static CombinationAnnotationElement toCombination(AnnotatedElement annotationEle) {
        AnnotatedElement annotatedElement;
        if (annotationEle instanceof CombinationAnnotationElement) {
            return (CombinationAnnotationElement)annotationEle;
        }
        return new CombinationAnnotationElement(annotatedElement);
    }

    /*
     * WARNING - void declaration
     */
    public static Annotation[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination) {
        void var1_1;
        return AnnotationUtil.getAnnotations(annotationEle, (boolean)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] getCombinationAnnotations(AnnotatedElement annotationEle, Class<T> annotationType) {
        void var1_1;
        return AnnotationUtil.getAnnotations(annotationEle, true, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination, Class<T> annotationType) {
        void var1_2;
        Annotation[] annotations = AnnotationUtil.getAnnotations(annotationEle, isToCombination, (Annotation annotation) -> {
            void var1_1;
            Class clazz;
            return annotationType == null || clazz.isAssignableFrom(var1_1.getClass());
        });
        T[] result = ArrayUtil.newArray(annotationType, annotations.length);
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = annotations[i];
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Annotation[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination, Predicate<Annotation> predicate) {
        void var2_2;
        Annotation[] annotationArray;
        void var1_1;
        if (annotationEle == null) {
            return null;
        }
        if (var1_1 != false) {
            if (predicate == null) {
                return AnnotationUtil.toCombination(annotationEle).getAnnotations();
            }
            return CombinationAnnotationElement.of(annotationEle, predicate).getAnnotations();
        }
        Annotation[] result = annotationEle.getAnnotations();
        if (predicate == null) {
            return result;
        }
        return ArrayUtil.filter(annotationArray, ((Predicate)var2_2)::test);
    }

    /*
     * WARNING - void declaration
     */
    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotationEle, Class<A> annotationType) {
        void var1_1;
        AnnotatedElement annotatedElement;
        if (annotationEle == null) {
            return null;
        }
        return (A)AnnotationUtil.toCombination(annotatedElement).getAnnotation(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasAnnotation(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) {
        void var1_1;
        AnnotatedElement annotatedElement;
        return null != AnnotationUtil.getAnnotation(annotatedElement, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getAnnotationValue(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) throws UtilException {
        void var1_1;
        return AnnotationUtil.getAnnotationValue(annotationEle, (Class<? extends Annotation>)var1_1, "value");
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getAnnotationValue(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType, String propertyName) throws UtilException {
        void var1_1;
        Annotation annotation;
        void var2_2;
        Annotation annotation2 = AnnotationUtil.getAnnotation(annotationEle, annotationType);
        if (annotation2 == null) {
            return null;
        }
        Method method = ReflectUtil.getMethodOfObj(annotation2, (String)var2_2, new Object[0]);
        if (method == null) {
            return null;
        }
        return ReflectUtil.invoke((Object)annotation, (Method)var1_1, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <A extends Annotation, R> R getAnnotationValue(AnnotatedElement annotationEle, Func1<A, R> propertyName) {
        void var1_1;
        void var2_2;
        AnnotatedElement annotatedElement;
        if (propertyName == null) {
            return null;
        }
        SerializedLambda lambda = LambdaUtil.resolve(propertyName);
        String instantiatedMethodType = lambda.getInstantiatedMethodType();
        Class annotationClass = ClassUtil.loadClass(StrUtil.sub(instantiatedMethodType, 2, StrUtil.indexOf(instantiatedMethodType, ';')));
        return (R)AnnotationUtil.getAnnotationValue(annotatedElement, (Class<? extends Annotation>)var2_2, var1_1.getImplMethodName());
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> getAnnotationValueMap(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) throws UtilException {
        void var2_2;
        void var1_1;
        Annotation annotation = AnnotationUtil.getAnnotation(annotationEle, annotationType);
        if (annotation == null) {
            return null;
        }
        Method[] methods = ReflectUtil.getMethods(annotationType, t -> {
            if (ArrayUtil.isEmpty(t.getParameterTypes())) {
                String string;
                String name = t.getName();
                return false == "hashCode".equals(name) && false == "toString".equals(name) && false == "annotationType".equals(string);
            }
            return false;
        });
        HashMap result = new HashMap(methods.length, 1.0f);
        for (void method : var1_1) {
            result.put(method.getName(), ReflectUtil.invoke((Object)annotation, (Method)method, new Object[0]));
        }
        return var2_2;
    }

    public static RetentionPolicy getRetentionPolicy(Class<? extends Annotation> annotationType) {
        Retention retention;
        Retention retention2 = annotationType.getAnnotation(Retention.class);
        if (retention2 == null) {
            return RetentionPolicy.CLASS;
        }
        return retention.value();
    }

    public static ElementType[] getTargetType(Class<? extends Annotation> annotationType) {
        Target target;
        Target target2 = annotationType.getAnnotation(Target.class);
        if (target2 == null) {
            return new ElementType[]{ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.CONSTRUCTOR, ElementType.LOCAL_VARIABLE, ElementType.ANNOTATION_TYPE, ElementType.PACKAGE};
        }
        return target.value();
    }

    public static boolean isDocumented(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Documented.class);
    }

    public static boolean isInherited(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(Inherited.class);
    }

    public static List<Annotation> scanMetaAnnotation(Class<? extends Annotation> annotationType) {
        Class<? extends Annotation> clazz;
        return AnnotationScanner.DIRECTLY_AND_META_ANNOTATION.getAnnotationsIfSupport(clazz);
    }

    public static List<Annotation> scanClass(Class<?> targetClass) {
        Class<?> clazz;
        return AnnotationScanner.TYPE_HIERARCHY.getAnnotationsIfSupport(clazz);
    }

    public static List<Annotation> scanMethod(Method method) {
        Method method2;
        return AnnotationScanner.TYPE_HIERARCHY.getAnnotationsIfSupport(method2);
    }

    /*
     * WARNING - void declaration
     */
    public static void setValue(Annotation annotation, String annotationField, Object value) {
        void var2_2;
        void var1_1;
        Map map = (Map)ReflectUtil.getFieldValue((Object)Proxy.getInvocationHandler(annotation), "memberValues");
        map.put(var1_1, var2_2);
    }

    public static boolean isSynthesizedAnnotation(Annotation annotation) {
        return SynthesizedAnnotationProxy.isProxyAnnotation(annotation.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Annotation> T getAnnotationAlias(AnnotatedElement annotationEle, Class<T> annotationType) {
        void var1_1;
        AnnotatedElement annotatedElement;
        AnnotatedElement annotation = AnnotationUtil.getAnnotation(annotationEle, annotationType);
        if (annotation == null) {
            return null;
        }
        return AnnotationUtil.aggregatingFromAnnotation(new Annotation[]{annotatedElement}).synthesize(var1_1);
    }

    public static <T extends Annotation> T getSynthesizedAnnotation(Class<T> annotationType, Annotation ... annotations) {
        Class<T> clazz;
        return (T)Opt.ofNullable(annotations).filter(ArrayUtil::isNotEmpty).map(AnnotationUtil::aggregatingFromAnnotationWithMeta).map(a -> {
            Class clazz;
            return a.synthesize(clazz);
        }).get();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Annotation> T getSynthesizedAnnotation(AnnotatedElement annotatedEle, Class<T> annotationType) {
        void var1_1;
        AnnotatedElement annotatedElement;
        T target = annotatedEle.getAnnotation(annotationType);
        if (ObjectUtil.isNotNull(target)) {
            void var2_2;
            return var2_2;
        }
        return (T)((Annotation)AnnotationScanner.DIRECTLY.getAnnotationsIfSupport(annotatedElement).stream().map(arg_0 -> AnnotationUtil.lambda$getSynthesizedAnnotation$3((Class)var1_1, arg_0)).filter(Objects::nonNull).findFirst().orElse(null));
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Annotation> List<T> getAllSynthesizedAnnotations(AnnotatedElement annotatedEle, Class<T> annotationType) {
        void var1_1;
        AnnotatedElement annotatedElement;
        return AnnotationScanner.DIRECTLY.getAnnotationsIfSupport(annotatedElement).stream().map(arg_0 -> AnnotationUtil.lambda$getAllSynthesizedAnnotations$4((Class)var1_1, arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static SynthesizedAggregateAnnotation aggregatingFromAnnotation(Annotation ... annotations) {
        Annotation[] annotationArray;
        return new GenericSynthesizedAggregateAnnotation(Arrays.asList(annotationArray), AnnotationScanner.NOTHING);
    }

    public static SynthesizedAggregateAnnotation aggregatingFromAnnotationWithMeta(Annotation ... annotations) {
        Annotation[] annotationArray;
        return new GenericSynthesizedAggregateAnnotation(Arrays.asList(annotationArray), AnnotationScanner.DIRECTLY_AND_META_ANNOTATION);
    }

    static boolean isAttributeMethod(Method method) {
        Method method2;
        return method.getParameterCount() == 0 && method2.getReturnType() != Void.TYPE;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Annotation lambda$getAllSynthesizedAnnotations$4(Class annotationType, Annotation annotation) {
        void var1_1;
        return AnnotationUtil.getSynthesizedAnnotation(annotationType, new Annotation[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Annotation lambda$getSynthesizedAnnotation$3(Class annotationType, Annotation annotation) {
        void var1_1;
        return AnnotationUtil.getSynthesizedAnnotation(annotationType, new Annotation[]{var1_1});
    }
}

