/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation;

import cn.hutool.core.annotation.Alias;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class AnnotationProxy<T extends Annotation>
implements Serializable,
Annotation,
InvocationHandler {
    private static final long serialVersionUID = 1L;
    private final T annotation;
    private final Class<T> type;
    private final Map<String, Object> attributes;

    /*
     * WARNING - void declaration
     */
    public AnnotationProxy(T annotation) {
        void var1_1;
        this.annotation = annotation;
        this.type = var1_1.annotationType();
        this.attributes = this.initAttributes();
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        void var3_3;
        void var2_2;
        String name;
        Alias alias = method.getAnnotation(Alias.class);
        if (alias != null && StrUtil.isNotBlank(name = alias.value())) {
            if (!this.attributes.containsKey(name)) {
                throw new IllegalArgumentException(StrUtil.format("No method for alias: [{}]", name));
            }
            return this.attributes.get(name);
        }
        Object value = this.attributes.get(method.getName());
        if (value != null) {
            void var1_1;
            return var1_1;
        }
        return var2_2.invoke((Object)this, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> initAttributes() {
        void var2_2;
        void var1_1;
        Method[] methods = ReflectUtil.getMethods(this.type);
        HashMap attributes = new HashMap(methods.length, 1.0f);
        for (void method : var1_1) {
            if (method.isSynthetic()) continue;
            attributes.put(method.getName(), ReflectUtil.invoke(this.annotation, (Method)method, new Object[0]));
        }
        return var2_2;
    }
}

