/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation;

import cn.hutool.core.annotation.AnnotationSynthesizer;
import cn.hutool.core.annotation.SynthesizedAnnotation;
import cn.hutool.core.annotation.SynthesizedAnnotationPostProcessor;
import cn.hutool.core.annotation.SynthesizedAnnotationSelector;
import cn.hutool.core.annotation.scanner.AnnotationScanner;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractAnnotationSynthesizer<T>
implements AnnotationSynthesizer {
    protected final T source;
    protected final Map<Class<? extends Annotation>, SynthesizedAnnotation> synthesizedAnnotationMap;
    private final Map<Class<? extends Annotation>, Annotation> synthesizedProxyAnnotations;
    protected final SynthesizedAnnotationSelector annotationSelector;
    protected final Collection<SynthesizedAnnotationPostProcessor> postProcessors;
    protected final AnnotationScanner annotationScanner;

    /*
     * WARNING - void declaration
     */
    protected AbstractAnnotationSynthesizer(T source, SynthesizedAnnotationSelector annotationSelector, Collection<SynthesizedAnnotationPostProcessor> annotationPostProcessors, AnnotationScanner annotationScanner) {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notNull(source, "source must not null", new Object[0]);
        Assert.notNull(annotationSelector, "annotationSelector must not null", new Object[0]);
        Assert.notNull(annotationPostProcessors, "annotationPostProcessors must not null", new Object[0]);
        Assert.notNull(annotationPostProcessors, "annotationScanner must not null", new Object[0]);
        this.source = var1_1;
        this.annotationSelector = var2_2;
        this.annotationScanner = annotationScanner;
        this.postProcessors = CollUtil.unmodifiable(CollUtil.sort(annotationPostProcessors, Comparator.comparing(SynthesizedAnnotationPostProcessor::order)));
        this.synthesizedProxyAnnotations = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        this.synthesizedAnnotationMap = MapUtil.unmodifiable(this.loadAnnotations());
        var3_3.forEach(processor -> {
            void var1_1;
            this.synthesizedAnnotationMap.values().forEach(arg_0 -> this.lambda$null$0((SynthesizedAnnotationPostProcessor)var1_1, arg_0));
        });
    }

    protected abstract Map<Class<? extends Annotation>, SynthesizedAnnotation> loadAnnotations();

    protected abstract <A extends Annotation> A synthesize(Class<A> var1, SynthesizedAnnotation var2);

    public T getSource() {
        return this.source;
    }

    @Override
    public SynthesizedAnnotationSelector getAnnotationSelector() {
        return this.annotationSelector;
    }

    @Override
    public Collection<SynthesizedAnnotationPostProcessor> getAnnotationPostProcessors() {
        return this.postProcessors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SynthesizedAnnotation getSynthesizedAnnotation(Class<?> annotationType) {
        void var1_1;
        return this.synthesizedAnnotationMap.get(var1_1);
    }

    @Override
    public Map<Class<? extends Annotation>, SynthesizedAnnotation> getAllSynthesizedAnnotation() {
        return this.synthesizedAnnotationMap;
    }

    /*
     * WARNING - void declaration
     */
    public <A extends Annotation> A synthesize(Class<A> annotationType) {
        A a;
        Annotation annotation = this.synthesizedProxyAnnotations.get(annotationType);
        if (Objects.nonNull(annotation)) {
            return (A)annotation;
        }
        Map<Class<? extends Annotation>, Annotation> map = this.synthesizedProxyAnnotations;
        synchronized (map) {
            annotation = this.synthesizedProxyAnnotations.get(annotationType);
            if (Objects.isNull(annotation)) {
                void var1_1;
                SynthesizedAnnotation synthesizedAnnotation = this.synthesizedAnnotationMap.get(annotationType);
                a = this.synthesize(annotationType, (SynthesizedAnnotation)a);
                this.synthesizedProxyAnnotations.put((Class<? extends Annotation>)var1_1, (Annotation)a);
            }
        }
        return a;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$null$0(SynthesizedAnnotationPostProcessor processor, SynthesizedAnnotation synthesized) {
        void var2_2;
        processor.process((SynthesizedAnnotation)var2_2, this);
    }
}

