/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha.generator;

import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.core.math.Calculator;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

public class MathGenerator
implements CodeGenerator {
    private static final long serialVersionUID = -5514819971774091076L;
    private static final String operators = "+-*";
    private final int numberLength;

    public MathGenerator() {
        this(2);
    }

    /*
     * WARNING - void declaration
     */
    public MathGenerator(int numberLength) {
        void var1_1;
        this.numberLength = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String generate() {
        void var1_2;
        void var2_3;
        int limit = this.getLimit();
        String number1 = Integer.toString(RandomUtil.randomInt(limit));
        String number2 = Integer.toString(RandomUtil.randomInt(limit));
        number1 = StrUtil.padAfter((CharSequence)number1, this.numberLength, ' ');
        number2 = StrUtil.padAfter((CharSequence)number2, this.numberLength, ' ');
        return StrUtil.builder().append((String)var2_3).append(RandomUtil.randomChar(operators)).append((String)var1_2).append('=').toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean verify(String code, String userInputCode) {
        void var1_2;
        void var2_4;
        try {
            int result = Integer.parseInt(userInputCode);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        int calculateResult = (int)Calculator.conversion(code);
        return var2_4 == var1_2;
    }

    public int getLength() {
        return (this.numberLength << 1) + 2;
    }

    private int getLimit() {
        return Integer.parseInt("1" + StrUtil.repeat('0', this.numberLength));
    }
}

