/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.captcha.generator.RandomGenerator;
import cn.hutool.core.img.GraphicsUtil;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ShearCaptcha
extends AbstractCaptcha {
    private static final long serialVersionUID = -7096627300356535494L;

    /*
     * WARNING - void declaration
     */
    public ShearCaptcha(int width, int height) {
        this((int)var1_1, (int)var2_2, 5);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ShearCaptcha(int width, int height, int codeCount) {
        this((int)var1_1, (int)var2_2, (int)var3_3, 4);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ShearCaptcha(int width, int height, int codeCount, int thickness) {
        this((int)var1_1, (int)var2_2, new RandomGenerator((int)var3_3), thickness);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ShearCaptcha(int width, int height, CodeGenerator generator, int interfereCount) {
        super((int)var1_1, (int)var2_2, (CodeGenerator)var3_3, interfereCount);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Image createImage(String code) {
        void var2_3;
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = GraphicsUtil.createGraphics(image, ObjectUtil.defaultIfNull(this.background, Color.WHITE));
        try {
            void var1_1;
            this.drawString(g, (String)var1_1);
            this.shear(g, this.width, this.height, ObjectUtil.defaultIfNull(this.background, Color.WHITE));
            this.drawInterfere(g, 0, RandomUtil.randomInt(this.height) + 1, this.width, RandomUtil.randomInt(this.height) + 1, this.interfereCount, ImgUtil.randomColor());
        }
        catch (Throwable throwable) {
            void var3_4;
            var3_4.dispose();
            throw throwable;
        }
        g.dispose();
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private void drawString(Graphics2D g, String code) {
        void var2_2;
        void var1_1;
        if (null != this.textAlpha) {
            g.setComposite(this.textAlpha);
        }
        GraphicsUtil.drawStringColourful((Graphics)var1_1, (String)var2_2, this.font, this.width, this.height);
    }

    /*
     * WARNING - void declaration
     */
    private void shear(Graphics g, int w1, int h1, Color color) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.shearX(g, w1, h1, color);
        this.shearY((Graphics)var1_1, (int)var2_2, (int)var3_3, color);
    }

    private void shearX(Graphics g, int w1, int h1, Color color) {
        int period = RandomUtil.randomInt(this.width);
        int phase = RandomUtil.randomInt(2);
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            g.setColor(color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
    }

    private void shearY(Graphics g, int w1, int h1, Color color) {
        int period = RandomUtil.randomInt(this.height >> 1);
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + 43.982297150257104 / 20.0);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            g.setColor(color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drawInterfere(Graphics g, int x1, int y1, int x2, int y2, int thickness, Color c) {
        void var1_1;
        void var3_3;
        void var2_2;
        g.setColor(c);
        int dX = x2 - x1;
        int dY = y2 - y1;
        int n = dX;
        int n2 = dY;
        double lineLength = Math.sqrt(n * n + n2 * n2);
        double scale = (double)thickness / (lineLength * 2.0);
        double ddx = -scale * (double)dY;
        double ddy = scale * (double)dX;
        double d = ddx;
        ddx = d + (d > 0.0 ? 0.5 : -0.5);
        double d2 = ddy;
        ddy = d2 + (d2 > 0.0 ? 0.5 : -0.5);
        int dx = (int)ddx;
        int dy = (int)ddy;
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        xPoints[0] = x1 + dx;
        yPoints[0] = y1 + dy;
        xPoints[1] = var2_2 - dx;
        yPoints[1] = var3_3 - dy;
        xPoints[2] = x2 - dx;
        yPoints[2] = y2 - dy;
        xPoints[3] = x2 + dx;
        yPoints[3] = y2 + dy;
        var1_1.fillPolygon(xPoints, yPoints, 4);
    }
}

