/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha;

import cn.hutool.captcha.ICaptcha;
import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.captcha.generator.RandomGenerator;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.URLUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractCaptcha
implements ICaptcha {
    private static final long serialVersionUID = 3180820918087507254L;
    protected int width;
    protected int height;
    protected int interfereCount;
    protected Font font;
    protected String code;
    protected byte[] imageBytes;
    protected CodeGenerator generator;
    protected Color background;
    protected AlphaComposite textAlpha;

    /*
     * WARNING - void declaration
     */
    public AbstractCaptcha(int width, int height, int codeCount, int interfereCount) {
        this((int)var1_1, (int)var2_2, new RandomGenerator((int)var3_3), interfereCount);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AbstractCaptcha(int width, int height, CodeGenerator generator, int interfereCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.width = var1_1;
        this.height = var2_2;
        this.generator = var3_3;
        this.interfereCount = interfereCount;
        this.font = new Font("SansSerif", 0, (int)((double)this.height * 0.75));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createCode() {
        void var1_1;
        this.generateCode();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AbstractCaptcha abstractCaptcha = this;
        ImgUtil.writePng(abstractCaptcha.createImage(abstractCaptcha.code), out);
        this.imageBytes = var1_1.toByteArray();
    }

    protected void generateCode() {
        this.code = this.generator.generate();
    }

    protected abstract Image createImage(String var1);

    @Override
    public String getCode() {
        if (this.code == null) {
            this.createCode();
        }
        return this.code;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean verify(String userInputCode) {
        void var1_1;
        return this.generator.verify(this.getCode(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void write(String path) throws IORuntimeException {
        void var1_1;
        this.write(FileUtil.touch((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void write(File file) throws IORuntimeException {
        try {
            BufferedOutputStream out2;
            block12: {
                block11: {
                    out2 = FileUtil.getOutputStream(file);
                    Throwable throwable = null;
                    try {
                        this.write(out2);
                        if (out2 == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        try {
                            Throwable throwable3 = throwable2;
                            throwable = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (out2 != null) {
                                if (throwable != null) {
                                    try {
                                        ((OutputStream)out2).close();
                                    }
                                    catch (Throwable out2) {
                                        throwable.addSuppressed(out2);
                                    }
                                } else {
                                    ((OutputStream)out2).close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    break block12;
                }
                return;
            }
            ((OutputStream)out2).close();
        }
        catch (IOException e) {
            void var1_3;
            throw new IORuntimeException((Throwable)var1_3);
        }
    }

    @Override
    public void write(OutputStream out) {
        IoUtil.write(out, false, this.getImageBytes());
    }

    public byte[] getImageBytes() {
        if (this.imageBytes == null) {
            this.createCode();
        }
        return this.imageBytes;
    }

    public BufferedImage getImage() {
        return ImgUtil.read(IoUtil.toStream(this.getImageBytes()));
    }

    public String getImageBase64() {
        return Base64.encode(this.getImageBytes());
    }

    public String getImageBase64Data() {
        return URLUtil.getDataUriBase64("image/png", this.getImageBase64());
    }

    /*
     * WARNING - void declaration
     */
    public void setFont(Font font) {
        void var1_1;
        this.font = var1_1;
    }

    public CodeGenerator getGenerator() {
        return this.generator;
    }

    /*
     * WARNING - void declaration
     */
    public void setGenerator(CodeGenerator generator) {
        void var1_1;
        this.generator = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setBackground(Color background) {
        void var1_1;
        this.background = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTextAlpha(float textAlpha) {
        void var1_1;
        this.textAlpha = AlphaComposite.getInstance(3, (float)var1_1);
    }
}

