/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.impl.AbstractCache;
import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.CacheObjIterator;
import cn.hutool.core.collection.CopiedIter;
import java.util.Iterator;
import java.util.concurrent.locks.StampedLock;

public abstract class StampedCache<K, V>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = 1L;
    protected final StampedLock lock = new StampedLock();

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(K key, V object, long timeout) {
        long stamp = this.lock.writeLock();
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            this.putWithoutLock(var1_1, var2_3, (long)var3_4);
            return;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(K key) {
        void var1_1;
        return null != this.get(var1_1, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess) {
        void var2_2;
        void var1_1;
        return this.get(var1_1, (boolean)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<CacheObj<K, V>> cacheObjIterator() {
        void var1_2;
        long stamp = this.lock.readLock();
        try {
            CopiedIter copiedIterator = CopiedIter.copyOf(this.cacheObjIter());
            this.lock.unlockRead(stamp);
        }
        catch (Throwable copiedIterator) {
            void var2_1;
            this.lock.unlockRead((long)var2_1);
            throw copiedIterator;
        }
        return new CacheObjIterator(var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int prune() {
        long stamp = this.lock.writeLock();
        try {
            int n = this.pruneCache();
            this.lock.unlockWrite(stamp);
            return n;
        }
        catch (Throwable throwable) {
            void var1_1;
            this.lock.unlockWrite((long)var1_1);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(K key) {
        long stamp = this.lock.writeLock();
        try {
            CacheObj co = this.removeWithoutLock(key);
            this.lock.unlockWrite(stamp);
        }
        catch (Throwable co) {
            void var2_3;
            this.lock.unlockWrite((long)var2_3);
            throw co;
        }
        if (co != null) {
            void var1_1;
            this.onRemove(co.key, var1_1.obj);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.cacheMap.clear();
            this.lock.unlockWrite(stamp);
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            this.lock.unlockWrite((long)var1_1);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private V get(K key, boolean isUpdateLastAccess, boolean isUpdateCount) {
        void var3_4;
        void var1_1;
        long stamp = this.lock.tryOptimisticRead();
        CacheObj co = this.getWithoutLock(key);
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                co = this.getWithoutLock(key);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        if (co == null) {
            if (isUpdateCount) {
                this.missCount.increment();
            }
            return null;
        }
        if (!co.isExpired()) {
            void var2_3;
            if (isUpdateCount) {
                this.hitCount.increment();
            }
            return co.get((boolean)var2_3);
        }
        return this.getOrRemoveExpired(var1_1, (boolean)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    private V getOrRemoveExpired(K key, boolean isUpdateCount) {
        void var1_1;
        CacheObj co;
        long stamp;
        block7: {
            void var2_3;
            block6: {
                stamp = this.lock.writeLock();
                try {
                    co = this.getWithoutLock(key);
                    if (co != null) break block6;
                    this.lock.unlockWrite(stamp);
                }
                catch (Throwable throwable) {
                    void var3_4;
                    this.lock.unlockWrite((long)var3_4);
                    throw throwable;
                }
                return null;
            }
            if (co.isExpired()) break block7;
            if (var2_3 != false) {
                this.hitCount.increment();
            }
            key = co.getValue();
            this.lock.unlockWrite(stamp);
            return (V)key;
        }
        co = this.removeWithoutLock(var1_1);
        this.lock.unlockWrite(stamp);
        if (co != null) {
            this.onRemove(co.key, co.obj);
        }
        return null;
    }
}

