/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.core.date.DateUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public class CacheObj<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final K key;
    protected final V obj;
    protected volatile long lastAccess;
    protected AtomicLong accessCount = new AtomicLong();
    protected final long ttl;

    /*
     * WARNING - void declaration
     */
    protected CacheObj(K key, V obj, long ttl) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.key = var1_1;
        this.obj = var2_2;
        this.ttl = var3_3;
        this.lastAccess = System.currentTimeMillis();
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.obj;
    }

    public long getTtl() {
        return this.ttl;
    }

    public Date getExpiredTime() {
        if (this.ttl > 0L) {
            return DateUtil.date(this.lastAccess + this.ttl);
        }
        return null;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public String toString() {
        return "CacheObj [key=" + this.key + ", obj=" + this.obj + ", lastAccess=" + this.lastAccess + ", accessCount=" + this.accessCount + ", ttl=" + this.ttl + "]";
    }

    protected boolean isExpired() {
        if (this.ttl > 0L) {
            return System.currentTimeMillis() - this.lastAccess > this.ttl;
        }
        return false;
    }

    protected V get(boolean isUpdateLastAccess) {
        if (isUpdateLastAccess) {
            this.lastAccess = System.currentTimeMillis();
        }
        this.accessCount.getAndIncrement();
        return this.obj;
    }
}

