/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.file;

import cn.hutool.cache.Cache;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import java.io.File;
import java.io.Serializable;

public abstract class AbstractFileCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final int capacity;
    protected final int maxFileSize;
    protected final long timeout;
    protected final Cache<File, byte[]> cache;
    protected int usedSize;

    /*
     * WARNING - void declaration
     */
    public AbstractFileCache(int capacity, int maxFileSize, long timeout) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.capacity = var1_1;
        this.maxFileSize = var2_2;
        this.timeout = var3_3;
        this.cache = this.initCache();
    }

    public int capacity() {
        return this.capacity;
    }

    public int getUsedSize() {
        return this.usedSize;
    }

    public int maxFileSize() {
        return this.maxFileSize;
    }

    public int getCachedFilesCount() {
        return this.cache.size();
    }

    public long timeout() {
        return this.timeout;
    }

    public void clear() {
        this.cache.clear();
        this.usedSize = 0;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getFileBytes(String path) throws IORuntimeException {
        void var1_1;
        return this.getFileBytes(new File((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getFileBytes(File file) throws IORuntimeException {
        void var2_2;
        void var1_1;
        byte[] bytes = this.cache.get(file);
        if (bytes != null) {
            return bytes;
        }
        bytes = FileUtil.readBytes(file);
        if (this.maxFileSize != 0 && file.length() > (long)this.maxFileSize) {
            return bytes;
        }
        this.usedSize += bytes.length;
        this.cache.put((File)var1_1, bytes);
        return var2_2;
    }

    protected abstract Cache<File, byte[]> initCache();
}

