/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.bloomfilter.filter;

import cn.hutool.bloomfilter.BloomFilter;
import cn.hutool.bloomfilter.bitMap.BitMap;
import cn.hutool.bloomfilter.bitMap.IntMap;
import cn.hutool.bloomfilter.bitMap.LongMap;

public abstract class AbstractFilter
implements BloomFilter {
    private static final long serialVersionUID = 1L;
    protected static int DEFAULT_MACHINE_NUM = 32;
    private BitMap bm = null;
    protected long size;

    /*
     * WARNING - void declaration
     */
    public AbstractFilter(long maxValue, int machineNum) {
        void var3_2;
        void var1_1;
        this.init((long)var1_1, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractFilter(long maxValue) {
        this((long)var1_1, DEFAULT_MACHINE_NUM);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void init(long maxValue, int machineNum) {
        void var1_1;
        this.size = var1_1;
        switch (machineNum) {
            case 32: {
                this.bm = new IntMap((int)(this.size / (long)machineNum));
                return;
            }
            case 64: {
                void var3_2;
                this.bm = new LongMap((int)(this.size / (long)var3_2));
                return;
            }
        }
        throw new RuntimeException("Error Machine number!");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(String str) {
        void var1_1;
        return this.bm.contains(Math.abs(this.hash((String)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(String str) {
        void var2_2;
        void var1_1;
        long hash = Math.abs(this.hash((String)var1_1));
        if (this.bm.contains(hash)) {
            return false;
        }
        this.bm.add((long)var2_2);
        return true;
    }

    public abstract long hash(String var1);
}

