/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.bloomfilter;

import cn.hutool.bloomfilter.BloomFilter;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HashUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.BitSet;

public class BitSetBloomFilter
implements BloomFilter {
    private static final long serialVersionUID = 1L;
    private final BitSet bitSet;
    private final int bitSetSize;
    private final int addedElements;
    private final int hashFunctionNumber;

    /*
     * WARNING - void declaration
     */
    public BitSetBloomFilter(int c, int n, int k) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.hashFunctionNumber = k;
        this.bitSetSize = var1_1 * var3_3;
        this.addedElements = var2_2;
        this.bitSet = new BitSet(this.bitSetSize);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void init(String path, String charsetName) throws IOException {
        void var2_2;
        void var1_1;
        this.init((String)var1_1, CharsetUtil.charset((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void init(String path, Charset charset) throws IOException {
        BufferedReader reader = FileUtil.getReader(path, charset);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                void var2_2;
                this.add((String)var2_2);
            }
        }
        catch (Throwable throwable) {
            void var1_1;
            IoUtil.close((Closeable)var1_1);
            throw throwable;
        }
        IoUtil.close(reader);
    }

    @Override
    public boolean add(String str) {
        int[] nArray;
        if (this.contains(str)) {
            return false;
        }
        int[] nArray2 = BitSetBloomFilter.createHashes((String)nArray, this.hashFunctionNumber);
        nArray = nArray2;
        nArray = nArray2;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int position = Math.abs(n2 % this.bitSetSize);
            this.bitSet.set(position, true);
        }
        return true;
    }

    @Override
    public boolean contains(String str) {
        int[] nArray = BitSetBloomFilter.createHashes(str, this.hashFunctionNumber);
        int[] nArray2 = nArray;
        nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            int position = Math.abs(n2 % this.bitSetSize);
            if (this.bitSet.get(position)) continue;
            return false;
        }
        return true;
    }

    public double getFalsePositiveProbability() {
        return Math.pow(1.0 - Math.exp((double)(-this.hashFunctionNumber) * (double)this.addedElements / (double)this.bitSetSize), this.hashFunctionNumber);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] createHashes(String str, int hashNumber) {
        void var2_2;
        int[] result = new int[hashNumber];
        for (int i = 0; i < hashNumber; ++i) {
            result[i] = BitSetBloomFilter.hash(str, i);
        }
        return var2_2;
    }

    public static int hash(String str, int k) {
        switch (k) {
            case 0: {
                return HashUtil.rsHash(str);
            }
            case 1: {
                return HashUtil.jsHash(str);
            }
            case 2: {
                return HashUtil.elfHash(str);
            }
            case 3: {
                return HashUtil.bkdrHash(str);
            }
            case 4: {
                return HashUtil.apHash(str);
            }
            case 5: {
                return HashUtil.djbHash(str);
            }
            case 6: {
                return HashUtil.sdbmHash(str);
            }
            case 7: {
                String string;
                return HashUtil.pjwHash(string);
            }
        }
        return 0;
    }
}

