/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\u0000H\u0016J\b\u0010\u000f\u001a\u00020\u0000H\u0016J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J-\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0018H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\nH\u0016J\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0001H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"Lokio/Timeout;", "", "()V", "cancelMark", "deadlineNanoTime", "", "hasDeadline", "", "timeoutNanos", "awaitSignal", "", "condition", "Ljava/util/concurrent/locks/Condition;", "cancel", "clearDeadline", "clearTimeout", "deadline", "duration", "unit", "Ljava/util/concurrent/TimeUnit;", "intersectWith", "T", "other", "block", "Lkotlin/Function0;", "(Lokio/Timeout;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "throwIfReached", "timeout", "waitUntilNotified", "monitor", "Companion", "okio"})
@SourceDebugExtension(value={"SMAP\nTimeout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Timeout.kt\nokio/Timeout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1#2:359\n*E\n"})
public class Timeout {
    public static final Companion Companion = new Companion(null);
    private boolean hasDeadline;
    private long deadlineNanoTime;
    private long timeoutNanos;
    private volatile Object cancelMark;
    @JvmField
    public static final Timeout NONE = new Timeout(){

        public final Timeout timeout(long timeout, TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            return this;
        }

        public final Timeout deadlineNanoTime(long deadlineNanoTime) {
            return this;
        }

        public final void throwIfReached() {
        }
    };

    /*
     * WARNING - void declaration
     */
    public Timeout timeout(long timeout2, TimeUnit unit) {
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!(timeout2 >= 0L)) {
            String timeout2 = "timeout < 0: " + timeout2;
            throw new IllegalArgumentException(timeout2.toString());
        }
        this.timeoutNanos = var3_3.toNanos((long)var1_1);
        return this;
    }

    public long timeoutNanos() {
        return this.timeoutNanos;
    }

    public boolean hasDeadline() {
        return this.hasDeadline;
    }

    public long deadlineNanoTime() {
        if (!this.hasDeadline) {
            String string = "No deadline";
            throw new IllegalStateException(string.toString());
        }
        return this.deadlineNanoTime;
    }

    /*
     * WARNING - void declaration
     */
    public Timeout deadlineNanoTime(long deadlineNanoTime) {
        void var1_1;
        this.hasDeadline = true;
        this.deadlineNanoTime = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Timeout deadline(long duration2, TimeUnit unit) {
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!(duration2 > 0L)) {
            String duration2 = "duration <= 0: " + duration2;
            throw new IllegalArgumentException(duration2.toString());
        }
        return this.deadlineNanoTime(System.nanoTime() + var3_3.toNanos((long)var1_1));
    }

    public Timeout clearTimeout() {
        this.timeoutNanos = 0L;
        return this;
    }

    public Timeout clearDeadline() {
        this.hasDeadline = false;
        return this;
    }

    public void throwIfReached() throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException("interrupted");
        }
        if (this.hasDeadline && this.deadlineNanoTime - System.nanoTime() <= 0L) {
            throw new InterruptedIOException("deadline reached");
        }
    }

    public void cancel() {
        this.cancelMark = new Object();
    }

    /*
     * WARNING - void declaration
     */
    public void awaitSignal(Condition condition) throws InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        try {
            void var1_1;
            void waitNanos;
            long l;
            boolean hasDeadline = this.hasDeadline();
            long timeoutNanos = this.timeoutNanos();
            if (!hasDeadline && timeoutNanos == 0L) {
                condition.await();
                return;
            }
            if (hasDeadline && timeoutNanos != 0L) {
                long deadlineNanos = this.deadlineNanoTime() - System.nanoTime();
                l = Math.min(timeoutNanos, deadlineNanos);
            } else {
                void var3_3;
                void var2_2;
                l = waitNanos = var2_2 != false ? this.deadlineNanoTime() - System.nanoTime() : var3_3;
            }
            if (l <= 0L) {
                throw new InterruptedIOException("timeout");
            }
            Object cancelMarkBefore = this.cancelMark;
            long l2 = var1_1.awaitNanos((long)waitNanos);
            if (l2 > 0L) {
                return;
            }
            if (this.cancelMark != cancelMarkBefore) {
                return;
            }
            throw new InterruptedIOException("timeout");
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("interrupted");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void waitUntilNotified(Object monitor) throws InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        try {
            void var1_1;
            void waitNanos;
            long l;
            boolean hasDeadline = this.hasDeadline();
            long timeoutNanos = this.timeoutNanos();
            if (!hasDeadline && timeoutNanos == 0L) {
                monitor.wait();
                return;
            }
            long start = System.nanoTime();
            if (hasDeadline && timeoutNanos != 0L) {
                long deadlineNanos = this.deadlineNanoTime() - start;
                l = Math.min(timeoutNanos, deadlineNanos);
            } else {
                void var3_3;
                void var2_2;
                l = waitNanos = var2_2 != false ? this.deadlineNanoTime() - start : var3_3;
            }
            if (l <= 0L) {
                throw new InterruptedIOException("timeout");
            }
            Object cancelMarkBefore = this.cancelMark;
            void waitMillis = waitNanos / 1000000L;
            var1_1.wait((long)waitMillis, (int)(waitNanos - waitMillis * 1000000L));
            long l2 = System.nanoTime() - start;
            if (l2 < waitNanos) {
                return;
            }
            if (this.cancelMark != cancelMarkBefore) {
                return;
            }
            throw new InterruptedIOException("timeout");
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("interrupted");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T intersectWith(Timeout other, Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long originalTimeout = this.timeoutNanos();
        this.timeout(Companion.minTimeout(other.timeoutNanos(), this.timeoutNanos()), TimeUnit.NANOSECONDS);
        if (this.hasDeadline()) {
            long originalDeadline = this.deadlineNanoTime();
            if (other.hasDeadline()) {
                Timeout timeout = this;
                timeout.deadlineNanoTime(Math.min(timeout.deadlineNanoTime(), other.deadlineNanoTime()));
            }
            try {
                block = block.invoke();
                return (T)block;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this.timeout(originalTimeout, TimeUnit.NANOSECONDS);
                if (other.hasDeadline()) {
                    this.deadlineNanoTime(originalDeadline);
                }
                InlineMarker.finallyEnd((int)1);
            }
        }
        if (other.hasDeadline()) {
            this.deadlineNanoTime(other.deadlineNanoTime());
        }
        try {
            void var2_2;
            object = var2_2.invoke();
        }
        catch (Throwable throwable) {
            void var1_1;
            void var3_4;
            InlineMarker.finallyStart((int)1);
            this.timeout((long)var3_4, TimeUnit.NANOSECONDS);
            if (var1_1.hasDeadline()) {
                this.clearDeadline();
            }
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        this.timeout(originalTimeout, TimeUnit.NANOSECONDS);
        if (other.hasDeadline()) {
            this.clearDeadline();
        }
        InlineMarker.finallyEnd((int)1);
        return (T)object;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u001a\u0010\t\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\t\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0010"}, d2={"Lokio/Timeout$Companion;", "", "()V", "NONE", "Lokio/Timeout;", "minTimeout", "", "aNanos", "bNanos", "timeout", "unit", "Lkotlin/time/DurationUnit;", "duration", "Lkotlin/time/Duration;", "timeout-HG0u8IE", "(Lokio/Timeout;J)Lokio/Timeout;", "okio"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final Timeout timeout(Timeout $this$timeout, long timeout, DurationUnit unit) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$timeout, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            return var1_1.timeout((long)var2_2, DurationUnitKt.toTimeUnit((DurationUnit)unit));
        }

        /*
         * WARNING - void declaration
         */
        public final Timeout timeout-HG0u8IE(Timeout $this$timeout_u2dHG0u8IE, long duration) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$timeout_u2dHG0u8IE, (String)"$this$timeout");
            return var1_1.timeout(Duration.getInWholeNanoseconds-impl((long)var2_2), TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - void declaration
         */
        public final long minTimeout(long aNanos, long bNanos) {
            void var3_2;
            if (aNanos != 0L) {
                if (bNanos == 0L) {
                    return aNanos;
                }
                if (aNanos < bNanos) {
                    void var1_1;
                    return (long)var1_1;
                }
            }
            return (long)var3_2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

