/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.Sink;
import okio.Source;
import okio.Timeout;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u0014J\r\u0010\u001f\u001a\u00020\u0014H\u0007\u00a2\u0006\u0002\b,J\r\u0010#\u001a\u00020$H\u0007\u00a2\u0006\u0002\b-J&\u0010.\u001a\u00020**\u00020\u00142\u0017\u0010/\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020*00\u00a2\u0006\u0002\b1H\u0082\bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u00020\u00148G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u001a\u0010 \u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\f\"\u0004\b\"\u0010\u000eR\u0013\u0010#\u001a\u00020$8G\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010%R\u001a\u0010&\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\f\"\u0004\b(\u0010\u000e\u00a8\u00062"}, d2={"Lokio/Pipe;", "", "maxBufferSize", "", "(J)V", "buffer", "Lokio/Buffer;", "getBuffer$okio", "()Lokio/Buffer;", "canceled", "", "getCanceled$okio", "()Z", "setCanceled$okio", "(Z)V", "condition", "Ljava/util/concurrent/locks/Condition;", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "foldedSink", "Lokio/Sink;", "getFoldedSink$okio", "()Lokio/Sink;", "setFoldedSink$okio", "(Lokio/Sink;)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "getMaxBufferSize$okio", "()J", "sink", "sinkClosed", "getSinkClosed$okio", "setSinkClosed$okio", "source", "Lokio/Source;", "()Lokio/Source;", "sourceClosed", "getSourceClosed$okio", "setSourceClosed$okio", "cancel", "", "fold", "-deprecated_sink", "-deprecated_source", "forward", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "okio"})
@SourceDebugExtension(value={"SMAP\nPipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pipe.kt\nokio/Pipe\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timeout.kt\nokio/Timeout\n*L\n1#1,262:1\n1#2:263\n302#3,26:264\n*S KotlinDebug\n*F\n+ 1 Pipe.kt\nokio/Pipe\n*L\n222#1:264,26\n*E\n"})
public final class Pipe {
    private final long maxBufferSize;
    private final Buffer buffer;
    private boolean canceled;
    private boolean sinkClosed;
    private boolean sourceClosed;
    private Sink foldedSink;
    private final ReentrantLock lock;
    private final Condition condition;
    private final Sink sink;
    private final Source source;

    /*
     * WARNING - void declaration
     */
    public Pipe(long maxBufferSize) {
        void var1_1;
        this.maxBufferSize = var1_1;
        this.buffer = new Buffer();
        this.lock = new ReentrantLock();
        Condition condition = this.lock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"newCondition(...)");
        this.condition = condition;
        if (!(this.maxBufferSize >= 1L)) {
            String string = "maxBufferSize < 1: " + this.maxBufferSize;
            throw new IllegalArgumentException(string.toString());
        }
        this.sink = new Sink(this){
            private final Timeout timeout;
            final /* synthetic */ Pipe this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.timeout = new Timeout();
            }

            /*
             * WARNING - void declaration
             */
            public final void write(Buffer source2, long byteCount) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
                long byteCount2 = byteCount;
                Sink delegate = null;
                Object object2 = this.this$0.getLock();
                Pipe pipe = this.this$0;
                object2.lock();
                try {
                    if (!(!pipe.getSinkClosed$okio())) {
                        source2 = "closed";
                        throw new IllegalStateException(source2.toString());
                    }
                    if (pipe.getCanceled$okio()) {
                        throw new IOException("canceled");
                    }
                    while (byteCount2 > 0L) {
                        Sink sink2 = pipe.getFoldedSink$okio();
                        if (sink2 != null) {
                            object = sink2;
                            delegate = sink2;
                            break;
                        }
                        if (pipe.getSourceClosed$okio()) {
                            throw new IOException("source is closed");
                        }
                        long bufferSpaceAvailable = pipe.getMaxBufferSize$okio() - pipe.getBuffer$okio().size();
                        if (bufferSpaceAvailable == 0L) {
                            this.timeout.awaitSignal(pipe.getCondition());
                            if (!pipe.getCanceled$okio()) continue;
                            throw new IOException("canceled");
                        }
                        long bytesToWrite = Math.min(bufferSpaceAvailable, byteCount2);
                        pipe.getBuffer$okio().write((Buffer)source2, bytesToWrite);
                        byteCount2 -= bytesToWrite;
                        pipe.getCondition().signalAll();
                    }
                }
                finally {
                    object2.unlock();
                }
                object2 = delegate;
                if (object2 != null) {
                    void this_$iv$iv;
                    void this_$iv;
                    pipe = this.this$0;
                    Object $this$forward$iv = object2;
                    object = $this$forward$iv.timeout();
                    Timeout other$iv$iv = this_$iv.sink().timeout();
                    long originalTimeout$iv$iv = this_$iv$iv.timeoutNanos();
                    this_$iv$iv.timeout(Timeout.Companion.minTimeout(other$iv$iv.timeoutNanos(), this_$iv$iv.timeoutNanos()), TimeUnit.NANOSECONDS);
                    if (this_$iv$iv.hasDeadline()) {
                        long originalDeadline$iv$iv = this_$iv$iv.deadlineNanoTime();
                        if (other$iv$iv.hasDeadline()) {
                            void v1 = this_$iv$iv;
                            v1.deadlineNanoTime(Math.min(v1.deadlineNanoTime(), other$iv$iv.deadlineNanoTime()));
                        }
                        try {
                            $this$forward$iv.write((Buffer)source2, byteCount2);
                            return;
                        }
                        finally {
                            this_$iv$iv.timeout(originalTimeout$iv$iv, TimeUnit.NANOSECONDS);
                            if (other$iv$iv.hasDeadline()) {
                                this_$iv$iv.deadlineNanoTime(originalDeadline$iv$iv);
                            }
                        }
                    }
                    if (other$iv$iv.hasDeadline()) {
                        this_$iv$iv.deadlineNanoTime(other$iv$iv.deadlineNanoTime());
                    }
                    try {
                        void var1_1;
                        void var2_5;
                        var2_5.write((Buffer)var1_1, byteCount2);
                        return;
                    }
                    finally {
                        this_$iv$iv.timeout(originalTimeout$iv$iv, TimeUnit.NANOSECONDS);
                        if (other$iv$iv.hasDeadline()) {
                            this_$iv$iv.clearDeadline();
                        }
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void flush() {
                Object object;
                Object delegate = null;
                Object object2 = this.this$0.getLock();
                Pipe pipe = this.this$0;
                object2.lock();
                try {
                    if (!(!pipe.getSinkClosed$okio())) {
                        delegate = "closed";
                        throw new IllegalStateException(delegate.toString());
                    }
                    if (pipe.getCanceled$okio()) {
                        throw new IOException("canceled");
                    }
                    Sink sink2 = pipe.getFoldedSink$okio();
                    if (sink2 != null) {
                        object = sink2;
                        delegate = sink2;
                    } else if (pipe.getSourceClosed$okio() && pipe.getBuffer$okio().size() > 0L) {
                        throw new IOException("source is closed");
                    }
                }
                finally {
                    object2.unlock();
                }
                object2 = delegate;
                if (object2 != null) {
                    void this_$iv$iv;
                    pipe = this.this$0;
                    Object $this$forward$iv = object2;
                    object = $this$forward$iv.timeout();
                    Timeout other$iv$iv = pipe.sink().timeout();
                    long originalTimeout$iv$iv = this_$iv$iv.timeoutNanos();
                    this_$iv$iv.timeout(Timeout.Companion.minTimeout(other$iv$iv.timeoutNanos(), this_$iv$iv.timeoutNanos()), TimeUnit.NANOSECONDS);
                    if (this_$iv$iv.hasDeadline()) {
                        long originalDeadline$iv$iv = this_$iv$iv.deadlineNanoTime();
                        if (other$iv$iv.hasDeadline()) {
                            void v1 = this_$iv$iv;
                            v1.deadlineNanoTime(Math.min(v1.deadlineNanoTime(), other$iv$iv.deadlineNanoTime()));
                        }
                        try {
                            $this$forward$iv.flush();
                            return;
                        }
                        finally {
                            this_$iv$iv.timeout(originalTimeout$iv$iv, TimeUnit.NANOSECONDS);
                            if (other$iv$iv.hasDeadline()) {
                                this_$iv$iv.deadlineNanoTime(originalDeadline$iv$iv);
                            }
                        }
                    }
                    if (other$iv$iv.hasDeadline()) {
                        this_$iv$iv.deadlineNanoTime(other$iv$iv.deadlineNanoTime());
                    }
                    try {
                        void var1_1;
                        var1_1.flush();
                        return;
                    }
                    finally {
                        this_$iv$iv.timeout(originalTimeout$iv$iv, TimeUnit.NANOSECONDS);
                        if (other$iv$iv.hasDeadline()) {
                            this_$iv$iv.clearDeadline();
                        }
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void close() {
                Sink delegate = null;
                Object object = this.this$0.getLock();
                Pipe pipe = this.this$0;
                object.lock();
                try {
                    if (pipe.getSinkClosed$okio()) {
                        return;
                    }
                    Sink sink2 = pipe.getFoldedSink$okio();
                    if (sink2 != null) {
                        delegate = sink2;
                        delegate = sink2;
                    } else {
                        if (pipe.getSourceClosed$okio() && pipe.getBuffer$okio().size() > 0L) {
                            throw new IOException("source is closed");
                        }
                        pipe.setSinkClosed$okio(true);
                        pipe.getCondition().signalAll();
                    }
                }
                finally {
                    object.unlock();
                }
                object = delegate;
                if (object != null) {
                    void this_$iv$iv;
                    void this_$iv;
                    pipe = this.this$0;
                    Object $this$forward$iv = object;
                    object = $this$forward$iv.timeout();
                    Timeout other$iv$iv = this_$iv.sink().timeout();
                    long originalTimeout$iv$iv = this_$iv$iv.timeoutNanos();
                    this_$iv$iv.timeout(Timeout.Companion.minTimeout(other$iv$iv.timeoutNanos(), this_$iv$iv.timeoutNanos()), TimeUnit.NANOSECONDS);
                    if (this_$iv$iv.hasDeadline()) {
                        long originalDeadline$iv$iv = this_$iv$iv.deadlineNanoTime();
                        if (other$iv$iv.hasDeadline()) {
                            void v1 = this_$iv$iv;
                            v1.deadlineNanoTime(Math.min(v1.deadlineNanoTime(), other$iv$iv.deadlineNanoTime()));
                        }
                        try {
                            $this$forward$iv.close();
                            return;
                        }
                        finally {
                            this_$iv$iv.timeout(originalTimeout$iv$iv, TimeUnit.NANOSECONDS);
                            if (other$iv$iv.hasDeadline()) {
                                this_$iv$iv.deadlineNanoTime(originalDeadline$iv$iv);
                            }
                        }
                    }
                    if (other$iv$iv.hasDeadline()) {
                        this_$iv$iv.deadlineNanoTime(other$iv$iv.deadlineNanoTime());
                    }
                    try {
                        void var1_1;
                        var1_1.close();
                        this_$iv$iv.timeout(originalTimeout$iv$iv, TimeUnit.NANOSECONDS);
                    }
                    catch (Throwable throwable) {
                        this_$iv$iv.timeout(originalTimeout$iv$iv, TimeUnit.NANOSECONDS);
                        if (((Timeout)((Object)pipe)).hasDeadline()) {
                            ((Timeout)object).clearDeadline();
                        }
                        throw throwable;
                    }
                    if (other$iv$iv.hasDeadline()) {
                        this_$iv$iv.clearDeadline();
                    }
                    return;
                }
            }

            public final Timeout timeout() {
                return this.timeout;
            }
        };
        this.source = new Source(this){
            private final Timeout timeout;
            final /* synthetic */ Pipe this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.timeout = new Timeout();
            }

            /*
             * WARNING - void declaration
             */
            public final long read(Buffer sink2, long byteCount) {
                Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
                Lock lock = this.this$0.getLock();
                Pipe pipe = this.this$0;
                lock.lock();
                try {
                    void var2_3;
                    void var1_1;
                    if (!(!pipe.getSourceClosed$okio())) {
                        sink2 = "closed";
                        throw new IllegalStateException(sink2.toString());
                    }
                    if (pipe.getCanceled$okio()) {
                        throw new IOException("canceled");
                    }
                    while (pipe.getBuffer$okio().size() == 0L) {
                        if (pipe.getSinkClosed$okio()) {
                            return -1L;
                        }
                        this.timeout.awaitSignal(pipe.getCondition());
                        if (!pipe.getCanceled$okio()) continue;
                        throw new IOException("canceled");
                    }
                    long result = pipe.getBuffer$okio().read((Buffer)var1_1, (long)var2_3);
                    pipe.getCondition().signalAll();
                    long l = result;
                    return l;
                }
                finally {
                    lock.unlock();
                }
            }

            public final void close() {
                Lock lock = this.this$0.getLock();
                Pipe pipe = this.this$0;
                lock.lock();
                try {
                    pipe.setSourceClosed$okio(true);
                    pipe.getCondition().signalAll();
                    return;
                }
                finally {
                    lock.unlock();
                }
            }

            public final Timeout timeout() {
                return this.timeout;
            }
        };
    }

    public final long getMaxBufferSize$okio() {
        return this.maxBufferSize;
    }

    public final Buffer getBuffer$okio() {
        return this.buffer;
    }

    public final boolean getCanceled$okio() {
        return this.canceled;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCanceled$okio(boolean bl) {
        void var1_1;
        this.canceled = var1_1;
    }

    public final boolean getSinkClosed$okio() {
        return this.sinkClosed;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSinkClosed$okio(boolean bl) {
        void var1_1;
        this.sinkClosed = var1_1;
    }

    public final boolean getSourceClosed$okio() {
        return this.sourceClosed;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSourceClosed$okio(boolean bl) {
        void var1_1;
        this.sourceClosed = var1_1;
    }

    public final Sink getFoldedSink$okio() {
        return this.foldedSink;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFoldedSink$okio(Sink sink2) {
        void var1_1;
        this.foldedSink = var1_1;
    }

    public final ReentrantLock getLock() {
        return this.lock;
    }

    public final Condition getCondition() {
        return this.condition;
    }

    @JvmName(name="sink")
    public final Sink sink() {
        return this.sink;
    }

    @JvmName(name="source")
    public final Source source() {
        return this.source;
    }

    /*
     * WARNING - void declaration
     */
    public final void fold(Sink sink2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        while (true) {
            void var3_8;
            boolean done = false;
            Buffer sinkBuffer = null;
            Lock lock = this.lock;
            lock.lock();
            try {
                if (!(this.foldedSink == null)) {
                    String string = "sink already folded";
                    throw new IllegalStateException(string.toString());
                }
                if (this.canceled) {
                    this.foldedSink = sink2;
                    throw new IOException("canceled");
                }
                boolean closed = this.sinkClosed;
                if (this.buffer.exhausted()) {
                    this.sourceClosed = true;
                    this.foldedSink = sink2;
                    done = true;
                } else {
                    sinkBuffer = new Buffer();
                    sinkBuffer.write(this.buffer, this.buffer.size());
                    this.condition.signalAll();
                }
            }
            finally {
                lock.unlock();
            }
            if (var3_8 != false) {
                void var2_5;
                if (var2_5 != false) {
                    sink2.close();
                }
                return;
            }
            try {
                Buffer buffer = sinkBuffer;
                sink2.write(buffer, buffer.size());
                sink2.flush();
            }
            catch (Throwable throwable) {
                Lock lock2 = this.lock;
                lock2.lock();
                try {
                    this.sourceClosed = true;
                    this.condition.signalAll();
                }
                finally {
                    lock2.unlock();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void forward(Sink $this$forward, Function1<? super Sink, Unit> block) {
        void this_$iv;
        Timeout timeout = $this$forward.timeout();
        Timeout other$iv = this.sink().timeout();
        long originalTimeout$iv = this_$iv.timeoutNanos();
        this_$iv.timeout(Timeout.Companion.minTimeout(other$iv.timeoutNanos(), this_$iv.timeoutNanos()), TimeUnit.NANOSECONDS);
        if (this_$iv.hasDeadline()) {
            long originalDeadline$iv = this_$iv.deadlineNanoTime();
            if (other$iv.hasDeadline()) {
                void v0 = this_$iv;
                v0.deadlineNanoTime(Math.min(v0.deadlineNanoTime(), other$iv.deadlineNanoTime()));
            }
            try {
                block.invoke((Object)$this$forward);
                return;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this_$iv.timeout(originalTimeout$iv, TimeUnit.NANOSECONDS);
                if (other$iv.hasDeadline()) {
                    this_$iv.deadlineNanoTime(originalDeadline$iv);
                }
                InlineMarker.finallyEnd((int)1);
            }
        }
        if (other$iv.hasDeadline()) {
            this_$iv.deadlineNanoTime(other$iv.deadlineNanoTime());
        }
        try {
            void var1_1;
            void var2_4;
            var2_4.invoke((Object)var1_1);
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            this_$iv.timeout(originalTimeout$iv, TimeUnit.NANOSECONDS);
            if (other$iv.hasDeadline()) {
                timeout.clearDeadline();
            }
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        this_$iv.timeout(originalTimeout$iv, TimeUnit.NANOSECONDS);
        if (other$iv.hasDeadline()) {
            this_$iv.clearDeadline();
        }
        InlineMarker.finallyEnd((int)1);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="sink", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_sink")
    public final Sink -deprecated_sink() {
        return this.sink;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="source", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_source")
    public final Source -deprecated_source() {
        return this.source;
    }

    public final void cancel() {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.canceled = true;
            this.buffer.clear();
            this.condition.signalAll();
            return;
        }
        finally {
            lock.unlock();
        }
    }
}

