/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.JvmFileHandle;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\f\u0010!\u001a\u00020\n*\u00020\u0006H\u0002J\f\u0010\"\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006#"}, d2={"Lokio/JvmSystemFileSystem;", "Lokio/FileSystem;", "()V", "appendingSink", "Lokio/Sink;", "file", "Lokio/Path;", "mustExist", "", "atomicMove", "", "source", "target", "canonicalize", "path", "createDirectory", "dir", "mustCreate", "createSymlink", "delete", "list", "", "throwOnFailure", "listOrNull", "metadataOrNull", "Lokio/FileMetadata;", "openReadOnly", "Lokio/FileHandle;", "openReadWrite", "sink", "Lokio/Source;", "toString", "", "requireCreate", "requireExist", "okio"})
@SourceDebugExtension(value={"SMAP\nJvmSystemFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSystemFileSystem.kt\nokio/JvmSystemFileSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,158:1\n11400#2,3:159\n*S KotlinDebug\n*F\n+ 1 JvmSystemFileSystem.kt\nokio/JvmSystemFileSystem\n*L\n77#1:159,3\n*E\n"})
public class JvmSystemFileSystem
extends FileSystem {
    /*
     * WARNING - void declaration
     */
    @Override
    public Path canonicalize(Path path) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File canonicalFile = path.toFile().getCanonicalFile();
        if (!canonicalFile.exists()) {
            throw new FileNotFoundException("no such file");
        }
        Intrinsics.checkNotNull((Object)canonicalFile);
        return Path.Companion.get$default(Path.Companion, (File)var1_1, false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileMetadata metadataOrNull(Path path) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        boolean isRegularFile = file.isFile();
        boolean isDirectory = file.isDirectory();
        long lastModifiedAtMillis = file.lastModified();
        long size = file.length();
        if (!(isRegularFile || isDirectory || lastModifiedAtMillis != 0L || size != 0L || var1_1.exists())) {
            return null;
        }
        return new FileMetadata((boolean)var2_2, (boolean)var3_3, null, size, null, lastModifiedAtMillis, null, null, 128, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Path> list(Path dir) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        List<Path> list = this.list((Path)var1_1, true);
        Intrinsics.checkNotNull(list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Path> listOrNull(Path dir) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.list((Path)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> list(Path dir, boolean throwOnFailure2) {
        void var1_1;
        void var3_4;
        void $this$mapTo$iv;
        File file = dir.toFile();
        String[] entries = file.list();
        if (entries == null) {
            if (throwOnFailure2) {
                if (!file.exists()) {
                    throw new FileNotFoundException("no such file: " + dir);
                }
                throw new IOException("failed to list " + dir);
            }
            return null;
        }
        String[] throwOnFailure2 = entries;
        Collection destination$iv = new ArrayList();
        for (void item$iv : $this$mapTo$iv) {
            void it;
            Collection collection = destination$iv;
            Intrinsics.checkNotNull((Object)it);
            collection.add(dir.resolve((String)it));
        }
        List result = (List)var3_4;
        CollectionsKt.sort((List)result);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileHandle openReadOnly(Path file) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new JvmFileHandle(false, new RandomAccessFile(var1_1.toFile(), "r"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FileHandle openReadWrite(Path file, boolean mustCreate, boolean mustExist) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(!mustCreate || !mustExist)) {
            file = "Cannot require mustCreate and mustExist at the same time.";
            throw new IllegalArgumentException(file.toString());
        }
        if (var2_2 != false) {
            this.requireCreate((Path)file);
        }
        if (var3_3 != false) {
            this.requireExist((Path)file);
        }
        return new JvmFileHandle(true, new RandomAccessFile(var1_1.toFile(), "rw"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Source source(Path file) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Okio.source(var1_1.toFile());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Sink sink(Path file, boolean mustCreate) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (var2_2 != false) {
            this.requireCreate(file);
        }
        return Okio.sink$default(var1_1.toFile(), false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Sink appendingSink(Path file, boolean mustExist) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (var2_2 != false) {
            this.requireExist(file);
        }
        return Okio.sink(var1_1.toFile(), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createDirectory(Path dir, boolean mustCreate) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.toFile().mkdir()) {
            void var1_1;
            boolean bl;
            FileMetadata fileMetadata = ((FileSystem)this).metadataOrNull(dir);
            boolean bl2 = fileMetadata != null ? fileMetadata.isDirectory() : (bl = false);
            if (bl2) {
                void var2_2;
                if (var2_2 != false) {
                    throw new IOException(dir + " already exists.");
                }
                return;
            }
            throw new IOException("failed to create directory: " + var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atomicMove(Path source2, Path target) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean bl = source2.toFile().renameTo(target.toFile());
        if (!bl) {
            void var2_2;
            void var1_1;
            throw new IOException("failed to move " + var1_1 + " to " + var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void delete(Path path, boolean mustExist) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Thread.interrupted()) {
            throw new InterruptedIOException("interrupted");
        }
        File file = path.toFile();
        boolean bl = file.delete();
        if (!bl) {
            void var2_2;
            void var3_3;
            if (var3_3.exists()) {
                throw new IOException("failed to delete " + path);
            }
            if (var2_2 != false) {
                void var1_1;
                throw new FileNotFoundException("no such file: " + var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createSymlink(Path source2, Path target) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"target");
        throw new IOException("unsupported");
    }

    public String toString() {
        return "JvmSystemFileSystem";
    }

    /*
     * WARNING - void declaration
     */
    private final void requireExist(Path $this$requireExist) {
        if (!this.exists($this$requireExist)) {
            void var1_1;
            throw new IOException(var1_1 + " doesn't exist.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void requireCreate(Path $this$requireCreate) {
        if (this.exists($this$requireCreate)) {
            void var1_1;
            throw new IOException(var1_1 + " already exists.");
        }
    }
}

