/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.util.zip.Deflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Timeout;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0002J\r\u0010\u000e\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lokio/DeflaterSink;", "Lokio/Sink;", "sink", "deflater", "Ljava/util/zip/Deflater;", "(Lokio/Sink;Ljava/util/zip/Deflater;)V", "Lokio/BufferedSink;", "(Lokio/BufferedSink;Ljava/util/zip/Deflater;)V", "closed", "", "close", "", "deflate", "syncFlush", "finishDeflate", "finishDeflate$okio", "flush", "timeout", "Lokio/Timeout;", "toString", "", "write", "source", "Lokio/Buffer;", "byteCount", "", "okio"})
@SourceDebugExtension(value={"SMAP\nDeflaterSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeflaterSink.kt\nokio/DeflaterSink\n+ 2 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,135:1\n86#2:136\n*S KotlinDebug\n*F\n+ 1 DeflaterSink.kt\nokio/DeflaterSink\n*L\n38#1:136\n*E\n"})
public final class DeflaterSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private boolean closed;

    /*
     * WARNING - void declaration
     */
    public DeflaterSink(BufferedSink sink2, Deflater deflater) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)deflater, (String)"deflater");
        this.sink = var1_1;
        this.deflater = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public DeflaterSink(Sink sink2, Deflater deflater) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)deflater, (String)"deflater");
        this(Okio.buffer((Sink)var1_1), (Deflater)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(Buffer source2, long byteCount) throws IOException {
        void var3_5;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        -SegmentedByteString.checkOffsetAndCount(source2.size(), 0L, byteCount);
        for (long remaining = byteCount; remaining > 0L; remaining -= (long)var3_5) {
            void var2_3;
            Segment head;
            Intrinsics.checkNotNull((Object)source2.head);
            int b$iv = head.limit - head.pos;
            int toDeflate = (int)Math.min(remaining, (long)b$iv);
            this.deflater.setInput(head.data, head.pos, toDeflate);
            this.deflate(false);
            Buffer buffer = source2;
            buffer.setSize$okio(buffer.size() - (long)toDeflate);
            head.pos += toDeflate;
            if (head.pos != head.limit) continue;
            source2.head = head.pop();
            SegmentPool.recycle((Segment)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void deflate(boolean syncFlush) {
        Segment s;
        Buffer buffer = this.sink.getBuffer();
        while (true) {
            int n;
            s = buffer.writableSegment$okio(1);
            try {
                n = syncFlush ? this.deflater.deflate(s.data, s.limit, 8192 - s.limit, 2) : this.deflater.deflate(s.data, s.limit, 8192 - s.limit);
            }
            catch (NullPointerException npe) {
                void var1_2;
                throw new IOException("Deflater already closed", (Throwable)var1_2);
            }
            int deflated = n;
            if (deflated > 0) {
                s.limit += deflated;
                Buffer buffer2 = buffer;
                buffer2.setSize$okio(buffer2.size() + (long)deflated);
                this.sink.emitCompleteSegments();
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
        if (s.pos == s.limit) {
            void var3_4;
            var2_3.head = s.pop();
            SegmentPool.recycle((Segment)var3_4);
        }
    }

    @Override
    public final void flush() throws IOException {
        this.deflate(true);
        this.sink.flush();
    }

    public final void finishDeflate$okio() {
        this.deflater.finish();
        this.deflate(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() throws IOException {
        void var1_1;
        block9: {
            Throwable thrown;
            block8: {
                if (this.closed) {
                    return;
                }
                thrown = null;
                try {
                    this.finishDeflate$okio();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    thrown = throwable;
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable e) {
                    if (thrown != null) break block8;
                    thrown = e;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable e) {
                void var2_4;
                if (thrown != null) break block9;
                thrown = var2_4;
            }
        }
        this.closed = true;
        void v1 = var1_1;
        if (v1 != null) {
            throw v1;
        }
    }

    @Override
    public final Timeout timeout() {
        return this.sink.timeout();
    }

    public final String toString() {
        return "DeflaterSink(" + this.sink + ')';
    }
}

