/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.Segment;
import okio.Sink;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0001J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0014J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\fH\u0014J%\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"Lokio/AsyncTimeout;", "Lokio/Timeout;", "()V", "next", "state", "", "timeoutAt", "", "access$newTimeoutException", "Ljava/io/IOException;", "cause", "cancel", "", "enter", "exit", "", "newTimeoutException", "remainingNanos", "now", "sink", "Lokio/Sink;", "source", "Lokio/Source;", "timedOut", "withTimeout", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "Watchdog", "okio"})
@SourceDebugExtension(value={"SMAP\nAsyncTimeout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncTimeout.kt\nokio/AsyncTimeout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n1#2:383\n*E\n"})
public class AsyncTimeout
extends Timeout {
    private static final Companion Companion = new Companion(null);
    private int state;
    private AsyncTimeout next;
    private long timeoutAt;
    private static final ReentrantLock lock = new ReentrantLock();
    private static final Condition condition;
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS;
    private static final long IDLE_TIMEOUT_NANOS;
    private static final int STATE_IDLE = 0;
    private static final int STATE_IN_QUEUE = 1;
    private static final int STATE_TIMED_OUT = 2;
    private static final int STATE_CANCELED = 3;
    private static AsyncTimeout head;

    /*
     * WARNING - void declaration
     */
    public final void enter() {
        long timeoutNanos2 = this.timeoutNanos();
        boolean hasDeadline = this.hasDeadline();
        if (timeoutNanos2 == 0L && !hasDeadline) {
            return;
        }
        Lock lock = AsyncTimeout.lock;
        lock.lock();
        try {
            void var3_4;
            void var1_1;
            if (!(this.state == 0)) {
                String timeoutNanos2 = "Unbalanced enter/exit";
                throw new IllegalStateException(timeoutNanos2.toString());
            }
            this.state = 1;
            okio.AsyncTimeout$Companion.access$insertIntoQueue(Companion, this, (long)var1_1, (boolean)var3_4);
            return;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean exit() {
        int n;
        Lock lock = AsyncTimeout.lock;
        lock.lock();
        try {
            int oldState = this.state;
            this.state = 0;
            if (oldState == 1) {
                okio.AsyncTimeout$Companion.access$removeFromQueue(Companion, this);
                lock.unlock();
                return false;
            }
            n = n == 2 ? 1 : 0;
        }
        catch (Throwable throwable) {
            lock.unlock();
            throw throwable;
        }
        lock.unlock();
        return n != 0;
    }

    @Override
    public void cancel() {
        super.cancel();
        Lock lock = AsyncTimeout.lock;
        lock.lock();
        try {
            if (this.state == 1) {
                okio.AsyncTimeout$Companion.access$removeFromQueue(Companion, this);
                this.state = 3;
            }
            return;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long remainingNanos(long now) {
        void var1_1;
        return this.timeoutAt - var1_1;
    }

    protected void timedOut() {
    }

    /*
     * WARNING - void declaration
     */
    public final Sink sink(Sink sink2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        return new Sink(this, (Sink)var1_1){
            final /* synthetic */ AsyncTimeout this$0;
            final /* synthetic */ Sink $sink;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$sink = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public final void write(Buffer source2, long byteCount) {
                long toWrite;
                Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
                -SegmentedByteString.checkOffsetAndCount(source2.size(), 0L, byteCount);
                for (long remaining = byteCount; remaining > 0L; remaining -= toWrite) {
                    void this_$iv;
                    toWrite = 0L;
                    Intrinsics.checkNotNull((Object)source2.head);
                    while (toWrite < 65536L) {
                        Segment s;
                        int segmentSize = s.limit - s.pos;
                        if ((toWrite += (long)segmentSize) >= remaining) {
                            toWrite = remaining;
                            break;
                        }
                        Intrinsics.checkNotNull((Object)s.next);
                    }
                    AsyncTimeout segmentSize = this.this$0;
                    Sink sink2 = this.$sink;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        sink2.write(source2, toWrite);
                        throwOnTimeout$iv = true;
                        boolean bl = this_$iv.exit();
                        if (!bl) continue;
                    }
                    catch (IOException e$iv) {
                        try {
                            void var1_2;
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException((IOException)var1_2);
                        }
                        catch (Throwable throwable) {
                            boolean bl = this_$iv.exit();
                            if (bl && throwOnTimeout$iv) {
                                void var3_9;
                                throw var3_9.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void flush() {
                block5: {
                    void this_$iv;
                    AsyncTimeout asyncTimeout = this.this$0;
                    Sink sink2 = this.$sink;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        sink2.flush();
                        throwOnTimeout$iv = true;
                        boolean bl = this_$iv.exit();
                        if (!bl) break block5;
                    }
                    catch (IOException e$iv) {
                        try {
                            void var2_4;
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException((IOException)var2_4);
                        }
                        catch (Throwable throwable) {
                            void var3_6;
                            boolean bl = this_$iv.exit();
                            if (bl && var3_6 != false) {
                                throw asyncTimeout.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
                return;
            }

            /*
             * WARNING - void declaration
             */
            public final void close() {
                block5: {
                    void this_$iv;
                    AsyncTimeout asyncTimeout = this.this$0;
                    Sink sink2 = this.$sink;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        sink2.close();
                        throwOnTimeout$iv = true;
                        boolean bl = this_$iv.exit();
                        if (!bl) break block5;
                    }
                    catch (IOException e$iv) {
                        try {
                            void var2_4;
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException((IOException)var2_4);
                        }
                        catch (Throwable throwable) {
                            void var3_6;
                            boolean bl = this_$iv.exit();
                            if (bl && var3_6 != false) {
                                throw asyncTimeout.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
                return;
            }

            public final AsyncTimeout timeout() {
                return this.this$0;
            }

            public final String toString() {
                return "AsyncTimeout.sink(" + this.$sink + ')';
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final Source source(Source source2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return new Source(this, (Source)var1_1){
            final /* synthetic */ AsyncTimeout this$0;
            final /* synthetic */ Source $source;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$source = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public final long read(Buffer sink2, long byteCount) {
                long l;
                block5: {
                    void this_$iv;
                    Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
                    AsyncTimeout asyncTimeout = this.this$0;
                    Source source2 = this.$source;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        void var2_3;
                        void var1_1;
                        long result$iv = source2.read((Buffer)var1_1, (long)var2_3);
                        throwOnTimeout$iv = true;
                        l = result$iv;
                        boolean bl = this_$iv.exit();
                        if (!bl) break block5;
                    }
                    catch (IOException e$iv) {
                        try {
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException(e$iv);
                        }
                        catch (Throwable throwable) {
                            boolean bl = this_$iv.exit();
                            if (bl && throwOnTimeout$iv) {
                                throw this_$iv.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
                return l;
            }

            /*
             * WARNING - void declaration
             */
            public final void close() {
                block5: {
                    void this_$iv;
                    AsyncTimeout asyncTimeout = this.this$0;
                    Source source2 = this.$source;
                    boolean throwOnTimeout$iv = false;
                    this_$iv.enter();
                    try {
                        source2.close();
                        throwOnTimeout$iv = true;
                        boolean bl = this_$iv.exit();
                        if (!bl) break block5;
                    }
                    catch (IOException e$iv) {
                        try {
                            void var2_4;
                            throw !this_$iv.exit() ? (Throwable)e$iv : (Throwable)this_$iv.access$newTimeoutException((IOException)var2_4);
                        }
                        catch (Throwable throwable) {
                            void var3_6;
                            boolean bl = this_$iv.exit();
                            if (bl && var3_6 != false) {
                                throw asyncTimeout.access$newTimeoutException(null);
                            }
                            throw throwable;
                        }
                    }
                    throw this_$iv.access$newTimeoutException(null);
                }
                return;
            }

            public final AsyncTimeout timeout() {
                return this.this$0;
            }

            public final String toString() {
                return "AsyncTimeout.source(" + this.$source + ')';
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T withTimeout(Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean throwOnTimeout = false;
        this.enter();
        try {
            Object result = block.invoke();
            throwOnTimeout = true;
            object = result;
        }
        catch (IOException e) {
            try {
                void var1_3;
                throw !this.exit() ? (Throwable)e : (Throwable)this.access$newTimeoutException((IOException)var1_3);
            }
            catch (Throwable throwable) {
                void var2_5;
                InlineMarker.finallyStart((int)1);
                boolean bl = this.exit();
                if (bl && var2_5 != false) {
                    throw this.access$newTimeoutException(null);
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart((int)1);
        boolean result = this.exit();
        if (result) {
            throw this.access$newTimeoutException(null);
        }
        InlineMarker.finallyEnd((int)1);
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public final IOException access$newTimeoutException(IOException cause) {
        void var1_1;
        return this.newTimeoutException((IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected IOException newTimeoutException(IOException cause) {
        void var2_2;
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            void var1_1;
            e.initCause((Throwable)var1_1);
        }
        return (IOException)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setTimeoutAt$p(AsyncTimeout $this, long l) {
        void var1_1;
        $this.timeoutAt = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long access$remainingNanos(AsyncTimeout $this, long now) {
        void var1_1;
        return $this.remainingNanos((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setNext$p(AsyncTimeout $this, AsyncTimeout asyncTimeout) {
        void var1_1;
        $this.next = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setState$p(AsyncTimeout $this, int n) {
        void var1_1;
        $this.state = var1_1;
    }

    static {
        Condition condition = lock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"newCondition(...)");
        AsyncTimeout.condition = condition;
        IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
        IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lokio/AsyncTimeout$Companion;", "", "()V", "IDLE_TIMEOUT_MILLIS", "", "IDLE_TIMEOUT_NANOS", "STATE_CANCELED", "", "STATE_IDLE", "STATE_IN_QUEUE", "STATE_TIMED_OUT", "TIMEOUT_WRITE_SIZE", "condition", "Ljava/util/concurrent/locks/Condition;", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "head", "Lokio/AsyncTimeout;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "awaitTimeout", "insertIntoQueue", "", "node", "timeoutNanos", "hasDeadline", "", "removeFromQueue", "okio"})
    private static final class Companion {
        private Companion() {
        }

        public final ReentrantLock getLock() {
            return lock;
        }

        public final Condition getCondition() {
            return condition;
        }

        private final void insertIntoQueue(AsyncTimeout node, long timeoutNanos, boolean hasDeadline) {
            if (head == null) {
                head = new AsyncTimeout();
                new Watchdog().start();
            }
            long now = System.nanoTime();
            if (timeoutNanos != 0L && hasDeadline) {
                AsyncTimeout.access$setTimeoutAt$p(node, now + Math.min(timeoutNanos, node.deadlineNanoTime() - now));
            } else if (timeoutNanos != 0L) {
                AsyncTimeout.access$setTimeoutAt$p(node, now + timeoutNanos);
            } else if (hasDeadline) {
                AsyncTimeout asyncTimeout = node;
                AsyncTimeout.access$setTimeoutAt$p(asyncTimeout, asyncTimeout.deadlineNanoTime());
            } else {
                throw new AssertionError();
            }
            long remainingNanos = AsyncTimeout.access$remainingNanos(node, now);
            AsyncTimeout asyncTimeout = head;
            Intrinsics.checkNotNull((Object)asyncTimeout);
            AsyncTimeout prev = asyncTimeout;
            while (true) {
                block13: {
                    block12: {
                        if (prev.next == null) break block12;
                        AsyncTimeout asyncTimeout2 = prev.next;
                        Intrinsics.checkNotNull((Object)asyncTimeout2);
                        if (remainingNanos >= AsyncTimeout.access$remainingNanos(asyncTimeout2, now)) break block13;
                    }
                    AsyncTimeout.access$setNext$p(node, prev.next);
                    AsyncTimeout.access$setNext$p(prev, node);
                    if (prev == head) {
                        this.getCondition().signal();
                    }
                    return;
                }
                Intrinsics.checkNotNull((Object)prev.next);
            }
        }

        private final void removeFromQueue(AsyncTimeout node) {
            AsyncTimeout prev = head;
            while (prev != null) {
                if (prev.next == node) {
                    AsyncTimeout.access$setNext$p(prev, node.next);
                    AsyncTimeout.access$setNext$p(node, null);
                    return;
                }
                prev = prev.next;
            }
            throw new IllegalStateException("node was not found in the queue".toString());
        }

        /*
         * WARNING - void declaration
         */
        public final AsyncTimeout awaitTimeout() throws InterruptedException {
            void var1_1;
            AsyncTimeout asyncTimeout = head;
            Intrinsics.checkNotNull((Object)asyncTimeout);
            AsyncTimeout node = asyncTimeout.next;
            if (node == null) {
                long startNanos = System.nanoTime();
                this.getCondition().await(IDLE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
                AsyncTimeout asyncTimeout2 = head;
                Intrinsics.checkNotNull((Object)asyncTimeout2);
                if (asyncTimeout2.next == null && System.nanoTime() - startNanos >= IDLE_TIMEOUT_NANOS) {
                    return head;
                }
                return null;
            }
            long waitNanos = AsyncTimeout.access$remainingNanos(node, System.nanoTime());
            if (waitNanos > 0L) {
                void var2_3;
                this.getCondition().await((long)var2_3, TimeUnit.NANOSECONDS);
                return null;
            }
            AsyncTimeout asyncTimeout3 = head;
            Intrinsics.checkNotNull((Object)asyncTimeout3);
            AsyncTimeout.access$setNext$p(asyncTimeout3, node.next);
            AsyncTimeout.access$setNext$p(node, null);
            AsyncTimeout.access$setState$p(node, 2);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ void access$insertIntoQueue(Companion $this, AsyncTimeout node, long timeoutNanos, boolean hasDeadline) {
            void var2_2;
            void var1_1;
            $this.insertIntoQueue((AsyncTimeout)var1_1, (long)var2_2, hasDeadline);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ void access$removeFromQueue(Companion $this, AsyncTimeout node) {
            void var1_1;
            $this.removeFromQueue((AsyncTimeout)var1_1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lokio/AsyncTimeout$Watchdog;", "Ljava/lang/Thread;", "()V", "run", "", "okio"})
    private static final class Watchdog
    extends Thread {
        public Watchdog() {
            super("Okio Watchdog");
            this.setDaemon(true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            while (true) {
                try {
                    while (true) {
                        void var1_1;
                        Lock lock = Companion.getLock();
                        lock.lock();
                        try {
                            AsyncTimeout timedOut = Companion.awaitTimeout();
                            if (timedOut == head) {
                                Companion;
                                head = null;
                                return;
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                        void v0 = var1_1;
                        if (v0 == null) continue;
                        v0.timedOut();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

