/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread.strategy;

import java.util.concurrent.Executor;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Locker;

public class ExecuteProduceConsume
implements Runnable,
ExecutionStrategy {
    private static final Logger LOG = Log.getLogger(ExecuteProduceConsume.class);
    private final Locker _locker = new Locker();
    private final Runnable _runProduce = new RunProduce();
    private final ExecutionStrategy.Producer _producer;
    private final Executor _executor;
    private boolean _idle = true;
    private boolean _execute;
    private boolean _producing;
    private boolean _pending;

    /*
     * WARNING - void declaration
     */
    public ExecuteProduceConsume(ExecutionStrategy.Producer producer, Executor executor) {
        void var2_2;
        void var1_1;
        this._producer = var1_1;
        this._executor = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void produce() {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} execute", this);
        }
        boolean produce22 = false;
        Locker.Lock locked = this._locker.lock();
        try {
            if (this._idle) {
                if (this._producing) {
                    throw new IllegalStateException();
                }
                this._producing = true;
                produce22 = true;
                this._idle = false;
            } else {
                this._execute = true;
            }
            if (locked != null) {
                locked.close();
            }
        }
        catch (Throwable produce22) {
            if (locked != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable) {
                    produce22.addSuppressed(throwable);
                }
            }
            throw produce22;
        }
        if (var1_1 != false) {
            this.produceConsume();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dispatch() {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} spawning", this);
        }
        boolean dispatch22 = false;
        Locker.Lock locked = this._locker.lock();
        try {
            if (this._idle) {
                dispatch22 = true;
            } else {
                this._execute = true;
            }
            if (locked != null) {
                locked.close();
            }
        }
        catch (Throwable dispatch22) {
            if (locked != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable) {
                    dispatch22.addSuppressed(throwable);
                }
            }
            throw dispatch22;
        }
        if (var1_1 != false) {
            this._executor.execute(this._runProduce);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} run", this);
        }
        boolean produce22 = false;
        Locker.Lock locked = this._locker.lock();
        try {
            this._pending = false;
            if (!this._idle && !this._producing) {
                this._producing = true;
                produce22 = true;
            }
            if (locked != null) {
                locked.close();
            }
        }
        catch (Throwable produce22) {
            if (locked != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable) {
                    produce22.addSuppressed(throwable);
                }
            }
            throw produce22;
        }
        if (var1_1 != false) {
            this.produceConsume();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void produceConsume() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} produce enter", this);
        }
        while (true) {
            void var2_4;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} producing", this);
            }
            Runnable task = this._producer.produce();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} produced {}", this, task);
            }
            boolean dispatch = false;
            Locker.Lock locked = this._locker.lock();
            try {
                this._producing = false;
                if (task == null) {
                    if (this._execute) {
                        this._idle = false;
                        this._producing = true;
                        this._execute = false;
                        continue;
                    }
                    this._idle = true;
                    break;
                }
                if (!this._pending) {
                    this._pending = Invocable.getInvocationType(task) != Invocable.InvocationType.NON_BLOCKING;
                    dispatch = this._pending;
                }
                this._execute = false;
            }
            finally {
                if (locked == null) continue;
                locked.close();
                continue;
            }
            if (var2_4 != false) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} dispatch", this);
                }
                this._executor.execute(this);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} run {}", this, task);
            }
            if (task != null) {
                task.run();
            }
            if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug("{} ran {}", this, var1_1);
            }
            locked = this._locker.lock();
            try {
                if (this._producing || this._idle) {
                    if (locked == null) break;
                    locked.close();
                    break;
                }
            }
            catch (Throwable throwable) {
                if (locked == null) throw throwable;
                try {
                    void var3_7;
                    var3_7.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            {
                this._producing = true;
                if (locked == null) continue;
                locked.close();
                continue;
            }
            break;
        }
        if (!LOG.isDebugEnabled()) return;
        LOG.debug("{} produce exit", this);
    }

    /*
     * WARNING - void declaration
     */
    public Boolean isIdle() {
        Locker.Lock locked = this._locker.lock();
        try {
            Boolean bl = this._idle;
            if (locked != null) {
                locked.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (locked != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder22 = new StringBuilder();
        builder22.append("EPC ");
        Locker.Lock locked = this._locker.lock();
        try {
            builder22.append(this._idle ? "Idle/" : "");
            builder22.append(this._producing ? "Prod/" : "");
            builder22.append(this._pending ? "Pend/" : "");
            builder22.append(this._execute ? "Exec/" : "");
            if (locked != null) {
                locked.close();
            }
        }
        catch (Throwable builder22) {
            if (locked != null) {
                try {
                    void var2_3;
                    var2_3.close();
                }
                catch (Throwable throwable) {
                    builder22.addSuppressed(throwable);
                }
            }
            throw builder22;
        }
        builder22.append(this._producer);
        return var1_1.toString();
    }

    private class RunProduce
    implements Runnable {
        private RunProduce() {
        }

        @Override
        public void run() {
            ExecuteProduceConsume.this.produce();
        }
    }
}

