/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread.strategy;

import java.io.Closeable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.TryExecutor;

@ManagedObject(value="eat what you kill execution strategy")
public class EatWhatYouKill
extends ContainerLifeCycle
implements Runnable,
ExecutionStrategy {
    private static final Logger LOG = Log.getLogger(EatWhatYouKill.class);
    private final LongAdder _pcMode = new LongAdder();
    private final LongAdder _picMode = new LongAdder();
    private final LongAdder _pecMode = new LongAdder();
    private final LongAdder _epcMode = new LongAdder();
    private final ExecutionStrategy.Producer _producer;
    private final Executor _executor;
    private final TryExecutor _tryExecutor;
    private State _state = State.IDLE;
    private boolean _pending;

    /*
     * WARNING - void declaration
     */
    public EatWhatYouKill(ExecutionStrategy.Producer producer, Executor executor) {
        void var2_2;
        void var1_1;
        this._producer = var1_1;
        this._executor = executor;
        this._tryExecutor = TryExecutor.asTryExecutor((Executor)var2_2);
        EatWhatYouKill eatWhatYouKill = this;
        eatWhatYouKill.addBean(eatWhatYouKill._producer);
        EatWhatYouKill eatWhatYouKill2 = this;
        eatWhatYouKill2.addBean(eatWhatYouKill2._tryExecutor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} created", this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dispatch() {
        void var1_1;
        boolean execute = false;
        EatWhatYouKill eatWhatYouKill = this;
        synchronized (eatWhatYouKill) {
            switch (this._state) {
                case IDLE: {
                    if (this._pending) break;
                    this._pending = true;
                    execute = true;
                    break;
                }
                case PRODUCING: {
                    this._state = State.REPRODUCING;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} dispatch {}", this, execute);
        }
        if (var1_1 != false) {
            this._executor.execute(this);
        }
    }

    @Override
    public void run() {
        this.tryProduce(true);
    }

    @Override
    public void produce() {
        this.tryProduce(false);
    }

    /*
     * WARNING - void declaration
     */
    private void tryProduce(boolean wasPending) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} tryProduce {}", this, wasPending);
        }
        EatWhatYouKill eatWhatYouKill = this;
        synchronized (eatWhatYouKill) {
            if (wasPending) {
                this._pending = false;
            }
            switch (this._state) {
                case IDLE: {
                    this._state = State.PRODUCING;
                    break;
                }
                case PRODUCING: {
                    this._state = State.REPRODUCING;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        boolean nonBlocking = Invocable.isNonBlockingInvocation();
        while (this.isRunning()) {
            try {
                if (this.doProduce(nonBlocking)) continue;
                return;
            }
            catch (Throwable ex) {
                void var1_3;
                LOG.warn((Throwable)var1_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean doProduce(boolean nonBlocking22) {
        void var1_3;
        EatWhatYouKill eatWhatYouKill;
        Mode mode;
        boolean nonBlocking22;
        Runnable task = this.produceTask();
        if (task == null) {
            EatWhatYouKill nonBlocking22 = this;
            synchronized (nonBlocking22) {
                switch (this._state) {
                    case PRODUCING: {
                        this._state = State.IDLE;
                        return false;
                    }
                    case REPRODUCING: {
                        this._state = State.PRODUCING;
                        return true;
                    }
                }
                throw new IllegalStateException(this.toStringLocked());
            }
        }
        if (nonBlocking22) {
            switch (Invocable.getInvocationType(task)) {
                case NON_BLOCKING: {
                    mode = Mode.PRODUCE_CONSUME;
                    break;
                }
                case EITHER: {
                    mode = Mode.PRODUCE_INVOKE_CONSUME;
                    break;
                }
                default: {
                    mode = Mode.PRODUCE_EXECUTE_CONSUME;
                    break;
                }
            }
        } else {
            switch (Invocable.getInvocationType(task)) {
                case NON_BLOCKING: {
                    mode = Mode.PRODUCE_CONSUME;
                    break;
                }
                case BLOCKING: {
                    eatWhatYouKill = this;
                    synchronized (eatWhatYouKill) {
                        if (this._pending) {
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                        } else if (this._tryExecutor.tryExecute(this)) {
                            this._pending = true;
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                        } else {
                            mode = Mode.PRODUCE_EXECUTE_CONSUME;
                        }
                        break;
                    }
                }
                case EITHER: {
                    eatWhatYouKill = this;
                    synchronized (eatWhatYouKill) {
                        if (this._pending) {
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                        } else if (this._tryExecutor.tryExecute(this)) {
                            this._pending = true;
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                        } else {
                            mode = Mode.PRODUCE_INVOKE_CONSUME;
                        }
                        break;
                    }
                }
                default: {
                    throw new IllegalStateException(((AbstractLifeCycle)this).toString());
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} m={} t={}/{}", new Object[]{this, mode, task, Invocable.getInvocationType(task)});
        }
        switch (1.$SwitchMap$org$eclipse$jetty$util$thread$strategy$EatWhatYouKill$Mode[var1_3.ordinal()]) {
            case 1: {
                this._pcMode.increment();
                this.runTask(task);
                return true;
            }
            case 2: {
                this._picMode.increment();
                this.invokeTask(task);
                return true;
            }
            case 3: {
                this._pecMode.increment();
                this.execute(task);
                return true;
            }
            case 4: {
                void var2_7;
                this._epcMode.increment();
                this.runTask((Runnable)var2_7);
                eatWhatYouKill = this;
                synchronized (eatWhatYouKill) {
                    if (this._state == State.IDLE) {
                        this._state = State.PRODUCING;
                        return true;
                    }
                }
                return false;
            }
        }
        throw new IllegalStateException(((AbstractLifeCycle)this).toString());
    }

    /*
     * WARNING - void declaration
     */
    private void runTask(Runnable task) {
        try {
            task.run();
            return;
        }
        catch (Throwable x) {
            void var1_2;
            LOG.warn((Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void invokeTask(Runnable task) {
        try {
            Invocable.invokeNonBlocking(task);
            return;
        }
        catch (Throwable x) {
            void var1_2;
            LOG.warn((Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Runnable produceTask() {
        try {
            return this._producer.produce();
        }
        catch (Throwable e) {
            void var1_1;
            LOG.warn((Throwable)var1_1);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void execute(Runnable task) {
        try {
            this._executor.execute(task);
            return;
        }
        catch (RejectedExecutionException e) {
            if (this.isRunning()) {
                LOG.warn(e);
            } else {
                void var2_3;
                LOG.ignore((Throwable)var2_3);
            }
            if (task instanceof Closeable) {
                try {
                    ((Closeable)((Object)task)).close();
                    return;
                }
                catch (Throwable ex2) {
                    void var1_2;
                    LOG.ignore((Throwable)var1_2);
                }
            }
            return;
        }
    }

    @ManagedAttribute(value="number of tasks consumed with PC mode", readonly=true)
    public long getPCTasksConsumed() {
        return this._pcMode.longValue();
    }

    @ManagedAttribute(value="number of tasks executed with PIC mode", readonly=true)
    public long getPICTasksExecuted() {
        return this._picMode.longValue();
    }

    @ManagedAttribute(value="number of tasks executed with PEC mode", readonly=true)
    public long getPECTasksExecuted() {
        return this._pecMode.longValue();
    }

    @ManagedAttribute(value="number of tasks consumed with EPC mode", readonly=true)
    public long getEPCTasksConsumed() {
        return this._epcMode.longValue();
    }

    @ManagedAttribute(value="whether this execution strategy is idle", readonly=true)
    public boolean isIdle() {
        EatWhatYouKill eatWhatYouKill = this;
        synchronized (eatWhatYouKill) {
            return this._state == State.IDLE;
        }
    }

    @ManagedOperation(value="resets the task counts", impact="ACTION")
    public void reset() {
        this._pcMode.reset();
        this._epcMode.reset();
        this._pecMode.reset();
        this._picMode.reset();
    }

    @Override
    public String toString() {
        EatWhatYouKill eatWhatYouKill = this;
        synchronized (eatWhatYouKill) {
            return this.toStringLocked();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toStringLocked() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        this.getString(builder);
        this.getState(builder);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void getString(StringBuilder builder) {
        void var1_1;
        builder.append(this.getClass().getSimpleName());
        builder.append('@');
        builder.append(Integer.toHexString(this.hashCode()));
        builder.append('/');
        builder.append(this._producer);
        var1_1.append('/');
    }

    /*
     * WARNING - void declaration
     */
    private void getState(StringBuilder builder) {
        void var1_1;
        builder.append((Object)this._state);
        builder.append("/p=");
        builder.append(this._pending);
        builder.append('/');
        builder.append(this._tryExecutor);
        builder.append("[pc=");
        builder.append(this.getPCTasksConsumed());
        builder.append(",pic=");
        builder.append(this.getPICTasksExecuted());
        builder.append(",pec=");
        builder.append(this.getPECTasksExecuted());
        builder.append(",epc=");
        builder.append(this.getEPCTasksConsumed());
        builder.append("]");
        builder.append("@");
        var1_1.append(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now()));
    }

    private static enum Mode {
        PRODUCE_CONSUME,
        PRODUCE_INVOKE_CONSUME,
        PRODUCE_EXECUTE_CONSUME,
        EXECUTE_PRODUCE_CONSUME;

    }

    private static enum State {
        IDLE,
        PRODUCING,
        REPRODUCING;

    }
}

