/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public interface TryExecutor
extends Executor {
    public static final TryExecutor NO_TRY = new TryExecutor(){

        @Override
        public boolean tryExecute(Runnable task) {
            return false;
        }

        public String toString() {
            return "NO_TRY";
        }
    };

    public boolean tryExecute(Runnable var1);

    /*
     * WARNING - void declaration
     */
    @Override
    default public void execute(Runnable task) {
        void var1_1;
        if (!this.tryExecute((Runnable)var1_1)) {
            throw new RejectedExecutionException();
        }
    }

    public static TryExecutor asTryExecutor(Executor executor) {
        Executor executor2;
        if (executor instanceof TryExecutor) {
            return (TryExecutor)executor;
        }
        return new NoTryExecutor(executor2);
    }

    public static class NoTryExecutor
    implements TryExecutor {
        private final Executor executor;

        /*
         * WARNING - void declaration
         */
        public NoTryExecutor(Executor executor) {
            void var1_1;
            this.executor = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(Runnable task) {
            void var1_1;
            this.executor.execute((Runnable)var1_1);
        }

        @Override
        public boolean tryExecute(Runnable task) {
            return false;
        }

        public String toString() {
            return String.format("%s@%x[%s]", this.getClass().getSimpleName(), this.hashCode(), this.executor);
        }
    }
}

