/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class TimerScheduler
extends AbstractLifeCycle
implements Runnable,
Scheduler {
    private static final Logger LOG = Log.getLogger(TimerScheduler.class);
    private final String _name;
    private final boolean _daemon;
    private Timer _timer;

    public TimerScheduler() {
        this(null, false);
    }

    /*
     * WARNING - void declaration
     */
    public TimerScheduler(String name, boolean daemon) {
        void var2_2;
        void var1_1;
        this._name = var1_1;
        this._daemon = var2_2;
    }

    @Override
    protected void doStart() throws Exception {
        this._timer = this._name == null ? new Timer() : new Timer(this._name, this._daemon);
        this.run();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this._timer.cancel();
        super.doStop();
        this._timer = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Scheduler.Task schedule(Runnable task, long delay, TimeUnit units) {
        void var1_1;
        void var2_2;
        Timer timer = this._timer;
        if (timer == null) {
            throw new RejectedExecutionException("STOPPED: " + this);
        }
        SimpleTask t = new SimpleTask(task);
        timer.schedule((TimerTask)t, units.toMillis((long)var2_2));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        Timer timer = this._timer;
        if (timer != null) {
            void var1_1;
            var1_1.purge();
            TimerScheduler timerScheduler = this;
            timerScheduler.schedule(timerScheduler, 1L, TimeUnit.SECONDS);
        }
    }

    private static class SimpleTask
    extends TimerTask
    implements Scheduler.Task {
        private final Runnable _task;

        /*
         * WARNING - void declaration
         */
        private SimpleTask(Runnable runnable) {
            void var1_1;
            this._task = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            try {
                this._task.run();
                return;
            }
            catch (Throwable x) {
                void var1_1;
                LOG.warn("Exception while executing task " + this._task, (Throwable)var1_1);
                return;
            }
        }

        public String toString() {
            return String.format("%s.%s@%x", TimerScheduler.class.getSimpleName(), SimpleTask.class.getSimpleName(), this.hashCode());
        }
    }
}

