/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

@ManagedObject
public class ThreadPoolBudget {
    private static final Logger LOG = Log.getLogger(ThreadPoolBudget.class);
    private static final Lease NOOP_LEASE = new Lease(){

        @Override
        public void close() {
        }

        @Override
        public int getThreads() {
            return 0;
        }
    };
    private final Set<Leased> leases = new CopyOnWriteArraySet<Leased>();
    private final AtomicBoolean warned = new AtomicBoolean();
    private final ThreadPool.SizedThreadPool pool;
    private final int warnAt;

    /*
     * WARNING - void declaration
     */
    public ThreadPoolBudget(ThreadPool.SizedThreadPool pool) {
        void var1_1;
        this.pool = var1_1;
        this.warnAt = -1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ThreadPoolBudget(ThreadPool.SizedThreadPool pool, int warnAt) {
        void var2_2;
        void var1_1;
        this.pool = var1_1;
        this.warnAt = var2_2;
    }

    public ThreadPool.SizedThreadPool getSizedThreadPool() {
        return this.pool;
    }

    @ManagedAttribute(value="the number of threads leased to components")
    public int getLeasedThreads() {
        return this.leases.stream().mapToInt(Lease::getThreads).sum();
    }

    public void reset() {
        this.leases.clear();
        this.warned.set(false);
    }

    /*
     * WARNING - void declaration
     */
    public Lease leaseTo(Object leasee, int threads) {
        Leased lease = new Leased(this, leasee, threads);
        this.leases.add(lease);
        try {
            ThreadPoolBudget threadPoolBudget = this;
            threadPoolBudget.check(threadPoolBudget.pool.getMaxThreads());
            return lease;
        }
        catch (IllegalStateException e) {
            void var2_3;
            void var1_1;
            var1_1.close();
            throw var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean check(int maxThreads) throws IllegalStateException {
        int required = this.getLeasedThreads();
        int left = maxThreads - required;
        if (left <= 0) {
            this.printInfoOnLeases();
            throw new IllegalStateException(String.format("Insufficient configured threads: required=%d < max=%d for %s", required, maxThreads, this.pool));
        }
        if (left < this.warnAt) {
            if (this.warned.compareAndSet(false, true)) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.printInfoOnLeases();
                LOG.info("Low configured threads: (max={} - required={})={} < warnAt={} for {}", (int)var1_1, (int)var2_2, (int)var3_3, this.warnAt, this.pool);
            }
            return false;
        }
        return true;
    }

    private void printInfoOnLeases() {
        this.leases.forEach(lease -> {
            void var1_1;
            LOG.info("{} requires {} threads from {}", ((Leased)lease).leasee, var1_1.getThreads(), this.pool);
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Lease leaseFrom(Executor executor, Object leasee, int threads) {
        Object budget;
        if (executor instanceof ThreadPool.SizedThreadPool && (budget = ((ThreadPool.SizedThreadPool)executor).getThreadPoolBudget()) != null) {
            void var2_2;
            void var1_1;
            Object object;
            return ((ThreadPoolBudget)object).leaseTo(var1_1, (int)var2_2);
        }
        return NOOP_LEASE;
    }

    public class Leased
    implements Lease {
        private final Object leasee;
        private final int threads;
        final /* synthetic */ ThreadPoolBudget this$0;

        /*
         * WARNING - void declaration
         */
        private Leased(ThreadPoolBudget this$0, Object leasee, int threads) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.leasee = var2_2;
            this.threads = var3_3;
        }

        @Override
        public int getThreads() {
            return this.threads;
        }

        @Override
        public void close() {
            this.this$0.leases.remove(this);
            this.this$0.warned.set(false);
        }
    }

    public static interface Lease
    extends Closeable {
        public int getThreads();
    }
}

