/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class Sweeper
extends AbstractLifeCycle
implements Runnable {
    private static final Logger LOG = Log.getLogger(Sweeper.class);
    private final AtomicReference<List<Sweepable>> items = new AtomicReference();
    private final AtomicReference<Scheduler.Task> task = new AtomicReference();
    private final Scheduler scheduler;
    private final long period;

    /*
     * WARNING - void declaration
     */
    public Sweeper(Scheduler scheduler, long period) {
        void var2_2;
        void var1_1;
        this.scheduler = var1_1;
        this.period = var2_2;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.items.set(new CopyOnWriteArrayList());
        this.activate();
    }

    @Override
    protected void doStop() throws Exception {
        this.deactivate();
        this.items.set(null);
        super.doStop();
    }

    /*
     * WARNING - void declaration
     */
    public int getSize() {
        void var1_1;
        List<Sweepable> refs = this.items.get();
        if (refs == null) {
            return 0;
        }
        return var1_1.size();
    }

    /*
     * WARNING - void declaration
     */
    public boolean offer(Sweepable sweepable) {
        void var2_2;
        List<Sweepable> refs = this.items.get();
        if (refs == null) {
            return false;
        }
        var2_2.add(sweepable);
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("Resource offered {}", var1_1);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(Sweepable sweepable) {
        void var1_1;
        void var2_2;
        List<Sweepable> refs = this.items.get();
        return refs != null && var2_2.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        List<Sweepable> refs = this.items.get();
        if (refs == null) {
            return;
        }
        for (Sweepable sweepable : refs) {
            try {
                if (!sweepable.sweep()) continue;
                refs.remove(sweepable);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Resource swept {}", sweepable);
            }
            catch (Throwable x) {
                void var3_3;
                LOG.info("Exception while sweeping " + var3_3, x);
            }
        }
        this.activate();
    }

    /*
     * WARNING - void declaration
     */
    private void activate() {
        if (this.isRunning()) {
            void var1_1;
            Sweeper sweeper = this;
            Scheduler.Task t = this.scheduler.schedule(sweeper, sweeper.period, TimeUnit.MILLISECONDS);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduled in {} ms sweep task {}", this.period, t);
            }
            this.task.set((Scheduler.Task)var1_1);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Skipping sweep task scheduling", new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deactivate() {
        Scheduler.Task t = this.task.getAndSet(null);
        if (t != null) {
            boolean cancelled = t.cancel();
            if (LOG.isDebugEnabled()) {
                void var1_1;
                void var2_2;
                LOG.debug("Cancelled ({}) sweep task {}", (boolean)var2_2, var1_1);
            }
        }
    }

    public static interface Sweepable {
        public boolean sweep();
    }
}

