/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.PrivilegedThreadFactory;

public class ShutdownThread
extends Thread {
    private static final Logger LOG = Log.getLogger(ShutdownThread.class);
    private static final ShutdownThread _thread = PrivilegedThreadFactory.newThread(() -> new ShutdownThread());
    private boolean _hooked;
    private final List<LifeCycle> _lifeCycles = new CopyOnWriteArrayList<LifeCycle>();

    private ShutdownThread() {
        super("JettyShutdownThread");
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void hook() {
        try {
            if (!this._hooked) {
                Runtime.getRuntime().addShutdownHook(this);
            }
            this._hooked = true;
            return;
        }
        catch (Exception e) {
            void var1_1;
            LOG.ignore((Throwable)var1_1);
            LOG.info("shutdown already commenced", new Object[0]);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void unhook() {
        try {
            this._hooked = false;
            Runtime.getRuntime().removeShutdownHook(this);
            return;
        }
        catch (Exception e) {
            void var1_1;
            LOG.ignore((Throwable)var1_1);
            LOG.debug("shutdown already commenced", new Object[0]);
            return;
        }
    }

    public static ShutdownThread getInstance() {
        return _thread;
    }

    public static synchronized void register(LifeCycle ... lifeCycles) {
        LifeCycle[] lifeCycleArray;
        ShutdownThread._thread._lifeCycles.addAll(Arrays.asList(lifeCycleArray));
        if (ShutdownThread._thread._lifeCycles.size() > 0) {
            _thread.hook();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized void register(int index, LifeCycle ... lifeCycles) {
        void var1_1;
        int n;
        ShutdownThread._thread._lifeCycles.addAll(n, Arrays.asList(var1_1));
        if (ShutdownThread._thread._lifeCycles.size() > 0) {
            _thread.hook();
        }
    }

    public static synchronized void deregister(LifeCycle lifeCycle) {
        LifeCycle lifeCycle2;
        ShutdownThread._thread._lifeCycles.remove(lifeCycle2);
        if (ShutdownThread._thread._lifeCycles.size() == 0) {
            _thread.unhook();
        }
    }

    public static synchronized boolean isRegistered(LifeCycle lifeCycle) {
        LifeCycle lifeCycle2;
        return ShutdownThread._thread._lifeCycles.contains(lifeCycle2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        for (LifeCycle lifeCycle : ShutdownThread._thread._lifeCycles) {
            try {
                if (lifeCycle.isStarted()) {
                    lifeCycle.stop();
                    LOG.debug("Stopped {}", lifeCycle);
                }
                if (!(lifeCycle instanceof Destroyable)) continue;
                ((Destroyable)((Object)lifeCycle)).destroy();
                LOG.debug("Destroyed {}", lifeCycle);
            }
            catch (Exception ex) {
                void var2_3;
                LOG.debug((Throwable)var2_3);
            }
        }
    }
}

