/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject
public class ScheduledExecutorScheduler
extends AbstractLifeCycle
implements Dumpable,
Scheduler {
    private final String name;
    private final boolean daemon;
    private final ClassLoader classloader;
    private final ThreadGroup threadGroup;
    private final int threads;
    private final AtomicInteger count = new AtomicInteger();
    private volatile ScheduledThreadPoolExecutor scheduler;
    private volatile Thread thread;

    public ScheduledExecutorScheduler() {
        this(null, false);
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledExecutorScheduler(String name, boolean daemon) {
        this((String)var1_1, (boolean)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledExecutorScheduler(@Name(value="name") String name, @Name(value="daemon") boolean daemon, @Name(value="threads") int threads) {
        this((String)var1_1, (boolean)var2_2, null, null, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledExecutorScheduler(String name, boolean daemon, ClassLoader classLoader) {
        this((String)var1_1, (boolean)var2_2, (ClassLoader)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledExecutorScheduler(String name, boolean daemon, ClassLoader classLoader, ThreadGroup threadGroup) {
        this((String)var1_1, (boolean)var2_2, (ClassLoader)var3_3, threadGroup, -1);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ScheduledExecutorScheduler(@Name(value="name") String name, @Name(value="daemon") boolean daemon, @Name(value="classLoader") ClassLoader classLoader, @Name(value="threadGroup") ThreadGroup threadGroup, @Name(value="threads") int threads) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = StringUtil.isBlank(name) ? "Scheduler-" + this.hashCode() : var1_1;
        this.daemon = var2_2;
        this.classloader = classLoader == null ? Thread.currentThread().getContextClassLoader() : var3_3;
        this.threadGroup = threadGroup;
        this.threads = threads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStart() throws Exception {
        void var1_1;
        int size = this.threads > 0 ? this.threads : 1;
        this.scheduler = new ScheduledThreadPoolExecutor((int)var1_1, r -> {
            void var1_1;
            Thread thread = this.thread = new Thread(this.threadGroup, r, this.name + "-" + this.count.incrementAndGet());
            this.thread.setDaemon(this.daemon);
            thread.setContextClassLoader(this.classloader);
            return var1_1;
        });
        this.scheduler.setRemoveOnCancelPolicy(true);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.scheduler.shutdownNow();
        super.doStop();
        this.scheduler = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Scheduler.Task schedule(Runnable task, long delay, TimeUnit unit) {
        void var1_1;
        void var2_2;
        ScheduledThreadPoolExecutor s = this.scheduler;
        if (s == null) {
            return () -> false;
        }
        ScheduledFuture<?> result = s.schedule(task, (long)var2_2, unit);
        return new ScheduledFutureTask((ScheduledFuture<?>)var1_1);
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Thread thread = this.thread;
        if (thread == null) {
            Dumpable.dumpObject(out, this);
            return;
        }
        Dumpable.dumpObjects((Appendable)var1_1, (String)var2_2, this, var3_3.getStackTrace());
    }

    @ManagedAttribute(value="The name of the scheduler")
    public String getName() {
        return this.name;
    }

    @ManagedAttribute(value="Whether the scheduler uses daemon threads")
    public boolean isDaemon() {
        return this.daemon;
    }

    @ManagedAttribute(value="The number of scheduler threads")
    public int getThreads() {
        return this.threads;
    }

    private static class ScheduledFutureTask
    implements Scheduler.Task {
        private final ScheduledFuture<?> scheduledFuture;

        /*
         * WARNING - void declaration
         */
        ScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
            void var1_1;
            this.scheduledFuture = var1_1;
        }

        @Override
        public boolean cancel() {
            return this.scheduledFuture.cancel(false);
        }
    }
}

