/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.AtomicBiInteger;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.PrivilegedThreadFactory;
import org.eclipse.jetty.util.thread.ReservedThreadExecutor;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.ThreadPoolBudget;
import org.eclipse.jetty.util.thread.TryExecutor;

@ManagedObject(value="A thread pool")
public class QueuedThreadPool
extends ContainerLifeCycle
implements ThreadFactory,
Dumpable,
ThreadPool.SizedThreadPool,
TryExecutor {
    private static final Logger LOG = Log.getLogger(QueuedThreadPool.class);
    private static final Runnable NOOP = () -> {};
    private final AtomicBiInteger _counts = new AtomicBiInteger(Integer.MIN_VALUE, 0);
    private final AtomicLong _lastShrink = new AtomicLong();
    private final Set<Thread> _threads = ConcurrentHashMap.newKeySet();
    private final Object _joinLock = new Object();
    private final BlockingQueue<Runnable> _jobs;
    private final ThreadGroup _threadGroup;
    private final ThreadFactory _threadFactory;
    private String _name = "qtp" + this.hashCode();
    private int _idleTimeout;
    private int _maxThreads;
    private int _minThreads;
    private int _reservedThreads = -1;
    private TryExecutor _tryExecutor = TryExecutor.NO_TRY;
    private int _priority = 5;
    private boolean _daemon = false;
    private boolean _detailedDump = false;
    private int _lowThreadsThreshold = 1;
    private ThreadPoolBudget _budget;
    private final Runnable _runnable = new Runner();

    public QueuedThreadPool() {
        this(200);
    }

    /*
     * WARNING - void declaration
     */
    public QueuedThreadPool(@Name(value="maxThreads") int maxThreads) {
        this(maxThreads, Math.min(8, (int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueuedThreadPool(@Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads) {
        this((int)var1_1, (int)var2_2, 60000);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueuedThreadPool(@Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="queue") BlockingQueue<Runnable> queue) {
        this((int)var1_1, (int)var2_2, 60000, -1, (BlockingQueue<Runnable>)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueuedThreadPool(@Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout) {
        this((int)var1_1, (int)var2_2, (int)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueuedThreadPool(@Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout, @Name(value="queue") BlockingQueue<Runnable> queue) {
        this((int)var1_1, (int)var2_2, (int)var3_3, queue, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueuedThreadPool(@Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout, @Name(value="queue") BlockingQueue<Runnable> queue, @Name(value="threadGroup") ThreadGroup threadGroup) {
        this((int)var1_1, (int)var2_2, (int)var3_3, -1, queue, threadGroup);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueuedThreadPool(@Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout, @Name(value="reservedThreads") int reservedThreads, @Name(value="queue") BlockingQueue<Runnable> queue, @Name(value="threadGroup") ThreadGroup threadGroup) {
        this((int)var1_1, (int)var2_2, (int)var3_3, reservedThreads, queue, threadGroup, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QueuedThreadPool(@Name(value="maxThreads") int maxThreads, @Name(value="minThreads") int minThreads, @Name(value="idleTimeout") int idleTimeout, @Name(value="reservedThreads") int reservedThreads, @Name(value="queue") BlockingQueue<Runnable> queue, @Name(value="threadGroup") ThreadGroup threadGroup, @Name(value="threadFactory") ThreadFactory threadFactory) {
        void var3_3;
        void var2_2;
        if (maxThreads < minThreads) {
            throw new IllegalArgumentException("max threads (" + maxThreads + ") less than min threads (" + minThreads + ")");
        }
        this.setMinThreads((int)var2_2);
        this.setMaxThreads(maxThreads);
        this.setIdleTimeout((int)var3_3);
        ((AbstractLifeCycle)this).setStopTimeout(5000L);
        this.setReservedThreads(reservedThreads);
        if (queue == null) {
            void var1_1;
            int capacity = Math.max(this._minThreads, 8) << 10;
            void v0 = var1_1;
            queue = new BlockingArrayQueue<Runnable>((int)v0, (int)v0);
        }
        this._jobs = queue;
        this._threadGroup = threadGroup;
        this.setThreadPoolBudget(new ThreadPoolBudget(this));
        this._threadFactory = threadFactory == null ? this : threadFactory;
    }

    @Override
    public ThreadPoolBudget getThreadPoolBudget() {
        return this._budget;
    }

    /*
     * WARNING - void declaration
     */
    public void setThreadPoolBudget(ThreadPoolBudget budget) {
        void var1_1;
        if (budget != null && budget.getSizedThreadPool() != this) {
            throw new IllegalArgumentException();
        }
        QueuedThreadPool queuedThreadPool = this;
        queuedThreadPool.updateBean(queuedThreadPool._budget, budget);
        this._budget = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStart() throws Exception {
        if (this._reservedThreads == 0) {
            this._tryExecutor = NO_TRY;
        } else {
            void var1_1;
            QueuedThreadPool queuedThreadPool = this;
            ReservedThreadExecutor reserved = new ReservedThreadExecutor(queuedThreadPool, queuedThreadPool._reservedThreads);
            reserved.setIdleTimeout(this._idleTimeout, TimeUnit.MILLISECONDS);
            this._tryExecutor = var1_1;
        }
        QueuedThreadPool queuedThreadPool = this;
        queuedThreadPool.addBean(queuedThreadPool._tryExecutor);
        this._lastShrink.set(System.nanoTime());
        super.doStart();
        this._counts.set(0, 0);
        this.ensureThreads();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", this);
        }
        super.doStop();
        QueuedThreadPool queuedThreadPool = this;
        queuedThreadPool.removeBean(queuedThreadPool._tryExecutor);
        this._tryExecutor = TryExecutor.NO_TRY;
        int threads = this._counts.getAndSetHi(Integer.MIN_VALUE);
        long timeout = this.getStopTimeout();
        BlockingQueue<Runnable> jobs = this.getQueue();
        for (int i = 0; i < threads; ++i) {
            jobs.offer(NOOP);
        }
        if (timeout > 0L) {
            this.joinThreads(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout) / 2L);
        }
        Thread.yield();
        for (Thread thread : this._threads) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Interrupting {}", thread);
            }
            thread.interrupt();
        }
        if (timeout > 0L) {
            this.joinThreads(System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout) / 2L);
            Thread.yield();
            if (LOG.isDebugEnabled()) {
                for (Thread unstopped : this._threads) {
                    void var2_8;
                    StringBuilder dmp = new StringBuilder();
                    for (StackTraceElement element : unstopped.getStackTrace()) {
                        dmp.append(System.lineSeparator()).append("\tat ").append(element);
                    }
                    LOG.warn("Couldn't stop {}{}", unstopped, var2_8.toString());
                }
            } else {
                for (Thread unstopped : this._threads) {
                    LOG.warn("{} Couldn't stop {}", this, unstopped);
                }
            }
        }
        while (!this._jobs.isEmpty()) {
            Runnable job = (Runnable)this._jobs.poll();
            if (job instanceof Closeable) {
                try {
                    ((Closeable)((Object)job)).close();
                }
                catch (Throwable t) {
                    void var1_5;
                    LOG.warn((Throwable)var1_5);
                }
                continue;
            }
            if (job == NOOP) continue;
            LOG.warn("Stopped without executing or closing {}", job);
        }
        if (this._budget != null) {
            this._budget.reset();
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
            return;
        }
    }

    private void joinThreads(long stopByNanos) throws InterruptedException {
        for (Thread thread : this._threads) {
            long canWait = TimeUnit.NANOSECONDS.toMillis(stopByNanos - System.nanoTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waiting for {} for {}", thread, canWait);
            }
            if (canWait <= 0L) continue;
            thread.join(canWait);
        }
    }

    @ManagedAttribute(value="maximum time a thread may be idle in ms")
    public int getIdleTimeout() {
        return this._idleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setIdleTimeout(int idleTimeout) {
        this._idleTimeout = idleTimeout;
        ReservedThreadExecutor reserved = this.getBean(ReservedThreadExecutor.class);
        if (reserved != null) {
            void var1_1;
            void var2_2;
            var2_2.setIdleTimeout((long)var1_1, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    @ManagedAttribute(value="maximum number of threads in the pool")
    public int getMaxThreads() {
        return this._maxThreads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxThreads(int maxThreads) {
        void var1_1;
        if (this._budget != null) {
            this._budget.check(maxThreads);
        }
        this._maxThreads = var1_1;
        if (this._minThreads > this._maxThreads) {
            this._minThreads = this._maxThreads;
        }
    }

    @Override
    @ManagedAttribute(value="minimum number of threads in the pool")
    public int getMinThreads() {
        return this._minThreads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMinThreads(int minThreads) {
        void var1_1;
        this._minThreads = var1_1;
        if (this._minThreads > this._maxThreads) {
            this._maxThreads = this._minThreads;
        }
        if (this.isStarted()) {
            this.ensureThreads();
        }
    }

    @ManagedAttribute(value="number of configured reserved threads or -1 for heuristic")
    public int getReservedThreads() {
        return this._reservedThreads;
    }

    /*
     * WARNING - void declaration
     */
    public void setReservedThreads(int reservedThreads) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._reservedThreads = var1_1;
    }

    @ManagedAttribute(value="name of the thread pool")
    public String getName() {
        return this._name;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._name = var1_1;
    }

    @ManagedAttribute(value="priority of threads in the pool")
    public int getThreadsPriority() {
        return this._priority;
    }

    /*
     * WARNING - void declaration
     */
    public void setThreadsPriority(int priority) {
        void var1_1;
        this._priority = var1_1;
    }

    @ManagedAttribute(value="thread pool uses daemon threads")
    public boolean isDaemon() {
        return this._daemon;
    }

    /*
     * WARNING - void declaration
     */
    public void setDaemon(boolean daemon) {
        void var1_1;
        this._daemon = var1_1;
    }

    @ManagedAttribute(value="reports additional details in the dump")
    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    /*
     * WARNING - void declaration
     */
    public void setDetailedDump(boolean detailedDump) {
        void var1_1;
        this._detailedDump = var1_1;
    }

    @ManagedAttribute(value="threshold at which the pool is low on threads")
    public int getLowThreadsThreshold() {
        return this._lowThreadsThreshold;
    }

    /*
     * WARNING - void declaration
     */
    public void setLowThreadsThreshold(int lowThreadsThreshold) {
        void var1_1;
        this._lowThreadsThreshold = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @ManagedAttribute(value="size of the job queue")
    public int getQueueSize() {
        void var1_1;
        int idle = this._counts.getLo();
        return Math.max(0, (int)(-var1_1));
    }

    @ManagedAttribute(value="maximum number (capacity) of reserved threads")
    public int getMaxReservedThreads() {
        TryExecutor tryExecutor = this._tryExecutor;
        if (tryExecutor instanceof ReservedThreadExecutor) {
            ReservedThreadExecutor reservedThreadExecutor;
            reservedThreadExecutor = reservedThreadExecutor;
            return reservedThreadExecutor.getCapacity();
        }
        return 0;
    }

    @ManagedAttribute(value="number of available reserved threads")
    public int getAvailableReservedThreads() {
        TryExecutor tryExecutor = this._tryExecutor;
        if (tryExecutor instanceof ReservedThreadExecutor) {
            ReservedThreadExecutor reservedThreadExecutor;
            reservedThreadExecutor = reservedThreadExecutor;
            return reservedThreadExecutor.getAvailable();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManagedAttribute(value="number of threads in the pool")
    public int getThreads() {
        void var1_1;
        int threads = this._counts.getHi();
        return Math.max(0, (int)var1_1);
    }

    @ManagedAttribute(value="number of threads ready to execute transient jobs")
    public int getReadyThreads() {
        return this.getIdleThreads() + this.getAvailableReservedThreads();
    }

    @ManagedAttribute(value="number of threads used by internal components")
    public int getLeasedThreads() {
        return this.getMaxLeasedThreads() - this.getMaxReservedThreads();
    }

    /*
     * WARNING - void declaration
     */
    @ManagedAttribute(value="maximum number of threads leased to internal components")
    public int getMaxLeasedThreads() {
        void var1_1;
        ThreadPoolBudget budget = this._budget;
        if (budget == null) {
            return 0;
        }
        return var1_1.getLeasedThreads();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManagedAttribute(value="number of idle threads but not reserved")
    public int getIdleThreads() {
        void var1_1;
        int idle = this._counts.getLo();
        return Math.max(0, (int)var1_1);
    }

    @ManagedAttribute(value="number of threads executing internal and transient jobs")
    public int getBusyThreads() {
        return this.getThreads() - this.getReadyThreads();
    }

    @ManagedAttribute(value="number of threads executing transient jobs")
    public int getUtilizedThreads() {
        return this.getThreads() - this.getLeasedThreads() - this.getReadyThreads();
    }

    @ManagedAttribute(value="maximum number of threads available to run transient jobs")
    public int getMaxAvailableThreads() {
        return this.getMaxThreads() - this.getLeasedThreads();
    }

    @ManagedAttribute(value="utilization rate of threads executing transient jobs")
    public double getUtilizationRate() {
        return (double)this.getUtilizedThreads() / (double)this.getMaxAvailableThreads();
    }

    @Override
    @ManagedAttribute(value="thread pool is low on threads", readonly=true)
    public boolean isLowOnThreads() {
        return this.getMaxThreads() - this.getThreads() + this.getReadyThreads() - this.getQueueSize() <= this.getLowThreadsThreshold();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(Runnable job) {
        long counts;
        int idle;
        int startThread;
        int threads;
        void var3_3;
        do {
            if ((threads = AtomicBiInteger.getHi(counts = this._counts.get())) != Integer.MIN_VALUE) continue;
            throw new RejectedExecutionException(job.toString());
        } while (!this._counts.compareAndSet((long)var3_3, threads + (startThread = (idle = AtomicBiInteger.getLo(counts)) <= 0 && threads < this._maxThreads ? 1 : 0), idle + startThread - 1));
        if (!this._jobs.offer(job)) {
            if (this.addCounts(-startThread, 1 - startThread)) {
                LOG.warn("{} rejected {}", this, job);
            }
            throw new RejectedExecutionException(job.toString());
        }
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("queue {} startThread={}", var1_1, startThread);
        }
        while (startThread-- > 0) {
            this.startThread();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryExecute(Runnable task) {
        void var1_1;
        void var2_2;
        TryExecutor tryExecutor = this._tryExecutor;
        return tryExecutor != null && var2_2.tryExecute((Runnable)var1_1);
    }

    @Override
    public void join() throws InterruptedException {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(1L);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void ensureThreads() {
        long counts;
        int threads;
        while ((threads = AtomicBiInteger.getHi(counts = this._counts.get())) != Integer.MIN_VALUE) {
            void var3_2;
            void var1_1;
            int idle = AtomicBiInteger.getLo(counts);
            if (threads >= this._minThreads && (idle >= 0 || threads >= this._maxThreads)) break;
            if (!this._counts.compareAndSet((long)var1_1, (int)(var3_2 + true), idle + 1)) continue;
            this.startThread();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startThread() {
        try {
            void var1_1;
            Thread thread = this._threadFactory.newThread(this._runnable);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting {}", thread);
            }
            this._threads.add(thread);
            this._lastShrink.set(System.nanoTime());
            var1_1.start();
            return;
        }
        catch (Throwable throwable) {
            this.addCounts(-1, -1);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean addCounts(int deltaThreads, int deltaIdle) {
        int idle;
        int threads;
        long update;
        void var3_3;
        do {
            long encoded = this._counts.get();
            threads = AtomicBiInteger.getHi(encoded);
            idle = AtomicBiInteger.getLo(encoded);
            if (threads != Integer.MIN_VALUE) continue;
            return false;
        } while (!this._counts.compareAndSet((long)var3_3, update = AtomicBiInteger.encode(threads + deltaThreads, idle + deltaIdle)));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Thread newThread(Runnable runnable) {
        void var1_1;
        return PrivilegedThreadFactory.newThread(() -> this.lambda$newThread$1((Runnable)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected void removeThread(Thread thread) {
        void var1_1;
        this._threads.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        ArrayList<Object> threads = new ArrayList<Object>(this.getMaxThreads());
        for (Thread thread : this._threads) {
            StackTraceElement[] trace = thread.getStackTrace();
            String stackTag = this.getCompressedStackTag(trace);
            String baseThreadInfo = String.format("%s %s tid=%d prio=%d", new Object[]{thread.getName(), thread.getState(), thread.getId(), thread.getPriority()});
            if (!StringUtil.isBlank(stackTag)) {
                threads.add(baseThreadInfo + " " + stackTag);
                continue;
            }
            if (this.isDetailedDump()) {
                threads.add((o, i) -> {
                    void var1_1;
                    String string;
                    void var3_3;
                    Dumpable.dumpObjects(o, (String)var3_3, string, (Object[])var1_1);
                });
                continue;
            }
            threads.add(baseThreadInfo + " @ " + (trace.length > 0 ? trace[0].toString() : "???"));
        }
        DumpableCollection threadsDump = new DumpableCollection("threads", (Collection<?>)var3_3);
        if (this.isDetailedDump()) {
            this.dumpObjects(out, indent, threadsDump, new DumpableCollection("jobs", new ArrayList<Runnable>(this.getQueue())));
            return;
        }
        this.dumpObjects((Appendable)var1_1, (String)var2_2, threadsDump);
    }

    private String getCompressedStackTag(StackTraceElement[] trace) {
        StackTraceElement[] stackTraceElementArray = trace;
        int n = trace.length;
        for (int i = 0; i < n; ++i) {
            StackTraceElement t = stackTraceElementArray[i];
            if ("idleJobPoll".equals(t.getMethodName()) && t.getClassName().equals(Runner.class.getName())) {
                return "IDLE";
            }
            if ("reservedWait".equals(t.getMethodName()) && t.getClassName().endsWith("ReservedThread")) {
                return "RESERVED";
            }
            if ("select".equals(t.getMethodName()) && t.getClassName().endsWith("SelectorProducer")) {
                return "SELECTING";
            }
            if (!"accept".equals(t.getMethodName()) || !t.getClassName().contains("ServerConnector")) continue;
            return "ACCEPTING";
        }
        return "";
    }

    protected void runJob(Runnable job) {
        job.run();
    }

    protected BlockingQueue<Runnable> getQueue() {
        return this._jobs;
    }

    @Deprecated
    public void setQueue(BlockingQueue<Runnable> queue) {
        throw new UnsupportedOperationException("Use constructor injection");
    }

    @ManagedOperation(value="interrupts a pool thread")
    public boolean interruptThread(@Name(value="id") long id) {
        for (Thread thread : this._threads) {
            if (thread.getId() != id) continue;
            thread.interrupt();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @ManagedOperation(value="dumps a pool thread stack")
    public String dumpThread(@Name(value="id") long id) {
        for (Thread thread : this._threads) {
            void var1_2;
            if (thread.getId() != id) continue;
            StringBuilder buf = new StringBuilder();
            buf.append(thread.getId()).append(" ").append(thread.getName()).append(" ");
            buf.append((Object)thread.getState()).append(":").append(System.lineSeparator());
            for (StackTraceElement element : thread.getStackTrace()) {
                buf.append("  at ").append(element.toString()).append(System.lineSeparator());
            }
            return var1_2.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var2_4;
        void var1_2;
        void var3_3;
        long count = this._counts.get();
        int threads = Math.max(0, AtomicBiInteger.getHi(count));
        int idle = Math.max(0, AtomicBiInteger.getLo(count));
        int queue = this.getQueueSize();
        return String.format("%s[%s]@%x{%s,%d<=%d<=%d,i=%d,r=%d,q=%d}[%s]", this.getClass().getSimpleName(), this._name, this.hashCode(), this.getState(), this.getMinThreads(), (int)var3_3, this.getMaxThreads(), (int)var1_2, this.getReservedThreads(), (int)var2_4, this._tryExecutor);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Thread lambda$newThread$1(Runnable runnable) {
        void var1_1;
        Thread thread = new Thread(this._threadGroup, runnable);
        thread.setDaemon(this.isDaemon());
        thread.setPriority(this.getThreadsPriority());
        thread.setName(this._name + "-" + thread.getId());
        thread.setContextClassLoader(this.getClass().getClassLoader());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$300(QueuedThreadPool x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return x0.addCounts((int)var1_1, (int)var2_2);
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - void declaration
         */
        private Runnable idleJobPoll(long idleTimeout) throws InterruptedException {
            void var1_1;
            if (idleTimeout <= 0L) {
                return (Runnable)QueuedThreadPool.this._jobs.take();
            }
            return (Runnable)QueuedThreadPool.this._jobs.poll((long)var1_1, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Runner started for {}", QueuedThreadPool.this);
            }
            boolean idle = true;
            try {
                Runnable job = null;
                while (QueuedThreadPool.access$300(QueuedThreadPool.this, 0, job == null ? 0 : 1)) {
                    idle = true;
                    try {
                        job = (Runnable)QueuedThreadPool.this._jobs.poll();
                        if (job == null) {
                            long idleTimeout = QueuedThreadPool.this.getIdleTimeout();
                            if (idleTimeout > 0L && QueuedThreadPool.this.getThreads() > QueuedThreadPool.this._minThreads) {
                                long last = QueuedThreadPool.this._lastShrink.get();
                                long now = System.nanoTime();
                                if (now - last > TimeUnit.MILLISECONDS.toNanos(idleTimeout) && QueuedThreadPool.this._lastShrink.compareAndSet(last, now)) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("shrinking {}", QueuedThreadPool.this);
                                    }
                                    break;
                                }
                            }
                            if ((job = this.idleJobPoll(idleTimeout)) == null) continue;
                        }
                        idle = false;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("run {} in {}", job, QueuedThreadPool.this);
                        }
                        QueuedThreadPool.this.runJob(job);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("ran {} in {}", job, QueuedThreadPool.this);
                    }
                    catch (InterruptedException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("interrupted {} in {}", job, QueuedThreadPool.this);
                        }
                        LOG.ignore(e);
                    }
                    catch (Throwable e) {
                        LOG.warn(e);
                    }
                    finally {
                        Thread.interrupted();
                    }
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                Thread thread = Thread.currentThread();
                QueuedThreadPool.this.removeThread(thread);
                QueuedThreadPool.access$300(QueuedThreadPool.this, -1, var1_1 != false ? -1 : 0);
                if (LOG.isDebugEnabled()) {
                    void var3_8;
                    LOG.debug("{} exited for {}", var3_8, QueuedThreadPool.this);
                }
                QueuedThreadPool.this.ensureThreads();
                throw throwable;
            }
            Thread thread = Thread.currentThread();
            QueuedThreadPool.this.removeThread(thread);
            QueuedThreadPool.access$300(QueuedThreadPool.this, -1, idle ? -1 : 0);
            if (LOG.isDebugEnabled()) {
                void var2_2;
                LOG.debug("{} exited for {}", var2_2, QueuedThreadPool.this);
            }
            QueuedThreadPool.this.ensureThreads();
        }
    }
}

