/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.BlockingQueue;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

@ManagedObject
public class MonitoredQueuedThreadPool
extends QueuedThreadPool {
    private final CounterStatistic queueStats;
    private final SampleStatistic queueLatencyStats;
    private final SampleStatistic taskLatencyStats;
    private final CounterStatistic threadStats;

    public MonitoredQueuedThreadPool() {
        this(256);
    }

    /*
     * WARNING - void declaration
     */
    public MonitoredQueuedThreadPool(int maxThreads) {
        void var1_1;
        int n = maxThreads;
        this(n, n, 86400000, new BlockingArrayQueue<Runnable>((int)var1_1, 256));
    }

    /*
     * WARNING - void declaration
     */
    public MonitoredQueuedThreadPool(int maxThreads, int minThreads, int idleTimeOut, BlockingQueue<Runnable> queue) {
        super((int)var1_1, (int)var2_2, (int)var3_3, queue);
        void var3_3;
        void var2_2;
        void var1_1;
        this.queueStats = new CounterStatistic();
        this.queueLatencyStats = new SampleStatistic();
        this.taskLatencyStats = new SampleStatistic();
        this.threadStats = new CounterStatistic();
        MonitoredQueuedThreadPool monitoredQueuedThreadPool = this;
        monitoredQueuedThreadPool.addBean(monitoredQueuedThreadPool.queueStats);
        MonitoredQueuedThreadPool monitoredQueuedThreadPool2 = this;
        monitoredQueuedThreadPool2.addBean(monitoredQueuedThreadPool2.queueLatencyStats);
        MonitoredQueuedThreadPool monitoredQueuedThreadPool3 = this;
        monitoredQueuedThreadPool3.addBean(monitoredQueuedThreadPool3.taskLatencyStats);
        MonitoredQueuedThreadPool monitoredQueuedThreadPool4 = this;
        monitoredQueuedThreadPool4.addBean(monitoredQueuedThreadPool4.threadStats);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(Runnable job) {
        void var1_1;
        void var2_2;
        this.queueStats.increment();
        long begin = System.nanoTime();
        super.execute(new Runnable(this, (long)var2_2, (Runnable)var1_1){
            final /* synthetic */ long val$begin;
            final /* synthetic */ Runnable val$job;
            final /* synthetic */ MonitoredQueuedThreadPool this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$begin = l;
                this.val$job = runnable;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                void var1_1;
                long queueLatency = System.nanoTime() - this.val$begin;
                this.this$0.queueStats.decrement();
                this.this$0.threadStats.increment();
                this.this$0.queueLatencyStats.record((long)var1_1);
                long start = System.nanoTime();
                try {
                    this.val$job.run();
                }
                catch (Throwable throwable) {
                    void var3_3;
                    long taskLatency = System.nanoTime() - var3_3;
                    this.this$0.threadStats.decrement();
                    this.this$0.taskLatencyStats.record(taskLatency);
                    throw throwable;
                }
                long taskLatency = System.nanoTime() - start;
                this.this$0.threadStats.decrement();
                this.this$0.taskLatencyStats.record(taskLatency);
            }

            public String toString() {
                return this.val$job.toString();
            }
        });
    }

    @ManagedOperation(value="resets the statistics", impact="ACTION")
    public void reset() {
        this.queueStats.reset();
        this.queueLatencyStats.reset();
        this.taskLatencyStats.reset();
        this.threadStats.reset(0L);
    }

    @ManagedAttribute(value="the number of tasks executed")
    public long getTasks() {
        return this.taskLatencyStats.getCount();
    }

    @ManagedAttribute(value="the maximum number of busy threads")
    public int getMaxBusyThreads() {
        return (int)this.threadStats.getMax();
    }

    @ManagedAttribute(value="the maximum task queue size")
    public int getMaxQueueSize() {
        return (int)this.queueStats.getMax();
    }

    @ManagedAttribute(value="the average time a task remains in the queue, in nanoseconds")
    public long getAverageQueueLatency() {
        return (long)this.queueLatencyStats.getMean();
    }

    @ManagedAttribute(value="the maximum time a task remains in the queue, in nanoseconds")
    public long getMaxQueueLatency() {
        return this.queueLatencyStats.getMax();
    }

    @ManagedAttribute(value="the average task execution time, in nanoseconds")
    public long getAverageTaskLatency() {
        return (long)this.taskLatencyStats.getMean();
    }

    @ManagedAttribute(value="the maximum task execution time, in nanoseconds")
    public long getMaxTaskLatency() {
        return this.taskLatencyStats.getMax();
    }
}

