/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.thread.ReservedThreadExecutor;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.ThreadPoolBudget;
import org.eclipse.jetty.util.thread.TryExecutor;

@ManagedObject(value="A thread pool")
public class ExecutorThreadPool
extends ContainerLifeCycle
implements ThreadPool.SizedThreadPool,
TryExecutor {
    private final ThreadPoolExecutor _executor;
    private final ThreadPoolBudget _budget;
    private final ThreadGroup _group;
    private String _name;
    private int _minThreads;
    private int _reservedThreads;
    private TryExecutor _tryExecutor;
    private int _priority;
    private boolean _daemon;
    private boolean _detailedDump;

    public ExecutorThreadPool() {
        this(200, 8);
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorThreadPool(int maxThreads) {
        this(maxThreads, Math.min(8, (int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorThreadPool(int maxThreads, int minThreads) {
        this((int)var1_1, (int)var2_2, new LinkedBlockingQueue<Runnable>());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorThreadPool(int maxThreads, int minThreads, BlockingQueue<Runnable> queue) {
        void var2_2;
        void var3_3;
        void var1_1;
        void v0 = var1_1;
        this(new ThreadPoolExecutor((int)v0, (int)v0, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)var3_3), (int)var2_2, -1, null);
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorThreadPool(ThreadPoolExecutor executor) {
        this((ThreadPoolExecutor)var1_1, -1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorThreadPool(ThreadPoolExecutor executor, int reservedThreads) {
        this((ThreadPoolExecutor)var1_1, (int)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorThreadPool(ThreadPoolExecutor executor, int reservedThreads, ThreadGroup group) {
        this(executor, Math.min(ProcessorUtils.availableProcessors(), var1_1.getCorePoolSize()), (int)var2_2, (ThreadGroup)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ExecutorThreadPool(ThreadPoolExecutor executor, int minThreads, int reservedThreads, ThreadGroup group) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._name = "etp" + this.hashCode();
        this._reservedThreads = -1;
        this._tryExecutor = TryExecutor.NO_TRY;
        this._priority = 5;
        int maxThreads = executor.getMaximumPoolSize();
        if (maxThreads < minThreads) {
            executor.shutdownNow();
            throw new IllegalArgumentException("max threads (" + maxThreads + ") cannot be less than min threads (" + minThreads + ")");
        }
        this._executor = var1_1;
        this._executor.setThreadFactory(this::newThread);
        this._group = group;
        this._minThreads = var2_2;
        this._reservedThreads = var3_3;
        this._budget = new ThreadPoolBudget(this);
    }

    @ManagedAttribute(value="name of this thread pool")
    public String getName() {
        return this._name;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._name = var1_1;
    }

    @Override
    @ManagedAttribute(value="minimum number of threads in the pool")
    public int getMinThreads() {
        return this._minThreads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMinThreads(int threads) {
        void var1_1;
        this._minThreads = var1_1;
    }

    @Override
    @ManagedAttribute(value="maximum number of threads in the pool")
    public int getMaxThreads() {
        return this._executor.getMaximumPoolSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxThreads(int threads) {
        void var1_1;
        if (this._budget != null) {
            this._budget.check(threads);
        }
        this._executor.setCorePoolSize(threads);
        this._executor.setMaximumPoolSize((int)var1_1);
    }

    @ManagedAttribute(value="maximum time a thread may be idle in ms")
    public int getIdleTimeout() {
        return (int)this._executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public void setIdleTimeout(int idleTimeout) {
        void var1_1;
        this._executor.setKeepAliveTime((long)var1_1, TimeUnit.MILLISECONDS);
    }

    @ManagedAttribute(value="the number of reserved threads in the pool")
    public int getReservedThreads() {
        if (this.isStarted()) {
            return this.getBean(ReservedThreadExecutor.class).getCapacity();
        }
        return this._reservedThreads;
    }

    /*
     * WARNING - void declaration
     */
    public void setReservedThreads(int reservedThreads) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._reservedThreads = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setThreadsPriority(int priority) {
        void var1_1;
        this._priority = var1_1;
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    @ManagedAttribute(value="whether this thread pool uses daemon threads")
    public boolean isDaemon() {
        return this._daemon;
    }

    /*
     * WARNING - void declaration
     */
    public void setDaemon(boolean daemon) {
        void var1_1;
        this._daemon = var1_1;
    }

    @ManagedAttribute(value="reports additional details in the dump")
    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    /*
     * WARNING - void declaration
     */
    public void setDetailedDump(boolean detailedDump) {
        void var1_1;
        this._detailedDump = var1_1;
    }

    @Override
    @ManagedAttribute(value="number of threads in the pool")
    public int getThreads() {
        return this._executor.getPoolSize();
    }

    @Override
    @ManagedAttribute(value="number of idle threads in the pool")
    public int getIdleThreads() {
        return this._executor.getPoolSize() - this._executor.getActiveCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(Runnable command) {
        void var1_1;
        this._executor.execute((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryExecute(Runnable task) {
        void var1_1;
        void var2_2;
        TryExecutor tryExecutor = this._tryExecutor;
        return tryExecutor != null && var2_2.tryExecute((Runnable)var1_1);
    }

    @Override
    @ManagedAttribute(value="thread pool is low on threads", readonly=true)
    public boolean isLowOnThreads() {
        return this.getThreads() == this.getMaxThreads() && this._executor.getQueue().size() >= this.getIdleThreads();
    }

    @Override
    protected void doStart() throws Exception {
        if (this._executor.isShutdown()) {
            throw new IllegalStateException("This thread pool is not restartable");
        }
        for (int i = 0; i < this._minThreads; ++i) {
            this._executor.prestartCoreThread();
        }
        ExecutorThreadPool executorThreadPool = this;
        this._tryExecutor = new ReservedThreadExecutor(executorThreadPool, executorThreadPool._reservedThreads);
        ExecutorThreadPool executorThreadPool2 = this;
        executorThreadPool2.addBean(executorThreadPool2._tryExecutor);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ExecutorThreadPool executorThreadPool = this;
        executorThreadPool.removeBean(executorThreadPool._tryExecutor);
        this._tryExecutor = TryExecutor.NO_TRY;
        this._executor.shutdownNow();
        this._budget.reset();
    }

    @Override
    public void join() throws InterruptedException {
        this._executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public ThreadPoolBudget getThreadPoolBudget() {
        return this._budget;
    }

    /*
     * WARNING - void declaration
     */
    protected Thread newThread(Runnable job) {
        void var1_1;
        Thread thread = new Thread(this._group, job);
        thread.setDaemon(this.isDaemon());
        thread.setPriority(this.getThreadsPriority());
        thread.setName(this.getName() + "-" + thread.getId());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        String prefix = this.getName() + "-";
        List threads = Thread.getAllStackTraces().entrySet().stream().filter(entry -> {
            String string;
            return ((Thread)entry.getKey()).getName().startsWith(string);
        }).map(entry -> {
            void var1_1;
            void var2_2;
            void var3_3;
            Thread thread = (Thread)entry.getKey();
            StackTraceElement[] frames = (StackTraceElement[])entry.getValue();
            String knownMethod = null;
            StackTraceElement[] stackTraceElementArray = frames;
            int n = frames.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement frame = stackTraceElementArray[i];
                if ("getTask".equals(frame.getMethodName()) && frame.getClassName().endsWith("ThreadPoolExecutor")) {
                    knownMethod = "IDLE ";
                    break;
                }
                if ("reservedWait".equals(frame.getMethodName()) && frame.getClassName().endsWith("ReservedThread")) {
                    knownMethod = "RESERVED ";
                    break;
                }
                if ("select".equals(frame.getMethodName()) && frame.getClassName().endsWith("SelectorProducer")) {
                    knownMethod = "SELECTING ";
                    break;
                }
                if (!"accept".equals(frame.getMethodName()) || !frame.getClassName().contains("ServerConnector")) continue;
                knownMethod = "ACCEPTING ";
                break;
            }
            String known = knownMethod == null ? "" : var3_3;
            return new Dumpable(this, (Thread)var2_2, known, (StackTraceElement[])var1_1){
                final /* synthetic */ Thread val$thread;
                final /* synthetic */ String val$known;
                final /* synthetic */ StackTraceElement[] val$frames;
                final /* synthetic */ ExecutorThreadPool this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$thread = thread;
                    this.val$known = string;
                    this.val$frames = stackTraceElementArray;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void dump(Appendable out, String indent) throws IOException {
                    void var3_3;
                    void var1_1;
                    StringBuilder b = new StringBuilder();
                    b.append(this.val$thread.getId()).append(" ").append(this.val$thread.getName()).append(" p=").append(this.val$thread.getPriority()).append(" ").append(this.val$known).append(this.val$thread.getState().toString());
                    if (this.this$0.isDetailedDump()) {
                        if (this.val$known.isEmpty()) {
                            void var2_2;
                            Dumpable.dumpObjects(out, (String)var2_2, b.toString(), this.val$frames);
                            return;
                        }
                        Dumpable.dumpObject(out, b.toString());
                        return;
                    }
                    b.append(" @ ").append(this.val$frames.length > 0 ? String.valueOf(this.val$frames[0]) : "<no_stack_frames>");
                    Dumpable.dumpObject((Appendable)var1_1, var3_3.toString());
                }

                @Override
                public String dump() {
                    return null;
                }
            };
        }).collect(Collectors.toList());
        List jobs = Collections.emptyList();
        if (this.isDetailedDump()) {
            jobs = new ArrayList<Runnable>(this._executor.getQueue());
        }
        this.dumpObjects((Appendable)var1_1, (String)var2_2, var3_3, new DumpableCollection("jobs", jobs));
    }

    @Override
    public String toString() {
        return String.format("%s[%s]@%x{%s,%d<=%d<=%d,i=%d,q=%d,%s}", this.getClass().getSimpleName(), this.getName(), this.hashCode(), this.getState(), this.getMinThreads(), this.getThreads(), this.getMaxThreads(), this.getIdleThreads(), this._executor.getQueue().size(), this._tryExecutor);
    }
}

