/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.statistic;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

public class SampleStatistic {
    private final LongAccumulator _max = new LongAccumulator(Math::max, 0L);
    private final AtomicLong _total = new AtomicLong();
    private final AtomicLong _count = new AtomicLong();
    private final LongAdder _totalVariance100 = new LongAdder();

    public void reset() {
        this._max.reset();
        this._total.set(0L);
        this._count.set(0L);
        this._totalVariance100.reset();
    }

    /*
     * WARNING - void declaration
     */
    public void record(long sample) {
        void var1_1;
        long total = this._total.addAndGet(sample);
        long count = this._count.incrementAndGet();
        if (count > 1L) {
            long delta10;
            void var3_2;
            void mean10 = var3_2 * 10L / count;
            long l = delta10 = sample * 10L - mean10;
            this._totalVariance100.add(l * l);
        }
        this._max.accumulate((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void set(long sample) {
        void var1_1;
        this.record((long)var1_1);
    }

    public long getMax() {
        return this._max.get();
    }

    public long getTotal() {
        return this._total.get();
    }

    public long getCount() {
        return this._count.get();
    }

    public double getMean() {
        long l = this.getCount();
        if (l > 0L) {
            return (double)this._total.get() / (double)this._count.get();
        }
        return 0.0;
    }

    /*
     * WARNING - void declaration
     */
    public double getVariance() {
        long variance100 = this._totalVariance100.sum();
        long count = this.getCount();
        if (count > 1L) {
            void var3_2;
            void var1_1;
            return (double)var1_1 / 100.0 / (double)(var3_2 - 1L);
        }
        return 0.0;
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public String toString() {
        return String.format("%s@%x{count=%d,mean=%d,total=%d,stddev=%f}", this.getClass().getSimpleName(), this.hashCode(), this.getCount(), this.getMax(), this.getTotal(), this.getStdDev());
    }
}

