/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.statistic;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class RateStatistic {
    private final Deque<Long> _samples = new ArrayDeque<Long>();
    private final long _nanoPeriod;
    private final TimeUnit _units;
    private long _max;
    private long _count;

    /*
     * WARNING - void declaration
     */
    public RateStatistic(long period, TimeUnit units) {
        void var3_2;
        void var1_1;
        this._nanoPeriod = TimeUnit.NANOSECONDS.convert((long)var1_1, units);
        this._units = var3_2;
    }

    public long getPeriod() {
        return this._units.convert(this._nanoPeriod, TimeUnit.NANOSECONDS);
    }

    public TimeUnit getUnits() {
        return this._units;
    }

    public void reset() {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            this._samples.clear();
            this._max = 0L;
            this._count = 0L;
            return;
        }
    }

    private void update() {
        this.update(System.nanoTime());
    }

    private void update(long now) {
        long expire = now - this._nanoPeriod;
        Long head = this._samples.peekFirst();
        while (head != null && head < expire) {
            this._samples.removeFirst();
            head = this._samples.peekFirst();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void age(long period, TimeUnit units) {
        void var1_1;
        long increment = TimeUnit.NANOSECONDS.convert((long)var1_1, units);
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            int size = this._samples.size();
            for (int i = 0; i < size; ++i) {
                this._samples.addLast(this._samples.removeFirst() - increment);
            }
            this.update();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int record() {
        long now = System.nanoTime();
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            void var1_2;
            ++this._count;
            this._samples.add(now);
            this.update(now);
            int rate = this._samples.size();
            if ((long)rate > this._max) {
                this._max = rate;
            }
            return (int)var1_2;
        }
    }

    public int getRate() {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            this.update();
            return this._samples.size();
        }
    }

    public long getMax() {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            return this._max;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long getOldest(TimeUnit units) {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            void var3_4;
            void var1_1;
            Long head = this._samples.peekFirst();
            if (head == null) {
                return -1L;
            }
            return var1_1.convert(System.nanoTime() - var3_4.longValue(), TimeUnit.NANOSECONDS);
        }
    }

    public long getCount() {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            return this._count;
        }
    }

    public String dump() {
        return this.dump(TimeUnit.MINUTES);
    }

    /*
     * WARNING - void declaration
     */
    public String dump(TimeUnit units) {
        long now = System.nanoTime();
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            void var1_1;
            void var2_3;
            String samples = this._samples.stream().mapToLong(t -> {
                void var3_2;
                void var1_1;
                return units.convert((long)(var1_1 - var3_2.longValue()), TimeUnit.NANOSECONDS);
            }).mapToObj(Long::toString).collect(Collectors.joining(System.lineSeparator()));
            return String.format("%s%n%s", this.toString((long)var2_3), var1_1);
        }
    }

    public String toString() {
        return this.toString(System.nanoTime());
    }

    /*
     * WARNING - void declaration
     */
    private String toString(long nanoTime) {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            void var1_1;
            this.update((long)var1_1);
            return String.format("%s@%x{count=%d,max=%d,rate=%d per %d %s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._count, this._max, this._samples.size(), this._units.convert(this._nanoPeriod, TimeUnit.NANOSECONDS), this._units});
        }
    }
}

