/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.statistic;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

public class CounterStatistic {
    private final LongAccumulator _max = new LongAccumulator(Math::max, 0L);
    private final AtomicLong _current = new AtomicLong();
    private final LongAdder _total = new LongAdder();

    /*
     * WARNING - void declaration
     */
    public void reset() {
        void var1_1;
        this._total.reset();
        this._max.reset();
        long current = this._current.get();
        this._total.add(current);
        this._max.accumulate((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void reset(long value) {
        this._current.set(value);
        this._total.reset();
        this._max.reset();
        if (value > 0L) {
            void var1_1;
            this._total.add(value);
            this._max.accumulate((long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public long add(long delta) {
        void var3_2;
        long value = this._current.addAndGet(delta);
        if (delta > 0L) {
            void var1_1;
            this._total.add((long)var1_1);
            this._max.accumulate(value);
        }
        return (long)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public long increment() {
        void var1_1;
        long value = this._current.incrementAndGet();
        this._total.increment();
        this._max.accumulate(value);
        return (long)var1_1;
    }

    public long decrement() {
        return this._current.decrementAndGet();
    }

    public long getMax() {
        return this._max.get();
    }

    public long getCurrent() {
        return this._current.get();
    }

    public long getTotal() {
        return this._total.sum();
    }

    public String toString() {
        return String.format("%s@%x{c=%d,m=%d,t=%d}", this.getClass().getSimpleName(), this.hashCode(), this.getCurrent(), this.getMax(), this.getTotal());
    }
}

