/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ssl;

import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class X509 {
    private static final Logger LOG = Log.getLogger(X509.class);
    private static final int KEY_USAGE__KEY_CERT_SIGN = 5;
    private static final int SUBJECT_ALTERNATIVE_NAMES__DNS_NAME = 2;
    private static final int SUBJECT_ALTERNATIVE_NAMES__IP_ADDRESS = 7;
    private final X509Certificate _x509;
    private final String _alias;
    private final Set<String> _hosts = new LinkedHashSet<String>();
    private final Set<String> _wilds = new LinkedHashSet<String>();
    private final Set<InetAddress> _addresses = new LinkedHashSet<InetAddress>();

    public static boolean isCertSign(X509Certificate x509) {
        Object object;
        boolean[] blArray = x509.getKeyUsage();
        Object keyUsage = blArray;
        if (blArray == null || ((Object)keyUsage).length <= 5) {
            return false;
        }
        return (boolean)object[5];
    }

    /*
     * WARNING - void declaration
     */
    public X509(String alias, X509Certificate x509) {
        this._alias = alias;
        this._x509 = x509;
        try {
            void var2_2;
            Object altNames = x509.getSubjectAlternativeNames();
            if (altNames != null) {
                altNames = altNames.iterator();
                while (altNames.hasNext()) {
                    List list = (List)altNames.next();
                    int n = ((Number)list.get(0)).intValue();
                    switch (n) {
                        case 2: {
                            String name = list.get(1).toString();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Certificate alias={} SAN dns={} in {}", alias, name, this);
                            }
                            this.addName(name);
                            break;
                        }
                        case 7: {
                            String address = list.get(1).toString();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Certificate alias={} SAN ip={} in {}", alias, address, this);
                            }
                            this.addAddress(address);
                        }
                    }
                }
            }
            altNames = new LdapName(var2_2.getSubjectX500Principal().getName("RFC2253"));
            for (Rdn rdn : ((LdapName)altNames).getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                String cn = rdn.getValue().toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Certificate CN alias={} CN={} in {}", alias, cn, this);
                }
                this.addName(cn);
            }
            return;
        }
        catch (Exception x) {
            void var3_4;
            throw new IllegalArgumentException((Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addName(String cn) {
        if (cn != null) {
            void var1_1;
            if ((cn = StringUtil.asciiToLowerCase(cn)).startsWith("*.")) {
                this._wilds.add(cn.substring(2));
                return;
            }
            this._hosts.add((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addAddress(String host) {
        InetAddress address = this.toInetAddress(host);
        if (address != null) {
            void var1_1;
            this._addresses.add((InetAddress)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private InetAddress toInetAddress(String address) {
        try {
            return InetAddress.getByName(address);
        }
        catch (Throwable x) {
            void var1_2;
            LOG.ignore((Throwable)var1_2);
            return null;
        }
    }

    public String getAlias() {
        return this._alias;
    }

    public X509Certificate getCertificate() {
        return this._x509;
    }

    public Set<String> getHosts() {
        return Collections.unmodifiableSet(this._hosts);
    }

    public Set<String> getWilds() {
        return Collections.unmodifiableSet(this._wilds);
    }

    /*
     * WARNING - void declaration
     */
    public boolean matches(String host) {
        void var1_1;
        InetAddress address;
        String domain;
        if (this._hosts.contains(host = StringUtil.asciiToLowerCase(host)) || this._wilds.contains(host)) {
            return true;
        }
        int dot = host.indexOf(46);
        if (dot >= 0 && this._wilds.contains(domain = host.substring(dot + 1))) {
            return true;
        }
        if (X509.seemsIPAddress(host) && (address = this.toInetAddress((String)var1_1)) != null) {
            void var2_4;
            return this._addresses.contains(var2_4);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean seemsIPAddress(String host) {
        String string;
        void var2_2;
        void var1_1;
        String ipv4RegExp = "[0-9\\.]+";
        String ipv6RegExp = "[0-9a-fA-F:\\[\\]]+";
        return host.matches((String)var1_1) || host.matches((String)var2_2) && X509.containsAtLeastTwoColons(string);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean containsAtLeastTwoColons(String host) {
        void var1_1;
        int index = host.indexOf(58);
        if (index >= 0) {
            String string;
            index = string.indexOf(58, index + 1);
        }
        return var1_1 > 0;
    }

    public String toString() {
        return String.format("%s@%x(%s,h=%s,a=%s,w=%s)", this.getClass().getSimpleName(), this.hashCode(), this._alias, this._hosts, this._addresses, this._wilds);
    }
}

