/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ssl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.component.Dumpable;

class SslSelectionDump
implements Dumpable {
    final String type;
    final CaptionedList enabled = new CaptionedList("Enabled");
    final CaptionedList disabled = new CaptionedList("Disabled");

    /*
     * WARNING - void declaration
     */
    public SslSelectionDump(String type, String[] supportedByJVM, String[] enabledByJVM, String[] excludedByConfig, String[] includedByConfig) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.type = type;
        List<String> jvmEnabled = Arrays.asList(enabledByJVM);
        List excludedPatterns = Arrays.stream(excludedByConfig).map(entry -> Pattern.compile(entry)).collect(Collectors.toList());
        List includedPatterns = Arrays.stream(includedByConfig).map(entry -> Pattern.compile(entry)).collect(Collectors.toList());
        Arrays.stream(var2_2).sorted(Comparator.naturalOrder()).forEach(arg_0 -> this.lambda$new$2((List)var3_3, includedPatterns, (List)var1_1, arg_0));
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        Dumpable.dumpObjects(out, (String)var2_2, this, this.enabled, this.disabled);
    }

    public String toString() {
        return String.format("%s Selections", this.type);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$new$2(List excludedPatterns, List includedPatterns, List jvmEnabled, String entry) {
        void var3_4;
        void var1_2;
        Object object;
        boolean isPresent = true;
        StringBuilder s = new StringBuilder();
        s.append(entry);
        excludedPatterns = excludedPatterns.iterator();
        while (excludedPatterns.hasNext()) {
            Pattern pattern = (Pattern)excludedPatterns.next();
            object = pattern.matcher(entry);
            if (!((Matcher)object).matches()) continue;
            if (isPresent) {
                s.append(" -");
                isPresent = false;
            } else {
                s.append(",");
            }
            s.append(" ConfigExcluded:'").append(pattern.pattern()).append('\'');
        }
        boolean isIncluded = false;
        if (!includedPatterns.isEmpty()) {
            Matcher matcher;
            Iterator iterator = matcher.iterator();
            while (iterator.hasNext()) {
                object = (Pattern)iterator.next();
                matcher = ((Pattern)object).matcher(entry);
                if (!matcher.matches()) continue;
                isIncluded = true;
                break;
            }
            if (!isIncluded) {
                if (isPresent) {
                    s.append(" -");
                    isPresent = false;
                } else {
                    s.append(",");
                }
                s.append(" ConfigIncluded:NotSelected");
            }
        }
        if (var1_2 == false && !var3_4.contains(entry)) {
            if (isPresent) {
                s.append(" -");
                isPresent = false;
            }
            s.append(" JVM:disabled");
        }
        if (isPresent) {
            this.enabled.add(s.toString());
            return;
        }
        this.disabled.add(s.toString());
    }

    static class CaptionedList
    extends ArrayList<String>
    implements Dumpable {
        private final String caption;

        /*
         * WARNING - void declaration
         */
        public CaptionedList(String caption) {
            void var1_1;
            this.caption = var1_1;
        }

        @Override
        public String dump() {
            return Dumpable.dump(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void dump(Appendable out, String indent) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            Object[] array = this.toArray();
            Dumpable.dumpObjects((Appendable)var1_1, (String)var2_2, this.caption + " size=" + array.length, (Object[])var3_3);
        }
    }
}

