/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.CertificateUtils;
import org.eclipse.jetty.util.security.CertificateValidator;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.AliasedX509ExtendedKeyManager;
import org.eclipse.jetty.util.ssl.SniX509ExtendedKeyManager;
import org.eclipse.jetty.util.ssl.SslSelectionDump;
import org.eclipse.jetty.util.ssl.X509;

@ManagedObject
public class SslContextFactory
extends AbstractLifeCycle
implements Dumpable {
    public static final TrustManager[] TRUST_ALL_CERTS = new X509TrustManager[]{new X509ExtendedTrustManagerWrapper(null)};
    public static final String DEFAULT_KEYMANAGERFACTORY_ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();
    public static final String DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM = TrustManagerFactory.getDefaultAlgorithm();
    public static final String KEYPASSWORD_PROPERTY = "org.eclipse.jetty.ssl.keypassword";
    public static final String PASSWORD_PROPERTY = "org.eclipse.jetty.ssl.password";
    private static final Logger LOG = Log.getLogger(SslContextFactory.class);
    private static final Logger LOG_CONFIG = LOG.getLogger("config");
    private static final String[] DEFAULT_EXCLUDED_PROTOCOLS = new String[]{"SSL", "SSLv2", "SSLv2Hello", "SSLv3"};
    private static final String[] DEFAULT_EXCLUDED_CIPHER_SUITES = new String[]{"^.*_(MD5|SHA|SHA1)$", "^TLS_RSA_.*$", "^SSL_.*$", "^.*_NULL_.*$", "^.*_anon_.*$"};
    private final Set<String> _excludeProtocols = new LinkedHashSet<String>();
    private final Set<String> _includeProtocols = new LinkedHashSet<String>();
    private final Set<String> _excludeCipherSuites = new LinkedHashSet<String>();
    private final Set<String> _includeCipherSuites = new LinkedHashSet<String>();
    private final Map<String, X509> _aliasX509 = new HashMap<String, X509>();
    private final Map<String, X509> _certHosts = new HashMap<String, X509>();
    private final Map<String, X509> _certWilds = new HashMap<String, X509>();
    private String[] _selectedProtocols;
    private boolean _useCipherSuitesOrder = true;
    private Comparator<String> _cipherComparator;
    private String[] _selectedCipherSuites;
    private Resource _keyStoreResource;
    private String _keyStoreProvider;
    private String _keyStoreType = "JKS";
    private String _certAlias;
    private Resource _trustStoreResource;
    private String _trustStoreProvider;
    private String _trustStoreType;
    private boolean _needClientAuth = false;
    private boolean _wantClientAuth = false;
    private Password _keyStorePassword;
    private Password _keyManagerPassword;
    private Password _trustStorePassword;
    private String _sslProvider;
    private String _sslProtocol = "TLS";
    private String _secureRandomAlgorithm;
    private String _keyManagerFactoryAlgorithm = DEFAULT_KEYMANAGERFACTORY_ALGORITHM;
    private String _trustManagerFactoryAlgorithm = DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM;
    private boolean _validateCerts;
    private boolean _validatePeerCerts;
    private int _maxCertPathLength = -1;
    private String _crlPath;
    private boolean _enableCRLDP = false;
    private boolean _enableOCSP = false;
    private String _ocspResponderURL;
    private KeyStore _setKeyStore;
    private KeyStore _setTrustStore;
    private boolean _sessionCachingEnabled = true;
    private int _sslSessionCacheSize = -1;
    private int _sslSessionTimeout = -1;
    private SSLContext _setContext;
    private String _endpointIdentificationAlgorithm = "HTTPS";
    private boolean _trustAll;
    private boolean _renegotiationAllowed = true;
    private int _renegotiationLimit = 5;
    private Factory _factory;
    private PKIXCertPathChecker _pkixCertPathChecker;
    private HostnameVerifier _hostnameVerifier;

    @Deprecated
    public SslContextFactory() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public SslContextFactory(boolean trustAll) {
        this((boolean)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public SslContextFactory(String keyStorePath) {
        this(false, (String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private SslContextFactory(boolean trustAll, String keyStorePath) {
        void var1_1;
        this.setTrustAll((boolean)var1_1);
        this.setExcludeProtocols(DEFAULT_EXCLUDED_PROTOCOLS);
        this.setExcludeCipherSuites(DEFAULT_EXCLUDED_CIPHER_SUITES);
        if (keyStorePath != null) {
            void var2_2;
            this.setKeyStorePath((String)var2_2);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        SslContextFactory sslContextFactory = this;
        synchronized (sslContextFactory) {
            this.load();
        }
        this.checkConfiguration();
    }

    /*
     * WARNING - void declaration
     */
    protected void checkConfiguration() {
        void var1_1;
        SSLEngine engine = this._factory._context.createSSLEngine();
        this.customize(engine);
        SSLParameters supported = engine.getSSLParameters();
        this.checkProtocols(supported);
        this.checkCiphers((SSLParameters)var1_1);
    }

    protected void checkTrustAll() {
        if (this.isTrustAll()) {
            LOG_CONFIG.warn("Trusting all certificates configured for {}", this);
        }
    }

    protected void checkEndPointIdentificationAlgorithm() {
        if (this.getEndpointIdentificationAlgorithm() == null) {
            LOG_CONFIG.warn("No Client EndPointIdentificationAlgorithm configured for {}", this);
        }
    }

    protected void checkProtocols(SSLParameters supported) {
        for (String protocol : supported.getProtocols()) {
            String[] stringArray = DEFAULT_EXCLUDED_PROTOCOLS;
            int n = DEFAULT_EXCLUDED_PROTOCOLS.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                if (!string.equals(protocol)) continue;
                LOG_CONFIG.warn("Protocol {} not excluded for {}", protocol, this);
            }
        }
    }

    protected void checkCiphers(SSLParameters supported) {
        for (String suite : supported.getCipherSuites()) {
            String[] stringArray = DEFAULT_EXCLUDED_CIPHER_SUITES;
            int n = DEFAULT_EXCLUDED_CIPHER_SUITES.length;
            for (int i = 0; i < n; ++i) {
                String excludedSuiteRegex = stringArray[i];
                if (!suite.matches(excludedSuiteRegex)) continue;
                LOG_CONFIG.warn("Weak cipher suite {} enabled for {}", suite, this);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void load() throws Exception {
        void var3_3;
        void var2_2;
        SSLSessionContext serverContext;
        SSLContext sSLContext;
        SSLContext context = this._setContext;
        KeyStore keyStore = this._setKeyStore;
        KeyStore trustStore = this._setTrustStore;
        if (context == null) {
            if (keyStore == null && this._keyStoreResource == null && trustStore == null && this._trustStoreResource == null) {
                TrustManager[] trustManagers = null;
                if (this.isTrustAll()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No keystore or trust store configured.  ACCEPTING UNTRUSTED CERTIFICATES!!!!!", new Object[0]);
                    }
                    trustManagers = TRUST_ALL_CERTS;
                }
                context = this.getSSLContextInstance();
                context.init(null, trustManagers, this.getSecureRandomInstance());
            } else {
                if (keyStore == null) {
                    SslContextFactory sslContextFactory = this;
                    keyStore = sslContextFactory.loadKeyStore(sslContextFactory._keyStoreResource);
                }
                if (trustStore == null) {
                    SslContextFactory sslContextFactory = this;
                    trustStore = sslContextFactory.loadTrustStore(sslContextFactory._trustStoreResource);
                }
                SslContextFactory sslContextFactory = this;
                Collection<? extends CRL> crls = sslContextFactory.loadCRL(sslContextFactory.getCrlPath());
                if (keyStore != null) {
                    for (String alias : Collections.list(keyStore.aliases())) {
                        Certificate certificate = keyStore.getCertificate(alias);
                        if (certificate == null || !"X.509".equals(certificate.getType())) continue;
                        X509Certificate x509C = (X509Certificate)certificate;
                        if (X509.isCertSign(x509C)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("Skipping " + x509C, new Object[0]);
                            continue;
                        }
                        X509 x509 = new X509(alias, x509C);
                        this._aliasX509.put(alias, x509);
                        if (this.isValidateCerts()) {
                            Iterator<String> validator = new CertificateValidator(trustStore, crls);
                            ((CertificateValidator)((Object)validator)).setMaxCertPathLength(this.getMaxCertPathLength());
                            ((CertificateValidator)((Object)validator)).setEnableCRLDP(this.isEnableCRLDP());
                            ((CertificateValidator)((Object)validator)).setEnableOCSP(this.isEnableOCSP());
                            ((CertificateValidator)((Object)validator)).setOcspResponderURL(this.getOcspResponderURL());
                            ((CertificateValidator)((Object)validator)).validate(keyStore, x509C);
                        }
                        LOG.info("x509={} for {}", x509, this);
                        for (String h : x509.getHosts()) {
                            this._certHosts.put(h, x509);
                        }
                        for (String w : x509.getWilds()) {
                            this._certWilds.put((String)((Object)sSLContext), x509);
                        }
                    }
                }
                KeyManager[] keyManagers = this.getKeyManagers(keyStore);
                TrustManager[] trustManagers = this.getTrustManagers(trustStore, crls);
                sSLContext = this.getSSLContextInstance();
                sSLContext.init(keyManagers, trustManagers, this.getSecureRandomInstance());
            }
        }
        if ((serverContext = sSLContext.getServerSessionContext()) != null) {
            if (this.getSslSessionCacheSize() >= 0) {
                serverContext.setSessionCacheSize(this.getSslSessionCacheSize());
            }
            if (this.getSslSessionTimeout() >= 0) {
                serverContext.setSessionTimeout(this.getSslSessionTimeout());
            }
        }
        SSLParameters enabled = sSLContext.getDefaultSSLParameters();
        SSLParameters supported = sSLContext.getSupportedSSLParameters();
        this.selectCipherSuites(enabled.getCipherSuites(), supported.getCipherSuites());
        this.selectProtocols(enabled.getProtocols(), supported.getProtocols());
        this._factory = new Factory((KeyStore)var2_2, (KeyStore)var3_3, sSLContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Selected Protocols {} of {}", Arrays.asList(this._selectedProtocols), Arrays.asList(supported.getProtocols()));
            LOG.debug("Selected Ciphers   {} of {}", Arrays.asList(this._selectedCipherSuites), Arrays.asList(supported.getCipherSuites()));
        }
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        try {
            void var2_2;
            void var1_1;
            SSLEngine sslEngine = SSLContext.getDefault().createSSLEngine();
            Dumpable.dumpObjects((Appendable)var1_1, (String)var2_2, this, "trustAll=" + this._trustAll, new SslSelectionDump("Protocol", sslEngine.getSupportedProtocols(), sslEngine.getEnabledProtocols(), this.getExcludeProtocols(), this.getIncludeProtocols()), new SslSelectionDump("Cipher Suite", sslEngine.getSupportedCipherSuites(), sslEngine.getEnabledCipherSuites(), this.getExcludeCipherSuites(), this.getIncludeCipherSuites()));
            return;
        }
        catch (NoSuchAlgorithmException x) {
            void var3_4;
            LOG.ignore((Throwable)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    List<SslSelectionDump> selectionDump() throws NoSuchAlgorithmException {
        void var2_2;
        void var1_1;
        SSLEngine sslEngine = SSLContext.getDefault().createSSLEngine();
        ArrayList<SslSelectionDump> selections = new ArrayList<SslSelectionDump>();
        selections.add(new SslSelectionDump("Protocol", sslEngine.getSupportedProtocols(), sslEngine.getEnabledProtocols(), this.getExcludeProtocols(), this.getIncludeProtocols()));
        selections.add(new SslSelectionDump("Cipher Suite", sslEngine.getSupportedCipherSuites(), var1_1.getEnabledCipherSuites(), this.getExcludeCipherSuites(), this.getIncludeCipherSuites()));
        return var2_2;
    }

    @Override
    protected void doStop() throws Exception {
        SslContextFactory sslContextFactory = this;
        synchronized (sslContextFactory) {
            this.unload();
        }
        super.doStop();
    }

    private void unload() {
        this._factory = null;
        this._selectedProtocols = null;
        this._selectedCipherSuites = null;
        this._aliasX509.clear();
        this._certHosts.clear();
        this._certWilds.clear();
    }

    Map<String, X509> aliasCerts() {
        return this._aliasX509;
    }

    @ManagedAttribute(value="The selected TLS protocol versions", readonly=true)
    public String[] getSelectedProtocols() {
        return Arrays.copyOf(this._selectedProtocols, this._selectedProtocols.length);
    }

    @ManagedAttribute(value="The selected cipher suites", readonly=true)
    public String[] getSelectedCipherSuites() {
        return Arrays.copyOf(this._selectedCipherSuites, this._selectedCipherSuites.length);
    }

    public Comparator<String> getCipherComparator() {
        return this._cipherComparator;
    }

    /*
     * WARNING - void declaration
     */
    public void setCipherComparator(Comparator<String> cipherComparator) {
        void var1_1;
        if (cipherComparator != null) {
            this.setUseCipherSuitesOrder(true);
        }
        this._cipherComparator = var1_1;
    }

    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this._aliasX509.keySet());
    }

    /*
     * WARNING - void declaration
     */
    public X509 getX509(String alias) {
        void var1_1;
        return this._aliasX509.get(var1_1);
    }

    @ManagedAttribute(value="The excluded TLS protocols")
    public String[] getExcludeProtocols() {
        return this._excludeProtocols.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludeProtocols(String ... protocols) {
        void var1_1;
        this._excludeProtocols.clear();
        this._excludeProtocols.addAll(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addExcludeProtocols(String ... protocol) {
        void var1_1;
        this._excludeProtocols.addAll(Arrays.asList(var1_1));
    }

    @ManagedAttribute(value="The included TLS protocols")
    public String[] getIncludeProtocols() {
        return this._includeProtocols.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludeProtocols(String ... protocols) {
        void var1_1;
        this._includeProtocols.clear();
        this._includeProtocols.addAll(Arrays.asList(var1_1));
    }

    @ManagedAttribute(value="The excluded cipher suites")
    public String[] getExcludeCipherSuites() {
        return this._excludeCipherSuites.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludeCipherSuites(String ... cipherSuites) {
        void var1_1;
        this._excludeCipherSuites.clear();
        this._excludeCipherSuites.addAll(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addExcludeCipherSuites(String ... cipher) {
        void var1_1;
        this._excludeCipherSuites.addAll(Arrays.asList(var1_1));
    }

    @ManagedAttribute(value="The included cipher suites")
    public String[] getIncludeCipherSuites() {
        return this._includeCipherSuites.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludeCipherSuites(String ... cipherSuites) {
        void var1_1;
        this._includeCipherSuites.clear();
        this._includeCipherSuites.addAll(Arrays.asList(var1_1));
    }

    @ManagedAttribute(value="Whether to respect the cipher suites order")
    public boolean isUseCipherSuitesOrder() {
        return this._useCipherSuitesOrder;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseCipherSuitesOrder(boolean useCipherSuitesOrder) {
        void var1_1;
        this._useCipherSuitesOrder = var1_1;
    }

    @ManagedAttribute(value="The keyStore path")
    public String getKeyStorePath() {
        return Objects.toString(this._keyStoreResource, null);
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyStorePath(String keyStorePath) {
        try {
            this._keyStoreResource = Resource.newResource(keyStorePath);
            return;
        }
        catch (Exception e) {
            void var1_2;
            throw new IllegalArgumentException((Throwable)var1_2);
        }
    }

    @ManagedAttribute(value="The keyStore provider name")
    public String getKeyStoreProvider() {
        return this._keyStoreProvider;
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyStoreProvider(String keyStoreProvider) {
        void var1_1;
        this._keyStoreProvider = var1_1;
    }

    @ManagedAttribute(value="The keyStore type")
    public String getKeyStoreType() {
        return this._keyStoreType;
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyStoreType(String keyStoreType) {
        void var1_1;
        this._keyStoreType = var1_1;
    }

    @ManagedAttribute(value="The certificate alias")
    public String getCertAlias() {
        return this._certAlias;
    }

    /*
     * WARNING - void declaration
     */
    public void setCertAlias(String certAlias) {
        void var1_1;
        this._certAlias = var1_1;
    }

    @ManagedAttribute(value="The trustStore path")
    public String getTrustStorePath() {
        return Objects.toString(this._trustStoreResource, null);
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustStorePath(String trustStorePath) {
        try {
            this._trustStoreResource = Resource.newResource(trustStorePath);
            return;
        }
        catch (Exception e) {
            void var1_2;
            throw new IllegalArgumentException((Throwable)var1_2);
        }
    }

    @ManagedAttribute(value="The trustStore provider name")
    public String getTrustStoreProvider() {
        return this._trustStoreProvider;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustStoreProvider(String trustStoreProvider) {
        void var1_1;
        this._trustStoreProvider = var1_1;
    }

    @ManagedAttribute(value="The trustStore type")
    public String getTrustStoreType() {
        return this._trustStoreType;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustStoreType(String trustStoreType) {
        void var1_1;
        this._trustStoreType = var1_1;
    }

    @ManagedAttribute(value="Whether client authentication is needed")
    @Deprecated
    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setNeedClientAuth(boolean needClientAuth) {
        void var1_1;
        this._needClientAuth = var1_1;
    }

    @ManagedAttribute(value="Whether client authentication is wanted")
    @Deprecated
    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setWantClientAuth(boolean wantClientAuth) {
        void var1_1;
        this._wantClientAuth = var1_1;
    }

    @ManagedAttribute(value="Whether certificates are validated")
    public boolean isValidateCerts() {
        return this._validateCerts;
    }

    /*
     * WARNING - void declaration
     */
    public void setValidateCerts(boolean validateCerts) {
        void var1_1;
        this._validateCerts = var1_1;
    }

    @ManagedAttribute(value="Whether peer certificates are validated")
    public boolean isValidatePeerCerts() {
        return this._validatePeerCerts;
    }

    /*
     * WARNING - void declaration
     */
    public void setValidatePeerCerts(boolean validatePeerCerts) {
        void var1_1;
        this._validatePeerCerts = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyStorePassword(String password) {
        void var1_1;
        if (password == null) {
            if (this._keyStoreResource != null) {
                this._keyStorePassword = this.getPassword(PASSWORD_PROPERTY);
                return;
            }
            this._keyStorePassword = null;
            return;
        }
        this._keyStorePassword = this.newPassword((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyManagerPassword(String password) {
        void var1_1;
        if (password == null) {
            if (System.getProperty(KEYPASSWORD_PROPERTY) != null) {
                this._keyManagerPassword = this.getPassword(KEYPASSWORD_PROPERTY);
                return;
            }
            this._keyManagerPassword = null;
            return;
        }
        this._keyManagerPassword = this.newPassword((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustStorePassword(String password) {
        void var1_1;
        if (password == null) {
            if (this._trustStoreResource != null && !this._trustStoreResource.equals(this._keyStoreResource)) {
                this._trustStorePassword = this.getPassword(PASSWORD_PROPERTY);
                return;
            }
            this._trustStorePassword = null;
            return;
        }
        this._trustStorePassword = this.newPassword((String)var1_1);
    }

    @ManagedAttribute(value="The provider name")
    public String getProvider() {
        return this._sslProvider;
    }

    /*
     * WARNING - void declaration
     */
    public void setProvider(String provider) {
        void var1_1;
        this._sslProvider = var1_1;
    }

    @ManagedAttribute(value="The TLS protocol")
    public String getProtocol() {
        return this._sslProtocol;
    }

    /*
     * WARNING - void declaration
     */
    public void setProtocol(String protocol) {
        void var1_1;
        this._sslProtocol = var1_1;
    }

    @ManagedAttribute(value="The SecureRandom algorithm")
    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    /*
     * WARNING - void declaration
     */
    public void setSecureRandomAlgorithm(String algorithm) {
        void var1_1;
        this._secureRandomAlgorithm = var1_1;
    }

    @ManagedAttribute(value="The KeyManagerFactory algorithm")
    public String getKeyManagerFactoryAlgorithm() {
        return this._keyManagerFactoryAlgorithm;
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyManagerFactoryAlgorithm(String algorithm) {
        void var1_1;
        this._keyManagerFactoryAlgorithm = var1_1;
    }

    @ManagedAttribute(value="The TrustManagerFactory algorithm")
    public String getTrustManagerFactoryAlgorithm() {
        return this._trustManagerFactoryAlgorithm;
    }

    @ManagedAttribute(value="Whether certificates should be trusted even if they are invalid")
    public boolean isTrustAll() {
        return this._trustAll;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustAll(boolean trustAll) {
        void var1_1;
        this._trustAll = trustAll;
        if (var1_1 != false) {
            this.setEndpointIdentificationAlgorithm(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustManagerFactoryAlgorithm(String algorithm) {
        void var1_1;
        this._trustManagerFactoryAlgorithm = var1_1;
    }

    @ManagedAttribute(value="Whether renegotiation is allowed")
    public boolean isRenegotiationAllowed() {
        return this._renegotiationAllowed;
    }

    /*
     * WARNING - void declaration
     */
    public void setRenegotiationAllowed(boolean renegotiationAllowed) {
        void var1_1;
        this._renegotiationAllowed = var1_1;
    }

    @ManagedAttribute(value="The max number of renegotiations allowed")
    public int getRenegotiationLimit() {
        return this._renegotiationLimit;
    }

    /*
     * WARNING - void declaration
     */
    public void setRenegotiationLimit(int renegotiationLimit) {
        void var1_1;
        this._renegotiationLimit = var1_1;
    }

    @ManagedAttribute(value="The path to the certificate revocation list file")
    public String getCrlPath() {
        return this._crlPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setCrlPath(String crlPath) {
        void var1_1;
        this._crlPath = var1_1;
    }

    @ManagedAttribute(value="The maximum number of intermediate certificates")
    public int getMaxCertPathLength() {
        return this._maxCertPathLength;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxCertPathLength(int maxCertPathLength) {
        void var1_1;
        this._maxCertPathLength = var1_1;
    }

    public SSLContext getSslContext() {
        if (!this.isStarted()) {
            return this._setContext;
        }
        SslContextFactory sslContextFactory = this;
        synchronized (sslContextFactory) {
            if (this._factory == null) {
                throw new IllegalStateException("SslContextFactory reload failed");
            }
            return this._factory._context;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSslContext(SSLContext sslContext) {
        void var1_1;
        this._setContext = var1_1;
    }

    @ManagedAttribute(value="The endpoint identification algorithm")
    public String getEndpointIdentificationAlgorithm() {
        return this._endpointIdentificationAlgorithm;
    }

    /*
     * WARNING - void declaration
     */
    public void setEndpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
        void var1_1;
        this._endpointIdentificationAlgorithm = var1_1;
    }

    public PKIXCertPathChecker getPkixCertPathChecker() {
        return this._pkixCertPathChecker;
    }

    /*
     * WARNING - void declaration
     */
    public void setPkixCertPathChecker(PKIXCertPathChecker pkixCertPatchChecker) {
        void var1_1;
        this._pkixCertPathChecker = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected KeyStore loadKeyStore(Resource resource) throws Exception {
        void var2_2;
        void var1_1;
        String storePassword = Objects.toString(this._keyStorePassword, null);
        return CertificateUtils.getKeyStore((Resource)var1_1, this.getKeyStoreType(), this.getKeyStoreProvider(), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected KeyStore loadTrustStore(Resource resource) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        String type = Objects.toString(this.getTrustStoreType(), this.getKeyStoreType());
        String provider = Objects.toString(this.getTrustStoreProvider(), this.getKeyStoreProvider());
        Password passwd = this._trustStorePassword;
        if (resource == null || resource.equals(this._keyStoreResource)) {
            resource = this._keyStoreResource;
            if (passwd == null) {
                passwd = this._keyStorePassword;
            }
        }
        return CertificateUtils.getKeyStore((Resource)var1_1, (String)var2_2, (String)var3_3, Objects.toString(passwd, null));
    }

    protected Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        return CertificateUtils.loadCRL(crlPath);
    }

    protected KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
        KeyManager[] keyManagerArray;
        Object managers = null;
        if (keyStore != null) {
            KeyManagerFactory keyManagerFactory = this.getKeyManagerFactoryInstance();
            keyManagerFactory.init(keyStore, this._keyManagerPassword == null ? (this._keyStorePassword == null ? null : this._keyStorePassword.toString().toCharArray()) : this._keyManagerPassword.toString().toCharArray());
            keyManagerArray = keyManagerArray.getKeyManagers();
            if (keyManagerArray != null) {
                boolean bl;
                String alias = this.getCertAlias();
                if (alias != null) {
                    for (int idx = 0; idx < keyManagerArray.length; ++idx) {
                        if (!(keyManagerArray[idx] instanceof X509ExtendedKeyManager)) continue;
                        keyManagerArray[idx] = new AliasedX509ExtendedKeyManager((X509ExtendedKeyManager)keyManagerArray[idx], alias);
                    }
                }
                if ((bl = this instanceof Server && ((Server)this).isSniRequired()) || !this._certWilds.isEmpty() || this._certHosts.size() > 1 || this._certHosts.size() == 1 && this._aliasX509.size() > 1) {
                    for (int idx = 0; idx < keyManagerArray.length; ++idx) {
                        if (!(keyManagerArray[idx] instanceof X509ExtendedKeyManager)) continue;
                        keyManagerArray[idx] = this.newSniX509ExtendedKeyManager((X509ExtendedKeyManager)keyManagerArray[idx]);
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("managers={} for {}", keyManagerArray, this);
        }
        return keyManagerArray;
    }

    @Deprecated
    protected X509ExtendedKeyManager newSniX509ExtendedKeyManager(X509ExtendedKeyManager keyManager) {
        throw new IllegalStateException(String.format("KeyStores with multiple certificates are not supported on the base class %s. (Use %s or %s instead)", SslContextFactory.class.getName(), Server.class.getName(), Client.class.getName()));
    }

    /*
     * WARNING - void declaration
     */
    protected TrustManager[] getTrustManagers(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
        void var3_3;
        TrustManager[] managers = null;
        if (trustStore != null) {
            void var1_1;
            if (this.isValidatePeerCerts() && "PKIX".equalsIgnoreCase(this.getTrustManagerFactoryAlgorithm())) {
                PKIXBuilderParameters pbParams = this.newPKIXBuilderParameters(trustStore, crls);
                TrustManagerFactory trustManagerFactory = this.getTrustManagerFactoryInstance();
                trustManagerFactory.init(new CertPathTrustManagerParameters(pbParams));
                managers = var1_1.getTrustManagers();
            } else {
                void var2_2;
                TrustManagerFactory trustManagerFactory = this.getTrustManagerFactoryInstance();
                trustManagerFactory.init((KeyStore)var1_1);
                managers = var2_2.getTrustManagers();
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected PKIXBuilderParameters newPKIXBuilderParameters(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
        void var1_1;
        PKIXBuilderParameters pbParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
        pbParams.setMaxPathLength(this._maxCertPathLength);
        pbParams.setRevocationEnabled(true);
        if (this._pkixCertPathChecker != null) {
            pbParams.addCertPathChecker(this._pkixCertPathChecker);
        }
        if (crls != null && !crls.isEmpty()) {
            void var2_2;
            pbParams.addCertStore(this.getCertStoreInstance((Collection<? extends CRL>)var2_2));
        }
        if (this._enableCRLDP) {
            System.setProperty("com.sun.security.enableCRLDP", "true");
        }
        if (this._enableOCSP) {
            Security.setProperty("ocsp.enable", "true");
            if (this._ocspResponderURL != null) {
                Security.setProperty("ocsp.responderURL", this._ocspResponderURL);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void selectProtocols(String[] enabledProtocols, String[] supportedProtocols) {
        void var1_1;
        List<String> selectedProtocols = this.processIncludeExcludePatterns("Protocols", enabledProtocols, supportedProtocols, this._includeProtocols, this._excludeProtocols);
        if (selectedProtocols.isEmpty()) {
            void var2_2;
            LOG.warn("No selected Protocols from {}", Arrays.asList(var2_2));
        }
        this._selectedProtocols = var1_1.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    protected void selectCipherSuites(String[] enabledCipherSuites, String[] supportedCipherSuites) {
        void var1_1;
        Comparator<String> comparator;
        List<String> selectedCiphers = this.processIncludeExcludePatterns("Cipher Suite", enabledCipherSuites, supportedCipherSuites, this._includeCipherSuites, this._excludeCipherSuites);
        if (selectedCiphers.isEmpty()) {
            LOG.warn("No supported Cipher Suite from {}", Arrays.asList(supportedCipherSuites));
        }
        if ((comparator = this.getCipherComparator()) != null) {
            void var2_2;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sorting selected ciphers with {}", comparator);
            }
            selectedCiphers.sort((Comparator<String>)var2_2);
        }
        this._selectedCipherSuites = var1_1.toArray(new String[0]);
    }

    private List<String> processIncludeExcludePatterns(String type, String[] enabled, String[] supported, Set<String> included, Set<String> excluded) {
        Pattern pattern;
        ArrayList<String> selected = new ArrayList<String>();
        if (included.isEmpty()) {
            Iterator<String> iterator;
            selected.addAll(Arrays.asList(iterator));
        } else {
            for (String includedItem : included) {
                pattern = Pattern.compile(includedItem);
                boolean added = false;
                String[] stringArray = supported;
                int n = supported.length;
                for (int i = 0; i < n; ++i) {
                    String supportedItem = stringArray[i];
                    if (!pattern.matcher(supportedItem).matches()) continue;
                    added = true;
                    selected.add(supportedItem);
                }
                if (added) continue;
                LOG.info("No {} matching '{}' is supported", type, includedItem);
            }
        }
        for (String string : excluded) {
            pattern = Pattern.compile(string);
            selected.removeIf(selectedItem -> {
                void var1_1;
                return pattern.matcher((CharSequence)var1_1).matches();
            });
        }
        return selected;
    }

    @Deprecated
    protected void processIncludeCipherSuites(String[] supportedCipherSuites, List<String> selectedCiphers) {
    }

    @Deprecated
    protected void removeExcludedCipherSuites(List<String> selectedCiphers) {
    }

    private void checkIsStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("!STARTED: " + this);
        }
    }

    @ManagedAttribute(value="Whether certificate revocation list distribution points is enabled")
    public boolean isEnableCRLDP() {
        return this._enableCRLDP;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableCRLDP(boolean enableCRLDP) {
        void var1_1;
        this._enableCRLDP = var1_1;
    }

    @ManagedAttribute(value="Whether online certificate status protocol support is enabled")
    public boolean isEnableOCSP() {
        return this._enableOCSP;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableOCSP(boolean enableOCSP) {
        void var1_1;
        this._enableOCSP = var1_1;
    }

    @ManagedAttribute(value="The online certificate status protocol URL")
    public String getOcspResponderURL() {
        return this._ocspResponderURL;
    }

    /*
     * WARNING - void declaration
     */
    public void setOcspResponderURL(String ocspResponderURL) {
        void var1_1;
        this._ocspResponderURL = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyStore(KeyStore keyStore) {
        void var1_1;
        this._setKeyStore = var1_1;
    }

    public KeyStore getKeyStore() {
        if (!this.isStarted()) {
            return this._setKeyStore;
        }
        SslContextFactory sslContextFactory = this;
        synchronized (sslContextFactory) {
            if (this._factory == null) {
                throw new IllegalStateException("SslContextFactory reload failed");
            }
            return this._factory._keyStore;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustStore(KeyStore trustStore) {
        void var1_1;
        this._setTrustStore = var1_1;
    }

    public KeyStore getTrustStore() {
        if (!this.isStarted()) {
            return this._setTrustStore;
        }
        SslContextFactory sslContextFactory = this;
        synchronized (sslContextFactory) {
            if (this._factory == null) {
                throw new IllegalStateException("SslContextFactory reload failed");
            }
            return this._factory._trustStore;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyStoreResource(Resource resource) {
        void var1_1;
        this._keyStoreResource = var1_1;
    }

    public Resource getKeyStoreResource() {
        return this._keyStoreResource;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustStoreResource(Resource resource) {
        void var1_1;
        this._trustStoreResource = var1_1;
    }

    public Resource getTrustStoreResource() {
        return this._trustStoreResource;
    }

    @ManagedAttribute(value="Whether TLS session caching is enabled")
    public boolean isSessionCachingEnabled() {
        return this._sessionCachingEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionCachingEnabled(boolean enableSessionCaching) {
        void var1_1;
        this._sessionCachingEnabled = var1_1;
    }

    @ManagedAttribute(value="The maximum TLS session cache size")
    public int getSslSessionCacheSize() {
        return this._sslSessionCacheSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setSslSessionCacheSize(int sslSessionCacheSize) {
        void var1_1;
        this._sslSessionCacheSize = var1_1;
    }

    @ManagedAttribute(value="The TLS session cache timeout, in seconds")
    public int getSslSessionTimeout() {
        return this._sslSessionTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setSslSessionTimeout(int sslSessionTimeout) {
        void var1_1;
        this._sslSessionTimeout = var1_1;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this._hostnameVerifier;
    }

    /*
     * WARNING - void declaration
     */
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        void var1_1;
        this._hostnameVerifier = var1_1;
    }

    protected Password getPassword(String realm) {
        return Password.getPassword(realm, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public Password newPassword(String password) {
        void var1_1;
        return new Password((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public SSLServerSocket newSslServerSocket(String host, int port, int backlog) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        this.checkIsStarted();
        SSLContext sSLContext = this.getSslContext();
        SSLServerSocketFactory factory = sSLContext.getServerSocketFactory();
        SSLServerSocket socket = (SSLServerSocket)(host == null ? factory.createServerSocket(port, backlog) : factory.createServerSocket((int)var2_2, (int)var3_3, InetAddress.getByName(host)));
        socket.setSSLParameters(this.customize(socket.getSSLParameters()));
        return var1_1;
    }

    public SSLSocket newSslSocket() throws IOException {
        this.checkIsStarted();
        Object object = this.getSslContext();
        object = ((SSLContext)object).getSocketFactory();
        SSLSocket socket = (SSLSocket)((SocketFactory)object).createSocket();
        socket.setSSLParameters(this.customize(socket.getSSLParameters()));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected CertificateFactory getCertificateFactoryInstance(String type) throws CertificateException {
        void var1_1;
        block3: {
            String provider = this.getProvider();
            try {
                if (provider != null) {
                    return CertificateFactory.getInstance(type, provider);
                }
            }
            catch (Throwable cause) {
                void var3_3;
                void var2_2;
                LOG.info("Unable to get CertificateFactory instance for type [{}] on provider [{}], using default", type, var2_2);
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Throwable)var3_3);
            }
        }
        return CertificateFactory.getInstance((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected CertStore getCertStoreInstance(Collection<? extends CRL> crls) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        void var1_1;
        void var2_2;
        block3: {
            String type = "Collection";
            String provider = this.getProvider();
            try {
                if (provider != null) {
                    return CertStore.getInstance(type, (CertStoreParameters)new CollectionCertStoreParameters(crls), provider);
                }
            }
            catch (Throwable cause) {
                void var3_3;
                LOG.info("Unable to get CertStore instance for type [{}] on provider [{}], using default", type, var3_3);
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(cause);
            }
        }
        return CertStore.getInstance((String)var2_2, new CollectionCertStoreParameters((Collection<?>)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected KeyManagerFactory getKeyManagerFactoryInstance() throws NoSuchAlgorithmException {
        void var1_1;
        block3: {
            String algorithm = this.getKeyManagerFactoryAlgorithm();
            String provider = this.getProvider();
            try {
                if (provider != null) {
                    return KeyManagerFactory.getInstance(algorithm, provider);
                }
            }
            catch (Throwable cause) {
                void var3_3;
                void var2_2;
                LOG.info("Unable to get KeyManagerFactory instance for algorithm [{}] on provider [{}], using default", algorithm, var2_2);
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Throwable)var3_3);
            }
        }
        return KeyManagerFactory.getInstance((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected SecureRandom getSecureRandomInstance() throws NoSuchAlgorithmException {
        String algorithm = this.getSecureRandomAlgorithm();
        if (algorithm != null) {
            void var1_1;
            block4: {
                String provider = this.getProvider();
                try {
                    if (provider != null) {
                        return SecureRandom.getInstance(algorithm, provider);
                    }
                }
                catch (Throwable cause) {
                    void var3_3;
                    void var2_2;
                    LOG.info("Unable to get SecureRandom instance for algorithm [{}] on provider [{}], using default", algorithm, var2_2);
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Throwable)var3_3);
                }
            }
            return SecureRandom.getInstance((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected SSLContext getSSLContextInstance() throws NoSuchAlgorithmException {
        void var1_1;
        block3: {
            String protocol = this.getProtocol();
            String provider = this.getProvider();
            try {
                if (provider != null) {
                    return SSLContext.getInstance(protocol, provider);
                }
            }
            catch (Throwable cause) {
                void var3_3;
                void var2_2;
                LOG.info("Unable to get SSLContext instance for protocol [{}] on provider [{}], using default", protocol, var2_2);
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Throwable)var3_3);
            }
        }
        return SSLContext.getInstance((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected TrustManagerFactory getTrustManagerFactoryInstance() throws NoSuchAlgorithmException {
        void var1_1;
        block3: {
            String algorithm = this.getTrustManagerFactoryAlgorithm();
            String provider = this.getProvider();
            try {
                if (provider != null) {
                    return TrustManagerFactory.getInstance(algorithm, provider);
                }
            }
            catch (Throwable cause) {
                void var3_3;
                void var2_2;
                LOG.info("Unable to get TrustManagerFactory instance for algorithm [{}] on provider [{}], using default", algorithm, var2_2);
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Throwable)var3_3);
            }
        }
        return TrustManagerFactory.getInstance((String)var1_1);
    }

    public SSLEngine newSSLEngine() {
        this.checkIsStarted();
        SSLContext sSLContext = this.getSslContext();
        SSLEngine sslEngine = sSLContext.createSSLEngine();
        this.customize(sslEngine);
        return sSLContext;
    }

    /*
     * WARNING - void declaration
     */
    public SSLEngine newSSLEngine(String host, int port) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.checkIsStarted();
        SSLContext context = this.getSslContext();
        SSLEngine sslEngine = this.isSessionCachingEnabled() ? context.createSSLEngine(host, (int)var2_2) : var3_3.createSSLEngine();
        this.customize(sslEngine);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLEngine newSSLEngine(InetSocketAddress address) {
        void var1_1;
        if (address == null) {
            return this.newSSLEngine();
        }
        return this.newSSLEngine(address.getHostString(), var1_1.getPort());
    }

    /*
     * WARNING - void declaration
     */
    public void customize(SSLEngine sslEngine) {
        void var1_1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Customize {}", sslEngine);
        }
        sslEngine.setSSLParameters(this.customize(var1_1.getSSLParameters()));
    }

    /*
     * WARNING - void declaration
     */
    public SSLParameters customize(SSLParameters sslParams) {
        void var1_1;
        sslParams.setEndpointIdentificationAlgorithm(this.getEndpointIdentificationAlgorithm());
        sslParams.setUseCipherSuitesOrder(this.isUseCipherSuitesOrder());
        if (!this._certHosts.isEmpty() || !this._certWilds.isEmpty()) {
            sslParams.setSNIMatchers(Collections.singletonList(new AliasSNIMatcher()));
        }
        if (this._selectedCipherSuites != null) {
            sslParams.setCipherSuites(this._selectedCipherSuites);
        }
        if (this._selectedProtocols != null) {
            sslParams.setProtocols(this._selectedProtocols);
        }
        if (!(this instanceof Client)) {
            if (this.getWantClientAuth()) {
                sslParams.setWantClientAuth(true);
            }
            if (this.getNeedClientAuth()) {
                sslParams.setNeedClientAuth(true);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void reload(Consumer<SslContextFactory> consumer) throws Exception {
        SslContextFactory sslContextFactory = this;
        synchronized (sslContextFactory) {
            void var1_1;
            var1_1.accept(this);
            this.unload();
            this.load();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public X509Certificate[] getX509CertChain(SSLSession sslSession) {
        void var1_1;
        return SslContextFactory.getX509CertChain(this, (SSLSession)var1_1);
    }

    public static X509Certificate[] getCertChain(SSLSession sslSession) {
        SSLSession sSLSession;
        return SslContextFactory.getX509CertChain(null, sSLSession);
    }

    /*
     * WARNING - void declaration
     */
    private static X509Certificate[] getX509CertChain(SslContextFactory sslContextFactory, SSLSession sslSession) {
        try {
            void var3_4;
            Certificate[] javaxCerts = sslSession.getPeerCertificates();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            int length = javaxCerts.length;
            X509Certificate[] javaCerts = new X509Certificate[length];
            String type = "X.509";
            CertificateFactory cf = sslContextFactory != null ? sslContextFactory.getCertificateFactoryInstance(type) : CertificateFactory.getInstance(type);
            for (int i = 0; i < length; ++i) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (X509Certificate)cf.generateCertificate(stream);
            }
            return var3_4;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return null;
        }
        catch (Exception e) {
            void var1_2;
            LOG.warn("EXCEPTION ", (Throwable)var1_2);
            return null;
        }
    }

    public static int deduceKeyLength(String cipherSuite) {
        String string;
        if (cipherSuite == null) {
            return 0;
        }
        if (cipherSuite.contains("WITH_AES_256_")) {
            return 256;
        }
        if (cipherSuite.contains("WITH_RC4_128_")) {
            return 128;
        }
        if (cipherSuite.contains("WITH_AES_128_")) {
            return 128;
        }
        if (cipherSuite.contains("WITH_RC4_40_")) {
            return 40;
        }
        if (cipherSuite.contains("WITH_3DES_EDE_CBC_")) {
            return 168;
        }
        if (cipherSuite.contains("WITH_IDEA_CBC_")) {
            return 128;
        }
        if (cipherSuite.contains("WITH_RC2_CBC_40_")) {
            return 40;
        }
        if (cipherSuite.contains("WITH_DES40_CBC_")) {
            return 40;
        }
        if (string.contains("WITH_DES_CBC_")) {
            return 56;
        }
        return 0;
    }

    @Override
    public String toString() {
        return String.format("%s@%x[provider=%s,keyStore=%s,trustStore=%s]", this.getClass().getSimpleName(), this.hashCode(), this._sslProvider, this._keyStoreResource, this._trustStoreResource);
    }

    public static class X509ExtendedTrustManagerWrapper
    extends X509ExtendedTrustManager {
        private final X509ExtendedTrustManager trustManager;

        /*
         * WARNING - void declaration
         */
        public X509ExtendedTrustManagerWrapper(X509ExtendedTrustManager trustManager) {
            void var1_1;
            this.trustManager = var1_1;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            if (this.trustManager == null) {
                return new X509Certificate[0];
            }
            return this.trustManager.getAcceptedIssuers();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            if (this.trustManager != null) {
                void var2_2;
                void var1_1;
                this.trustManager.checkClientTrusted((X509Certificate[])var1_1, (String)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            if (this.trustManager != null) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.trustManager.checkClientTrusted((X509Certificate[])var1_1, (String)var2_2, (Socket)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            if (this.trustManager != null) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.trustManager.checkClientTrusted((X509Certificate[])var1_1, (String)var2_2, (SSLEngine)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            if (this.trustManager != null) {
                void var2_2;
                void var1_1;
                this.trustManager.checkServerTrusted((X509Certificate[])var1_1, (String)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            if (this.trustManager != null) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.trustManager.checkServerTrusted((X509Certificate[])var1_1, (String)var2_2, (Socket)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            if (this.trustManager != null) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.trustManager.checkServerTrusted((X509Certificate[])var1_1, (String)var2_2, (SSLEngine)var3_3);
            }
        }
    }

    public static class X509ExtendedKeyManagerWrapper
    extends X509ExtendedKeyManager {
        private final X509ExtendedKeyManager keyManager;

        /*
         * WARNING - void declaration
         */
        public X509ExtendedKeyManagerWrapper(X509ExtendedKeyManager keyManager) {
            void var1_1;
            this.keyManager = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            void var2_2;
            void var1_1;
            if (this.keyManager == null) {
                return null;
            }
            return this.keyManager.getClientAliases((String)var1_1, (Principal[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.keyManager == null) {
                return null;
            }
            return this.keyManager.chooseClientAlias((String[])var1_1, (Principal[])var2_2, (Socket)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.keyManager == null) {
                return null;
            }
            return this.keyManager.chooseEngineClientAlias((String[])var1_1, (Principal[])var2_2, (SSLEngine)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            void var2_2;
            void var1_1;
            if (this.keyManager == null) {
                return null;
            }
            return this.keyManager.getServerAliases((String)var1_1, (Principal[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.keyManager == null) {
                return null;
            }
            return this.keyManager.chooseServerAlias((String)var1_1, (Principal[])var2_2, (Socket)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.keyManager == null) {
                return null;
            }
            return this.keyManager.chooseEngineServerAlias((String)var1_1, (Principal[])var2_2, (SSLEngine)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            void var1_1;
            if (this.keyManager == null) {
                return null;
            }
            return this.keyManager.getCertificateChain((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PrivateKey getPrivateKey(String alias) {
            void var1_1;
            if (this.keyManager == null) {
                return null;
            }
            return this.keyManager.getPrivateKey((String)var1_1);
        }
    }

    @ManagedObject
    public static class Server
    extends SslContextFactory
    implements SniX509ExtendedKeyManager.SniSelector {
        private boolean _sniRequired;
        private SniX509ExtendedKeyManager.SniSelector _sniSelector;

        public Server() {
            this.setEndpointIdentificationAlgorithm(null);
        }

        @Override
        public boolean getWantClientAuth() {
            return super.getWantClientAuth();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setWantClientAuth(boolean wantClientAuth) {
            void var1_1;
            super.setWantClientAuth((boolean)var1_1);
        }

        @Override
        public boolean getNeedClientAuth() {
            return super.getNeedClientAuth();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setNeedClientAuth(boolean needClientAuth) {
            void var1_1;
            super.setNeedClientAuth((boolean)var1_1);
        }

        @ManagedAttribute(value="Whether the TLS handshake is rejected if there is no SNI host match")
        public boolean isSniRequired() {
            return this._sniRequired;
        }

        /*
         * WARNING - void declaration
         */
        public void setSniRequired(boolean sniRequired) {
            void var1_1;
            this._sniRequired = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
            void var1_1;
            block2: {
                block3: {
                    KeyManager[] managers = super.getKeyManagers(keyStore);
                    if (!this.isSniRequired()) break block2;
                    if (managers == null) break block3;
                    if (!Arrays.stream(managers).noneMatch(SniX509ExtendedKeyManager.class::isInstance)) break block2;
                }
                throw new IllegalStateException("No SNI Key managers when SNI is required");
            }
            return var1_1;
        }

        public SniX509ExtendedKeyManager.SniSelector getSNISelector() {
            return this._sniSelector;
        }

        /*
         * WARNING - void declaration
         */
        public void setSNISelector(SniX509ExtendedKeyManager.SniSelector sniSelector) {
            void var1_1;
            this._sniSelector = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String sniSelect(String keyType, Principal[] issuers, SSLSession session, String sniHost, Collection<X509> certificates) {
            void var1_1;
            String alias;
            boolean sniRequired = this.isSniRequired();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting alias: keyType={}, sni={}, sniRequired={}, certs={}", keyType, String.valueOf(sniHost), sniRequired, certificates);
            }
            if (sniHost == null) {
                alias = sniRequired ? null : "delegate_no_sni_match";
            } else {
                List matching = certificates.stream().filter(x509 -> {
                    String string;
                    return x509.matches(string);
                }).collect(Collectors.toList());
                if (matching.isEmpty()) {
                    void var2_4;
                    boolean anyMatching = this.aliasCerts().values().stream().anyMatch(x509 -> {
                        String string;
                        return x509.matches(string);
                    });
                    alias = var2_4 != false || anyMatching ? null : "delegate_no_sni_match";
                } else {
                    alias = ((X509)matching.get(0)).getAlias();
                    if (matching.size() > 1) {
                        void var3_5;
                        alias = var3_5.stream().min(Comparator.comparingInt(cert -> cert.getWilds().size())).map(X509::getAlias).orElse(alias);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selected alias={}", String.valueOf(alias));
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected X509ExtendedKeyManager newSniX509ExtendedKeyManager(X509ExtendedKeyManager keyManager) {
            void var1_1;
            return new SniX509ExtendedKeyManager((X509ExtendedKeyManager)var1_1, this);
        }
    }

    public static class Client
    extends SslContextFactory {
        private SniProvider sniProvider = (sslEngine, serverNames) -> serverNames;

        public Client() {
            this(false);
        }

        /*
         * WARNING - void declaration
         */
        public Client(boolean trustAll) {
            super((boolean)var1_1);
            void var1_1;
        }

        @Override
        protected void checkConfiguration() {
            this.checkTrustAll();
            this.checkEndPointIdentificationAlgorithm();
            super.checkConfiguration();
        }

        @Override
        protected X509ExtendedKeyManager newSniX509ExtendedKeyManager(X509ExtendedKeyManager keyManager) {
            return keyManager;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void customize(SSLEngine sslEngine) {
            void var1_1;
            void var3_3;
            List<SNIServerName> newServerNames;
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            List<SNIServerName> serverNames = sslParameters.getServerNames();
            if (serverNames == null) {
                serverNames = Collections.emptyList();
            }
            if ((newServerNames = this.getSNIProvider().apply(sslEngine, serverNames)) != null && newServerNames != var3_3) {
                void var2_2;
                sslParameters.setServerNames(newServerNames);
                sslEngine.setSSLParameters((SSLParameters)var2_2);
            }
            super.customize((SSLEngine)var1_1);
        }

        public SniProvider getSNIProvider() {
            return this.sniProvider;
        }

        /*
         * WARNING - void declaration
         */
        public void setSNIProvider(SniProvider sniProvider) {
            void var1_1;
            this.sniProvider = (SniProvider)Objects.requireNonNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private static List<SNIServerName> getSniServerNames(SSLEngine sslEngine, List<SNIServerName> serverNames) {
            void var1_1;
            Object host;
            if (serverNames.isEmpty() && (host = sslEngine.getPeerHost()) != null) {
                Object object;
                return Collections.singletonList(new SNIHostName(((String)object).getBytes(StandardCharsets.US_ASCII)));
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ List access$400(SSLEngine x0, List x1) {
            void var1_1;
            return Client.getSniServerNames(x0, (List<SNIServerName>)var1_1);
        }

        @FunctionalInterface
        public static interface SniProvider {
            public static final SniProvider NON_DOMAIN_SNI_PROVIDER = (x$0, x$1) -> {
                void var1_1;
                return Client.access$400(x$0, (List)var1_1);
            };

            public List<SNIServerName> apply(SSLEngine var1, List<SNIServerName> var2);
        }
    }

    static class AliasSNIMatcher
    extends SNIMatcher {
        private String _host;

        AliasSNIMatcher() {
            super(0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(SNIServerName serverName) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SNI matching for {}", serverName);
            }
            if (serverName instanceof SNIHostName) {
                this._host = StringUtil.asciiToLowerCase(((SNIHostName)serverName).getAsciiName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SNI host name {}", this._host);
                }
            } else if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug("No SNI host name for {}", var1_1);
            }
            return true;
        }

        public String getHost() {
            return this._host;
        }
    }

    private static class Factory {
        private final KeyStore _keyStore;
        private final KeyStore _trustStore;
        private final SSLContext _context;

        /*
         * WARNING - void declaration
         */
        Factory(KeyStore keyStore, KeyStore trustStore, SSLContext context) {
            void var3_3;
            void var2_2;
            void var1_1;
            this._keyStore = var1_1;
            this._trustStore = var2_2;
            this._context = var3_3;
        }
    }
}

