/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class AliasedX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private final String _alias;
    private final X509ExtendedKeyManager _delegate;

    /*
     * WARNING - void declaration
     */
    public AliasedX509ExtendedKeyManager(X509ExtendedKeyManager keyManager, String keyAlias) {
        void var1_1;
        void var2_2;
        this._alias = var2_2;
        this._delegate = var1_1;
    }

    public X509ExtendedKeyManager getDelegate() {
        return this._delegate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        void var1_1;
        if (this._alias == null) {
            void var3_3;
            return this._delegate.chooseClientAlias(keyType, issuers, (Socket)var3_3);
        }
        for (void kt : var1_1) {
            String[] aliases = this._delegate.getClientAliases((String)kt, issuers);
            if (aliases == null) continue;
            String[] stringArray = aliases;
            int n = aliases.length;
            for (int i = 0; i < n; ++i) {
                String a = stringArray[i];
                if (!this._alias.equals(a)) continue;
                return this._alias;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        void var2_2;
        if (this._alias == null) {
            void var3_4;
            return this._delegate.chooseServerAlias(keyType, issuers, (Socket)var3_4);
        }
        String[] aliases = this._delegate.getServerAliases(keyType, (Principal[])var2_2);
        if (aliases != null) {
            void var1_1;
            for (void a : var1_1) {
                if (!this._alias.equals(a)) continue;
                return this._alias;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        void var2_2;
        void var1_1;
        return this._delegate.getClientAliases((String)var1_1, (Principal[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        void var2_2;
        void var1_1;
        return this._delegate.getServerAliases((String)var1_1, (Principal[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        void var1_1;
        return this._delegate.getCertificateChain((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PrivateKey getPrivateKey(String alias) {
        void var1_1;
        return this._delegate.getPrivateKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        void var2_2;
        if (this._alias == null) {
            void var3_4;
            return this._delegate.chooseEngineServerAlias(keyType, issuers, (SSLEngine)var3_4);
        }
        String[] aliases = this._delegate.getServerAliases(keyType, (Principal[])var2_2);
        if (aliases != null) {
            void var1_1;
            for (void a : var1_1) {
                if (!this._alias.equals(a)) continue;
                return this._alias;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        void var1_1;
        if (this._alias == null) {
            void var3_3;
            return this._delegate.chooseEngineClientAlias(keyType, issuers, (SSLEngine)var3_3);
        }
        for (void kt : var1_1) {
            String[] aliases = this._delegate.getClientAliases((String)kt, issuers);
            if (aliases == null) continue;
            String[] stringArray = aliases;
            int n = aliases.length;
            for (int i = 0; i < n; ++i) {
                String a = stringArray[i];
                if (!this._alias.equals(a)) continue;
                return this._alias;
            }
        }
        return null;
    }
}

