/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public class Password
extends Credential {
    private static final Logger LOG = Log.getLogger(Password.class);
    private static final long serialVersionUID = 5062906681431569445L;
    public static final String __OBFUSCATE = "OBF:";
    private String _pw;

    /*
     * WARNING - void declaration
     */
    public Password(String password) {
        void var1_1;
        this._pw = var1_1;
        while (this._pw != null && this._pw.startsWith(__OBFUSCATE)) {
            this._pw = Password.deobfuscate(this._pw);
        }
    }

    public String toString() {
        return this._pw;
    }

    public String toStarString() {
        return "*****************************************************".substring(0, this._pw.length());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean check(Object credentials) {
        if (this == credentials) {
            return true;
        }
        if (credentials instanceof Password) {
            return credentials.equals(this._pw);
        }
        if (credentials instanceof String) {
            return Password.stringEquals(this._pw, (String)credentials);
        }
        if (credentials instanceof char[]) {
            return Password.stringEquals(this._pw, new String((char[])credentials));
        }
        if (credentials instanceof Credential) {
            void var1_1;
            return ((Credential)var1_1).check(this._pw);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Password) {
            return Password.stringEquals(this._pw, ((Password)o)._pw);
        }
        if (o instanceof String) {
            void var1_1;
            return Password.stringEquals(this._pw, (String)var1_1);
        }
        return false;
    }

    public int hashCode() {
        if (this._pw == null) {
            return super.hashCode();
        }
        return this._pw.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public static String obfuscate(String s) {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        Object b = s.getBytes(StandardCharsets.UTF_8);
        buf.append(__OBFUSCATE);
        for (int i = 0; i < ((Object)b).length; ++i) {
            void var3_3;
            void x2;
            Object b1 = b[i];
            Object object = b;
            Object b2 = object[((Object)object).length - (i + 1)];
            if (b1 < 0 || b2 < 0) {
                int n = ((0xFF & b1) << 8) + (0xFF & b2);
                String x2 = Integer.toString(n, 36).toLowerCase(Locale.ENGLISH);
                buf.append("U0000", 0, 5 - x2.length());
                buf.append(x2);
                continue;
            }
            void i1 = x2 + 127 + b2;
            void i2 = x2 + 127 - b2;
            void i0 = (i1 << 8) + i2;
            String x3 = Integer.toString((int)i0, 36).toLowerCase(Locale.ENGLISH);
            Integer.parseInt(x3, 36);
            void j1 = i0 / 256;
            void j2 = i0 % 256;
            void cfr_ignored_0 = (j1 + var3_3 - 254) / 2;
            buf.append("000", 0, 4 - x3.length());
            buf.append(x3);
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String deobfuscate(String s) {
        void var2_2;
        void var1_1;
        if (s.startsWith(__OBFUSCATE)) {
            s = s.substring(4);
        }
        byte[] b = new byte[s.length() / 2];
        int l = 0;
        for (int i = 0; i < s.length(); i += 4) {
            if (s.charAt(i) == 'U') {
                int n = ++i;
                String string = s.substring(n, n + 4);
                int n2 = Integer.parseInt(string, 36);
                byte bx = (byte)(n2 >> 8);
                b[l++] = bx;
                continue;
            }
            int n = i;
            String string = s.substring(n, n + 4);
            int i0 = Integer.parseInt(string, 36);
            int i1 = i0 / 256;
            int i2 = i0 % 256;
            byte bx = (byte)((i1 + i2 - 254) / 2);
            b[l++] = bx;
        }
        return new String((byte[])var1_1, 0, (int)var2_2, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static Password getPassword(String realm, String dft, String promptDft) {
        void var1_2;
        String passwd = System.getProperty(realm, dft);
        if (passwd == null || passwd.length() == 0) {
            try {
                System.out.print(realm + (promptDft != null && promptDft.length() > 0 ? " [dft]" : "") + " : ");
                System.out.flush();
                Object buf = new byte[512];
                int len = System.in.read((byte[])buf);
                if (len > 0) {
                    void var3_4;
                    passwd = new String((byte[])buf, 0, (int)var3_4).trim();
                }
            }
            catch (IOException e) {
                void var0_1;
                LOG.warn("EXCEPTION ", (Throwable)var0_1);
            }
            if (passwd == null || passwd.length() == 0) {
                void var2_3;
                passwd = var2_3;
            }
        }
        return new Password((String)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] arg) {
        void var1_1;
        if (arg.length != 1 && arg.length != 2) {
            System.err.println("Usage - java " + Password.class.getName() + " [<user>] <password>");
            System.err.println("If the password is ?, the user will be prompted for the password");
            System.exit(1);
        }
        String p = arg[arg.length == 1 ? 0 : 1];
        Password pw = new Password(p);
        System.err.println(pw.toString());
        System.err.println(Password.obfuscate(pw.toString()));
        System.err.println(Credential.MD5.digest((String)var1_1));
        if (arg.length == 2) {
            void var2_2;
            String[] stringArray;
            System.err.println(Credential.Crypt.crypt(stringArray[0], var2_2.toString()));
        }
    }
}

