/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ServiceLoader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.CredentialProvider;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.security.UnixCrypt;

public abstract class Credential
implements Serializable {
    private static final long serialVersionUID = -7760551052768181572L;
    private static final Logger LOG = Log.getLogger(Credential.class);
    private static final ServiceLoader<CredentialProvider> CREDENTIAL_PROVIDER_LOADER = ServiceLoader.load(CredentialProvider.class);

    public abstract boolean check(Object var1);

    /*
     * WARNING - void declaration
     */
    public static Credential getCredential(String credential) {
        String string;
        if (credential.startsWith("CRYPT:")) {
            return new Crypt(credential);
        }
        if (credential.startsWith("MD5:")) {
            return new MD5(credential);
        }
        for (CredentialProvider cp : CREDENTIAL_PROVIDER_LOADER) {
            void var2_2;
            Credential credentialObj;
            if (!credential.startsWith(cp.getPrefix()) || (credentialObj = cp.getCredential(credential)) == null) continue;
            return var2_2;
        }
        return new Password(string);
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean stringEquals(String known, String unknown) {
        void var3_3;
        boolean bl = known == unknown;
        if (bl) {
            return true;
        }
        if (known == null || unknown == null) {
            return false;
        }
        boolean result = true;
        int l1 = known.length();
        int l2 = unknown.length();
        for (int i = 0; i < l2; ++i) {
            result &= (l1 == 0 ? unknown.charAt(l2 - i - 1) : known.charAt(i % l1)) == unknown.charAt(i);
        }
        return bl && var3_3 == l2;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean byteEquals(byte[] known, byte[] unknown) {
        void var3_3;
        void var2_2;
        if (known == unknown) {
            return true;
        }
        if (known == null || unknown == null) {
            return false;
        }
        boolean result = true;
        int l1 = known.length;
        int l2 = unknown.length;
        for (int i = 0; i < l2; ++i) {
            result &= (l1 == 0 ? unknown[l2 - i - 1] : known[i % l1]) == unknown[i];
        }
        return var2_2 != false && var3_3 == l2;
    }

    public static class MD5
    extends Credential {
        private static final long serialVersionUID = 5533846540822684240L;
        private static final String __TYPE = "MD5:";
        private static final Object __md5Lock = new Object();
        private static MessageDigest __md;
        private final byte[] _digest;

        /*
         * WARNING - void declaration
         */
        MD5(String digest) {
            void var1_1;
            digest = digest.startsWith(__TYPE) ? digest.substring(4) : digest;
            this._digest = TypeUtil.parseBytes((String)var1_1, 16);
        }

        public byte[] getDigest() {
            return this._digest;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean check(Object credentials) {
            try {
                byte[] digest;
                if (credentials instanceof char[]) {
                    credentials = new String((char[])credentials);
                }
                if (credentials instanceof Password || credentials instanceof String) {
                    Object object = __md5Lock;
                    synchronized (object) {
                        if (__md == null) {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        __md.reset();
                        __md.update(credentials.toString().getBytes(StandardCharsets.ISO_8859_1));
                        digest = __md.digest();
                    }
                    return MD5.byteEquals(this._digest, digest);
                }
                if (digest instanceof MD5) {
                    return this.equals(digest);
                }
                if (digest instanceof Credential) {
                    return ((Credential)digest).check(this);
                }
                LOG.warn("Can't check " + digest.getClass() + " against MD5", new Object[0]);
                return false;
            }
            catch (Exception e) {
                void var1_3;
                LOG.warn((Throwable)var1_3);
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            if (obj instanceof MD5) {
                void var1_1;
                return MD5.byteEquals(this._digest, ((MD5)var1_1)._digest);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public static String digest(String password) {
            try {
                Object digest;
                Object object = __md5Lock;
                synchronized (object) {
                    Object e2;
                    if (__md == null) {
                        try {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        catch (Exception e2) {
                            LOG.warn(e2);
                            return null;
                        }
                    }
                    __md.reset();
                    __md.update(((String)e2).getBytes(StandardCharsets.ISO_8859_1));
                    digest = __md.digest();
                }
                return __TYPE + TypeUtil.toString((byte[])digest, 16);
            }
            catch (Exception e) {
                void var0_3;
                LOG.warn((Throwable)var0_3);
                return null;
            }
        }
    }

    public static class Crypt
    extends Credential {
        private static final long serialVersionUID = -2027792997664744210L;
        private static final String __TYPE = "CRYPT:";
        private final String _cooked;

        /*
         * WARNING - void declaration
         */
        Crypt(String cooked) {
            void var1_1;
            this._cooked = cooked.startsWith(__TYPE) ? cooked.substring(6) : var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean check(Object credentials) {
            void var1_1;
            if (credentials instanceof char[]) {
                credentials = new String((char[])credentials);
            }
            if (!(credentials instanceof String) && !(credentials instanceof Password)) {
                LOG.warn("Can't check " + credentials.getClass() + " against CRYPT", new Object[0]);
            }
            return Crypt.stringEquals(this._cooked, UnixCrypt.crypt(var1_1.toString(), this._cooked));
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object credential) {
            void var1_1;
            if (!(credential instanceof Crypt)) {
                return false;
            }
            Crypt c = (Crypt)credential;
            return Crypt.stringEquals(this._cooked, var1_1._cooked);
        }

        /*
         * WARNING - void declaration
         */
        public static String crypt(String user, String pw) {
            String string;
            void var1_1;
            return __TYPE + UnixCrypt.crypt((String)var1_1, string);
        }
    }
}

