/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class CertificateValidator {
    private static final Logger LOG = Log.getLogger(CertificateValidator.class);
    private static AtomicLong __aliasCount = new AtomicLong();
    private KeyStore _trustStore;
    private Collection<? extends CRL> _crls;
    private int _maxCertPathLength = -1;
    private boolean _enableCRLDP = false;
    private boolean _enableOCSP = false;
    private String _ocspResponderURL;

    /*
     * WARNING - void declaration
     */
    public CertificateValidator(KeyStore trustStore, Collection<? extends CRL> crls) {
        void var2_2;
        void var1_1;
        if (trustStore == null) {
            throw new InvalidParameterException("TrustStore must be specified for CertificateValidator.");
        }
        this._trustStore = var1_1;
        this._crls = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void validate(KeyStore keyStore) throws CertificateException {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                void var3_4;
                String alias = aliases.nextElement();
                this.validate(keyStore, (String)var3_4);
            }
            return;
        }
        catch (KeyStoreException kse) {
            void var2_3;
            throw new CertificateException("Unable to retrieve aliases from keystore", (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String validate(KeyStore keyStore, String keyAlias) throws CertificateException {
        void var3_4;
        Object result = null;
        if (keyAlias != null) {
            void var2_3;
            try {
                KeyStore keyStore2 = keyStore;
                this.validate(keyStore2, keyStore2.getCertificate(keyAlias));
            }
            catch (KeyStoreException kse) {
                void var1_2;
                LOG.debug(kse);
                throw new CertificateException("Unable to validate certificate for alias [" + keyAlias + "]: " + kse.getMessage(), (Throwable)var1_2);
            }
            result = var2_3;
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public void validate(KeyStore keyStore, Certificate cert) throws CertificateException {
        if (cert != null && cert instanceof X509Certificate) {
            void var1_1;
            ((X509Certificate)cert).checkValidity();
            String certAlias = null;
            try {
                Certificate[] certChain;
                if (keyStore == null) {
                    throw new InvalidParameterException("Keystore cannot be null");
                }
                certAlias = keyStore.getCertificateAlias(cert);
                if (certAlias == null) {
                    void var2_3;
                    certAlias = "JETTY" + String.format("%016X", __aliasCount.incrementAndGet());
                    keyStore.setCertificateEntry(certAlias, (Certificate)var2_3);
                }
                if ((certChain = keyStore.getCertificateChain(certAlias)) == null || certChain.length == 0) {
                    throw new IllegalStateException("Unable to retrieve certificate chain");
                }
            }
            catch (KeyStoreException kse) {
                void var1_2;
                void var3_4;
                LOG.debug(kse);
                throw new CertificateException("Unable to validate certificate" + (certAlias == null ? "" : " for alias [" + (String)var3_4 + "]") + ": " + kse.getMessage(), (Throwable)var1_2);
            }
            this.validate((Certificate[])var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Certificate[] certChain) throws CertificateException {
        try {
            void var3_5;
            void var1_1;
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            for (Certificate item : certChain) {
                if (item == null) continue;
                if (!(item instanceof X509Certificate)) {
                    throw new IllegalStateException("Invalid certificate type in chain");
                }
                certList.add((X509Certificate)item);
            }
            if (certList.isEmpty()) {
                throw new IllegalStateException("Invalid certificate chain");
            }
            X509CertSelector certSelect = new X509CertSelector();
            certSelect.setCertificate((X509Certificate)certList.get(0));
            PKIXBuilderParameters pbParams = new PKIXBuilderParameters(this._trustStore, (CertSelector)var1_1);
            pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(certList)));
            pbParams.setMaxPathLength(this._maxCertPathLength);
            pbParams.setRevocationEnabled(true);
            if (this._crls != null && !this._crls.isEmpty()) {
                pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(this._crls)));
            }
            if (this._enableOCSP) {
                Security.setProperty("ocsp.enable", "true");
            }
            if (this._enableCRLDP) {
                System.setProperty("com.sun.security.enableCRLDP", "true");
            }
            CertPathBuilderResult buildResult = CertPathBuilder.getInstance("PKIX").build(pbParams);
            CertPathValidator.getInstance("PKIX").validate(buildResult.getCertPath(), (CertPathParameters)var3_5);
            return;
        }
        catch (GeneralSecurityException gse) {
            void var2_3;
            LOG.debug(gse);
            throw new CertificateException("Unable to validate certificate: " + gse.getMessage(), (Throwable)var2_3);
        }
    }

    public KeyStore getTrustStore() {
        return this._trustStore;
    }

    public Collection<? extends CRL> getCrls() {
        return this._crls;
    }

    public int getMaxCertPathLength() {
        return this._maxCertPathLength;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxCertPathLength(int maxCertPathLength) {
        void var1_1;
        this._maxCertPathLength = var1_1;
    }

    public boolean isEnableCRLDP() {
        return this._enableCRLDP;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableCRLDP(boolean enableCRLDP) {
        void var1_1;
        this._enableCRLDP = var1_1;
    }

    public boolean isEnableOCSP() {
        return this._enableOCSP;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableOCSP(boolean enableOCSP) {
        void var1_1;
        this._enableOCSP = var1_1;
    }

    public String getOcspResponderURL() {
        return this._ocspResponderURL;
    }

    /*
     * WARNING - void declaration
     */
    public void setOcspResponderURL(String ocspResponderURL) {
        void var1_1;
        this._ocspResponderURL = var1_1;
    }
}

