/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.io.Closeable;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jetty.util.resource.Resource;

public class CertificateUtils {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyStore getKeyStore(Resource store, String storeType, String storeProvider, String storePassword) throws Exception {
        void var1_2;
        void var2_4;
        KeyStore keystore = null;
        if (store == null) return keystore;
        Objects.requireNonNull(storeType, "storeType cannot be null");
        keystore = storeProvider != null ? KeyStore.getInstance(storeType, (String)var2_4) : KeyStore.getInstance((String)var1_2);
        if (!store.exists()) {
            throw new IllegalStateException(store.getName() + " is not a valid keystore");
        }
        Closeable inStream = store.getInputStream();
        try {
            void var3_5;
            keystore.load((InputStream)inStream, storePassword == null ? null : var3_5.toCharArray());
            if (inStream == null) return keystore;
        }
        catch (Throwable throwable) {
            if (inStream == null) throw throwable;
            try {
                Closeable closeable;
                ((InputStream)closeable).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((InputStream)inStream).close();
        return keystore;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        void var1_2;
        Collection<? extends CRL> crlList = null;
        if (crlPath == null) return var1_2;
        InputStream in = null;
        try {
            String string;
            in = Resource.newResource(string).getInputStream();
            crlList = CertificateFactory.getInstance("X.509").generateCRLs(in);
            if (in == null) return var1_2;
        }
        catch (Throwable throwable) {
            void var2_3;
            if (in == null) throw throwable;
            var2_3.close();
            throw throwable;
        }
        in.close();
        return var1_2;
    }
}

