/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.ReadableByteChannel;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class URLResource
extends Resource {
    private static final Logger LOG = Log.getLogger(URLResource.class);
    protected final URL _url;
    protected final String _urlString;
    protected URLConnection _connection;
    protected InputStream _in = null;
    transient boolean _useCaches = Resource.__defaultUseCaches;

    /*
     * WARNING - void declaration
     */
    protected URLResource(URL url, URLConnection connection) {
        void var2_2;
        void var1_1;
        this._url = var1_1;
        this._urlString = this._url.toExternalForm();
        this._connection = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected URLResource(URL url, URLConnection connection, boolean useCaches) {
        this((URL)var1_1, (URLConnection)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this._useCaches = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized boolean checkConnection() {
        if (this._connection == null) {
            try {
                this._connection = this._url.openConnection();
                this._connection.setUseCaches(this._useCaches);
            }
            catch (IOException e) {
                void var1_1;
                LOG.ignore((Throwable)var1_1);
            }
        }
        return this._connection != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void close() {
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (IOException e) {
                void var1_1;
                LOG.ignore((Throwable)var1_1);
            }
            this._in = null;
        }
        if (this._connection != null) {
            this._connection = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean exists() {
        try {
            URLResource uRLResource = this;
            synchronized (uRLResource) {
                if (this.checkConnection() && this._in == null) {
                    this._in = this._connection.getInputStream();
                }
            }
        }
        catch (IOException e) {
            void var1_2;
            LOG.ignore((Throwable)var1_2);
        }
        return this._in != null;
    }

    @Override
    public boolean isDirectory() {
        return ((Resource)this).exists() && this._urlString.endsWith("/");
    }

    @Override
    public long lastModified() {
        if (this.checkConnection()) {
            return this._connection.getLastModified();
        }
        return -1L;
    }

    @Override
    public long length() {
        if (this.checkConnection()) {
            return this._connection.getContentLength();
        }
        return -1L;
    }

    @Override
    public URL getURL() {
        return this._url;
    }

    @Override
    public File getFile() throws IOException {
        return null;
    }

    @Override
    public String getName() {
        return this._url.toExternalForm();
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        return this.getInputStream(true);
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized InputStream getInputStream(boolean resetConnection) throws IOException {
        if (!this.checkConnection()) {
            throw new IOException("Invalid resource");
        }
        try {
            if (this._in != null) {
                void var2_2;
                InputStream in = this._in;
                this._in = null;
                return var2_2;
            }
            InputStream inputStream = this._connection.getInputStream();
            return inputStream;
        }
        finally {
            if (resetConnection) {
                this._connection = null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection nulled", new Object[0]);
                }
            }
        }
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return null;
    }

    @Override
    public boolean delete() throws SecurityException {
        throw new SecurityException("Delete not supported");
    }

    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        throw new SecurityException("RenameTo not supported");
    }

    @Override
    public String[] list() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Resource addPath(String path) throws IOException {
        void var1_1;
        if (URIUtil.canonicalPath(path) == null) {
            throw new MalformedURLException(path);
        }
        return URLResource.newResource(URIUtil.addEncodedPaths(this._url.toExternalForm(), URIUtil.encodePath((String)var1_1)), this._useCaches);
    }

    public String toString() {
        return this._urlString;
    }

    public int hashCode() {
        return this._urlString.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        return o instanceof URLResource && this._urlString.equals(((URLResource)var1_1)._urlString);
    }

    public boolean getUseCaches() {
        return this._useCaches;
    }

    @Override
    public boolean isContainedIn(Resource containingResource) throws MalformedURLException {
        return false;
    }
}

