/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.resource.Resource;

public class ResourceCollection
extends Resource {
    private Resource[] _resources;

    public ResourceCollection() {
        this._resources = new Resource[0];
    }

    /*
     * WARNING - void declaration
     */
    public ResourceCollection(Resource ... resources) {
        void var2_2;
        Resource[] resourceArray;
        ArrayList<void> list = new ArrayList<void>();
        for (Resource r : resourceArray) {
            if (r == null) continue;
            if (r instanceof ResourceCollection) {
                Collections.addAll(list, ((ResourceCollection)r).getResources());
                continue;
            }
            list.add((void)r);
        }
        resourceArray = this._resources = var2_2.toArray(new Resource[0]);
        int n = this._resources.length;
        for (int i = 0; i < n; ++i) {
            Resource r;
            r = resourceArray[i];
            this.assertResourceValid(r);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResourceCollection(String[] resources2) {
        if (resources2 == null || ((Object)resources2).length == 0) {
            this._resources = null;
            return;
        }
        ArrayList<Resource> res = new ArrayList<Resource>();
        try {
            void var2_5;
            for (Object strResource : resources2) {
                if (strResource == null || ((String)strResource).length() == 0) {
                    throw new IllegalArgumentException("empty/null resource path not supported");
                }
                Resource resource = Resource.newResource((String)strResource);
                this.assertResourceValid(resource);
                res.add(resource);
            }
            if (res.isEmpty()) {
                this._resources = null;
                return;
            }
            this._resources = var2_5.toArray(new Resource[0]);
            return;
        }
        catch (RuntimeException runtimeException) {
            RuntimeException resources2 = runtimeException;
            throw runtimeException;
        }
        catch (Exception e) {
            void var1_4;
            throw new RuntimeException((Throwable)var1_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResourceCollection(String csvResources) {
        void var1_1;
        this.setResourcesAsCSV((String)var1_1);
    }

    public Resource[] getResources() {
        return this._resources;
    }

    /*
     * WARNING - void declaration
     */
    public void setResources(Resource[] resources) {
        void var2_2;
        void var1_1;
        if (resources == null || resources.length == 0) {
            this._resources = null;
            return;
        }
        ArrayList<void> res = new ArrayList<void>();
        for (void resource : var1_1) {
            this.assertResourceValid((Resource)resource);
            res.add(resource);
        }
        if (res.isEmpty()) {
            this._resources = null;
            return;
        }
        this._resources = var2_2.toArray(new Resource[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void setResourcesAsCSV(String csvResources) {
        if (csvResources == null) {
            throw new IllegalArgumentException("CSV String is null");
        }
        StringTokenizer tokenizer = new StringTokenizer(csvResources, ",;");
        int n = tokenizer.countTokens();
        if (n == 0) {
            throw new IllegalArgumentException("ResourceCollection@setResourcesAsCSV(String)  argument must be a string containing one or more comma-separated resource strings.");
        }
        ArrayList<Resource> res = new ArrayList<Resource>();
        try {
            void var2_3;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (token.length() == 0) continue;
                Resource resource = Resource.newResource(token);
                this.assertResourceValid(resource);
                res.add(resource);
            }
            if (res.isEmpty()) {
                this._resources = null;
                return;
            }
            this._resources = var2_3.toArray(new Resource[0]);
            return;
        }
        catch (RuntimeException runtimeException) {
            RuntimeException resource = runtimeException;
            throw runtimeException;
        }
        catch (Exception e) {
            void var3_6;
            throw new RuntimeException((Throwable)var3_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Resource addPath(String path) throws IOException {
        int i;
        this.assertResourcesSet();
        if (path == null) {
            throw new MalformedURLException();
        }
        if (path.length() == 0 || "/".equals(path)) {
            return this;
        }
        Resource resource = null;
        ArrayList<Resource> resources = null;
        for (i = 0; i < this._resources.length; ++i) {
            resource = this._resources[i].addPath(path);
            if (!resource.exists()) continue;
            if (resource.isDirectory()) break;
            return resource;
        }
        ++i;
        while (i < this._resources.length) {
            Resource r = this._resources[i].addPath(path);
            if (r.exists() && r.isDirectory()) {
                if (resources == null) {
                    resources = new ArrayList<Resource>();
                }
                if (resource != null) {
                    resources.add(resource);
                    resource = null;
                }
                resources.add(r);
            }
            ++i;
        }
        if (resource != null) {
            void var2_2;
            return var2_2;
        }
        if (resources != null) {
            void var3_3;
            return new ResourceCollection(var3_3.toArray(new Resource[0]));
        }
        throw new MalformedURLException();
    }

    @Override
    public boolean delete() throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists() {
        this.assertResourcesSet();
        return true;
    }

    @Override
    public File getFile() throws IOException {
        this.assertResourcesSet();
        Resource[] resourceArray = this._resources;
        int n = this._resources.length;
        for (int i = 0; i < n; ++i) {
            Resource resource = resourceArray[i];
            File f = resource.getFile();
            if (f == null) continue;
            return f;
        }
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.assertResourcesSet();
        Resource[] resourceArray = this._resources;
        int n = this._resources.length;
        for (int i = 0; i < n; ++i) {
            Resource resource = resourceArray[i];
            InputStream is = resource.getInputStream();
            if (is == null) continue;
            return is;
        }
        return null;
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        this.assertResourcesSet();
        Resource[] resourceArray = this._resources;
        int n = this._resources.length;
        for (int i = 0; i < n; ++i) {
            Resource resource = resourceArray[i];
            ReadableByteChannel channel = resource.getReadableByteChannel();
            if (channel == null) continue;
            return channel;
        }
        return null;
    }

    @Override
    public String getName() {
        this.assertResourcesSet();
        Resource[] resourceArray = this._resources;
        int n = this._resources.length;
        for (int i = 0; i < n; ++i) {
            Resource resource = resourceArray[i];
            String name = resource.getName();
            if (name == null) continue;
            return name;
        }
        return null;
    }

    @Override
    public URL getURL() {
        this.assertResourcesSet();
        Resource[] resourceArray = this._resources;
        int n = this._resources.length;
        for (int i = 0; i < n; ++i) {
            Resource resource = resourceArray[i];
            URL url = resource.getURL();
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        this.assertResourcesSet();
        return true;
    }

    @Override
    public long lastModified() {
        this.assertResourcesSet();
        Resource[] resourceArray = this._resources;
        int n = this._resources.length;
        for (int i = 0; i < n; ++i) {
            Resource resource = resourceArray[i];
            long lm = resource.lastModified();
            if (lm == -1L) continue;
            return lm;
        }
        return -1L;
    }

    @Override
    public long length() {
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] list() {
        void var1_1;
        this.assertResourcesSet();
        HashSet set = new HashSet();
        Resource[] resourceArray = this._resources;
        int n = this._resources.length;
        for (int i = 0; i < n; ++i) {
            Resource resource = resourceArray[i];
            String[] list = resource.list();
            if (list == null) continue;
            Collections.addAll(set, list);
        }
        Object[] result = var1_1.toArray(new String[0]);
        Arrays.sort(result);
        return resourceArray;
    }

    @Override
    public void close() {
        this.assertResourcesSet();
        Resource[] resourceArray = this._resources;
        int n = this._resources.length;
        for (int i = 0; i < n; ++i) {
            Resource resource = resourceArray[i];
            resource.close();
        }
    }

    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyTo(File destination) throws IOException {
        this.assertResourcesSet();
        int r = this._resources.length;
        while (r-- > 0) {
            this._resources[r].copyTo(destination);
        }
    }

    public String toString() {
        if (this._resources == null || this._resources.length == 0) {
            return "[]";
        }
        return String.valueOf(Arrays.asList(this._resources));
    }

    @Override
    public boolean isContainedIn(Resource r) {
        return false;
    }

    private void assertResourcesSet() {
        if (this._resources == null || this._resources.length == 0) {
            throw new IllegalStateException("*resources* not set.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void assertResourceValid(Resource resource) {
        if (resource == null) {
            throw new IllegalStateException("Null resource not supported");
        }
        if (!resource.exists() || !resource.isDirectory()) {
            void var1_1;
            throw new IllegalArgumentException(var1_1 + " is not an existing directory.");
        }
    }
}

