/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.BadResource;
import org.eclipse.jetty.util.resource.JarFileResource;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.ResourceCollators;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.URLResource;

public abstract class Resource
implements Closeable,
ResourceFactory {
    private static final Logger LOG = Log.getLogger(Resource.class);
    public static boolean __defaultUseCaches = true;
    volatile Object _associate;

    public static void setDefaultUseCaches(boolean useCaches) {
        __defaultUseCaches = useCaches;
    }

    public static boolean getDefaultUseCaches() {
        return __defaultUseCaches;
    }

    public static Resource newResource(URI uri) throws MalformedURLException {
        return Resource.newResource(uri.toURL());
    }

    public static Resource newResource(URL url) {
        return Resource.newResource(url, __defaultUseCaches);
    }

    /*
     * WARNING - void declaration
     */
    static Resource newResource(URL url, boolean useCaches) {
        URL uRL;
        void var2_3;
        void var1_1;
        if (url == null) {
            return null;
        }
        String urlString = url.toExternalForm();
        if (urlString.startsWith("file:")) {
            try {
                return new PathResource(url);
            }
            catch (Exception e) {
                void var1_2;
                LOG.warn(e.toString(), new Object[0]);
                LOG.debug("EXCEPTION ", e);
                return new BadResource(url, var1_2.toString());
            }
        }
        if (urlString.startsWith("jar:file:")) {
            return new JarFileResource(url, (boolean)var1_1);
        }
        if (var2_3.startsWith("jar:")) {
            return new JarResource(url, (boolean)var1_1);
        }
        return new URLResource(uRL, null, (boolean)var1_1);
    }

    public static Resource newResource(String resource) throws IOException {
        return Resource.newResource(resource, __defaultUseCaches);
    }

    /*
     * WARNING - void declaration
     */
    public static Resource newResource(String resource, boolean useCaches) throws IOException {
        void var1_1;
        void var2_3;
        try {
            URL url = new URL(resource);
        }
        catch (MalformedURLException e) {
            void var1_2;
            String string;
            if (!(resource.startsWith("ftp:") || resource.startsWith("file:") || resource.startsWith("jar:"))) {
                return new PathResource(Paths.get(resource, new String[0]));
            }
            LOG.warn("Bad Resource: " + string, new Object[0]);
            throw var1_2;
        }
        return Resource.newResource((URL)var2_3, (boolean)var1_1);
    }

    public static Resource newResource(File file) {
        File file2;
        return new PathResource(file2.toPath());
    }

    public static Resource newResource(Path path) {
        Path path2;
        return new PathResource(path2);
    }

    /*
     * WARNING - void declaration
     */
    public static Resource newSystemResource(String resource) throws IOException {
        URL uRL;
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                url = loader.getResource(resource);
                if (url == null && resource.startsWith("/")) {
                    url = loader.getResource(resource.substring(1));
                }
            }
            catch (IllegalArgumentException e) {
                void var1_2;
                LOG.ignore((Throwable)var1_2);
                uRL = null;
            }
        }
        if (uRL == null && (loader = Resource.class.getClassLoader()) != null && (uRL = loader.getResource(resource)) == null && resource.startsWith("/")) {
            void var2_3;
            uRL = var2_3.getResource(resource.substring(1));
        }
        if (uRL == null && (uRL = ClassLoader.getSystemResource(resource)) == null && resource.startsWith("/")) {
            String string;
            uRL = ClassLoader.getSystemResource(string.substring(1));
        }
        if (uRL == null) {
            return null;
        }
        return Resource.newResource(uRL);
    }

    public static Resource newClassPathResource(String resource) {
        return Resource.newClassPathResource(resource, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Resource newClassPathResource(String name, boolean useCaches, boolean checkParents) {
        void var1_1;
        void var2_3;
        URL url = Resource.class.getResource(name);
        if (url == null) {
            String string;
            url = Loader.getResource(string);
        }
        if (url == null) {
            return null;
        }
        return Resource.newResource((URL)var2_3, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isContainedIn(Resource r, Resource containingResource) throws MalformedURLException {
        void var1_1;
        return r.isContainedIn((Resource)var1_1);
    }

    protected void finalize() {
        this.close();
    }

    public abstract boolean isContainedIn(Resource var1) throws MalformedURLException;

    /*
     * WARNING - void declaration
     */
    public boolean isSame(Resource resource) {
        void var1_1;
        return this.equals(var1_1);
    }

    public final void release() {
        this.close();
    }

    @Override
    public abstract void close();

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract long lastModified();

    public abstract long length();

    @Deprecated
    public abstract URL getURL();

    /*
     * WARNING - void declaration
     */
    public URI getURI() {
        try {
            return this.getURL().toURI();
        }
        catch (Exception e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    public abstract File getFile() throws IOException;

    public abstract String getName();

    public abstract InputStream getInputStream() throws IOException;

    public abstract ReadableByteChannel getReadableByteChannel() throws IOException;

    public abstract boolean delete() throws SecurityException;

    public abstract boolean renameTo(Resource var1) throws SecurityException;

    public abstract String[] list();

    public abstract Resource addPath(String var1) throws IOException, MalformedURLException;

    /*
     * WARNING - void declaration
     */
    @Override
    public Resource getResource(String path) {
        try {
            return this.addPath(path);
        }
        catch (Exception e) {
            void var1_2;
            LOG.debug((Throwable)var1_2);
            return null;
        }
    }

    @Deprecated
    public String encode(String uri) {
        return null;
    }

    public Object getAssociate() {
        return this._associate;
    }

    /*
     * WARNING - void declaration
     */
    public void setAssociate(Object o) {
        void var1_1;
        this._associate = var1_1;
    }

    public boolean isAlias() {
        return this.getAlias() != null;
    }

    public URI getAlias() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String getListHTML(String base, boolean parent) throws IOException {
        void var2_2;
        void var1_1;
        return this.getListHTML((String)var1_1, (boolean)var2_2, null);
    }

    public String getListHTML(String base, boolean parent, String query) throws IOException {
        Iterator iterator;
        Object paramO;
        if ((base = URIUtil.canonicalPath(base)) == null || !this.isDirectory()) {
            return null;
        }
        String[] rawListing2 = this.list();
        if (rawListing2 == null) {
            return null;
        }
        boolean sortOrderAscending = true;
        String sortColumn = "N";
        if (query != null) {
            MultiMap<String> params = new MultiMap<String>();
            UrlEncoded.decodeUtf8To(query, 0, query.length(), params);
            paramO = params.getString("O");
            String paramC = params.getString("C");
            if (StringUtil.isNotBlank((String)paramO)) {
                if (((String)paramO).equals("A")) {
                    sortOrderAscending = true;
                } else if (((String)paramO).equals("D")) {
                    sortOrderAscending = false;
                }
            }
            if (StringUtil.isNotBlank(paramC) && (paramC.equals("N") || paramC.equals("M") || paramC.equals("S"))) {
                sortColumn = paramC;
            }
        }
        ArrayList<Resource> items = new ArrayList<Resource>();
        paramO = rawListing2;
        int paramC = rawListing2.length;
        for (int rawListing2 = 0; rawListing2 < paramC; ++rawListing2) {
            String l = paramO[rawListing2];
            Resource item = this.addPath(l);
            items.add(item);
        }
        if (sortColumn.equals("M")) {
            Collections.sort(items, ResourceCollators.byLastModified(sortOrderAscending));
        } else if (sortColumn.equals("S")) {
            Collections.sort(items, ResourceCollators.bySize(sortOrderAscending));
        } else {
            Collections.sort(items, ResourceCollators.byName(sortOrderAscending));
        }
        String decodedBase = URIUtil.decodePath(base);
        String title = "Directory: " + Resource.deTag(decodedBase);
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<!DOCTYPE html>\n");
        buf.append("<html lang=\"en\">\n");
        buf.append("<head>\n");
        buf.append("<meta charset=\"utf-8\">\n");
        buf.append("<link href=\"jetty-dir.css\" rel=\"stylesheet\" />\n");
        buf.append("<title>");
        buf.append(title);
        buf.append("</title>\n");
        buf.append("</head>\n");
        buf.append("<body>\n");
        buf.append("<h1 class=\"title\">").append(title).append("</h1>\n");
        buf.append("<table class=\"listing\">\n");
        buf.append("<thead>\n");
        String arrow = "";
        String order = "A";
        if (sortColumn.equals("N")) {
            if (sortOrderAscending) {
                order = "D";
                arrow = "&nbsp; &#8679;";
            } else {
                order = "A";
                arrow = "&nbsp; &#8681;";
            }
        }
        buf.append("<tr><th class=\"name\"><a href=\"?C=N&O=").append(order).append("\">");
        buf.append("Name").append(arrow);
        buf.append("</a></th>");
        arrow = "";
        order = "A";
        if (sortColumn.equals("M")) {
            if (sortOrderAscending) {
                order = "D";
                arrow = "&nbsp; &#8679;";
            } else {
                order = "A";
                arrow = "&nbsp; &#8681;";
            }
        }
        buf.append("<th class=\"lastmodified\"><a href=\"?C=M&O=").append(order).append("\">");
        buf.append("Last Modified").append(arrow);
        buf.append("</a></th>");
        arrow = "";
        order = "A";
        if (sortColumn.equals("S")) {
            if (sortOrderAscending) {
                order = "D";
                arrow = "&nbsp; &#8679;";
            } else {
                order = "A";
                arrow = "&nbsp; &#8681;";
            }
        }
        buf.append("<th class=\"size\"><a href=\"?C=S&O=").append(order).append("\">");
        buf.append("Size").append((String)((Object)iterator));
        buf.append("</a></th></tr>\n");
        buf.append("</thead>\n");
        buf.append("<tbody>\n");
        String encodedBase = Resource.hrefEncodeURI(base);
        if (parent) {
            buf.append("<tr><td class=\"name\"><a href=\"");
            buf.append(URIUtil.addPaths(encodedBase, "../"));
            buf.append("\">Parent Directory</a></td>");
            buf.append("<td class=\"lastmodified\">-</td>");
            buf.append("<td>-</td>");
            buf.append("</tr>\n");
        }
        DateFormat dfmt = DateFormat.getDateTimeInstance(2, 2);
        for (Resource item : items) {
            String name = item.getFileName();
            if (StringUtil.isBlank(name)) continue;
            if (item.isDirectory() && !name.endsWith("/")) {
                name = name + "/";
            }
            buf.append("<tr><td class=\"name\"><a href=\"");
            String path = URIUtil.addEncodedPaths(encodedBase, URIUtil.encodePath(name));
            buf.append(path);
            buf.append("\">");
            buf.append(Resource.deTag(name));
            buf.append("&nbsp;");
            buf.append("</a></td>");
            buf.append("<td class=\"lastmodified\">");
            long l = item.lastModified();
            if (l > 0L) {
                buf.append(dfmt.format(new Date(item.lastModified())));
            }
            buf.append("&nbsp;</td>");
            buf.append("<td class=\"size\">");
            long l2 = item.length();
            if (l2 >= 0L) {
                buf.append(String.format("%,d bytes", item.length()));
            }
            buf.append("&nbsp;</td></tr>\n");
        }
        buf.append("</tbody>\n");
        buf.append("</table>\n");
        buf.append("</body></html>\n");
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String getFileName() {
        try {
            File file = this.getFile();
            if (file != null) {
                return file.getName();
            }
        }
        catch (Throwable throwable) {}
        try {
            void var1_1;
            String encodedFileName;
            String rawName = this.getName();
            int idx = rawName.lastIndexOf(47);
            if (idx == rawName.length() - 1) {
                idx = rawName.lastIndexOf(47, idx - 1);
            }
            if (idx >= 0) {
                void var2_2;
                encodedFileName = rawName.substring((int)(var2_2 + true));
            }
            return UrlEncoded.decodeString(encodedFileName, 0, var1_1.length(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String hrefEncodeURI(String raw) {
        void var1_1;
        char c;
        int i;
        StringBuffer buf = null;
        block9: for (i = 0; i < raw.length(); ++i) {
            c = raw.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '<': 
                case '>': {
                    buf = new StringBuffer(raw.length() << 1);
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (buf == null) {
            return raw;
        }
        block10: for (i = 0; i < raw.length(); ++i) {
            char c2 = raw.charAt(i);
            switch (c2) {
                case '\"': {
                    buf.append("%22");
                    continue block10;
                }
                case '\'': {
                    buf.append("%27");
                    continue block10;
                }
                case '<': {
                    buf.append("%3C");
                    continue block10;
                }
                case '>': {
                    buf.append("%3E");
                    continue block10;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return var1_1.toString();
    }

    private static String deTag(String raw) {
        return StringUtil.sanitizeXmlString(raw);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeTo(OutputStream out, long start, long count) throws IOException {
        try (InputStream in = this.getInputStream();){
            void var2_3;
            in.skip((long)var2_3);
            if (count < 0L) {
                IO.copy(in, out);
            } else {
                void var1_1;
                IO.copy(in, (OutputStream)var1_1, count);
            }
            if (in == null) return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void copyTo(File destination) throws IOException {
        if (destination.exists()) {
            throw new IllegalArgumentException(destination + " exists");
        }
        FileOutputStream out = new FileOutputStream(destination);
        try {
            this.writeTo(out, 0L, -1L);
        }
        catch (Throwable throwable) {
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((OutputStream)out).close();
    }

    public String getWeakETag() {
        return this.getWeakETag("");
    }

    /*
     * WARNING - void declaration
     */
    public String getWeakETag(String suffix) {
        void var2_2;
        void var1_1;
        StringBuilder b = new StringBuilder(32);
        b.append("W/\"");
        String name = this.getName();
        int length = name.length();
        long lhash = 0L;
        for (int i = 0; i < length; ++i) {
            lhash = 31L * lhash + (long)name.charAt(i);
        }
        Base64.Encoder encoder = Base64.getEncoder().withoutPadding();
        b.append(encoder.encodeToString(Resource.longToBytes(this.lastModified() ^ lhash)));
        b.append(encoder.encodeToString(Resource.longToBytes(this.length() ^ lhash)));
        b.append((String)var1_1);
        b.append('\"');
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] longToBytes(long value) {
        void var2_1;
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return var2_1;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<Resource> getAllResources() {
        try {
            ArrayList<Resource> deep = new ArrayList<Resource>();
            String[] list = this.list();
            if (list != null) {
                void var2_3;
                for (void i : var2_3) {
                    Resource r = this.addPath((String)i);
                    if (r.isDirectory()) {
                        deep.addAll(r.getAllResources());
                        continue;
                    }
                    deep.add(r);
                }
            }
            return deep;
        }
        catch (Exception e) {
            void var1_2;
            throw new IllegalStateException((Throwable)var1_2);
        }
    }

    public static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }
}

