/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;

public class PathResource
extends Resource {
    private static final Logger LOG = Log.getLogger(PathResource.class);
    private static final LinkOption[] NO_FOLLOW_LINKS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    private static final LinkOption[] FOLLOW_LINKS = new LinkOption[0];
    private final Path path;
    private final Path alias;
    private final URI uri;
    private final boolean belongsToDefaultFileSystem;

    /*
     * WARNING - void declaration
     */
    private Path checkAliasPath() {
        Path normal;
        Path abs = this.path;
        if (!URIUtil.equalsIgnoreEncodings(this.uri, this.path.toUri())) {
            try {
                return Paths.get(this.uri).toRealPath(FOLLOW_LINKS);
            }
            catch (IOException ignored) {
                LOG.ignore(ignored);
            }
        }
        if (!abs.isAbsolute()) {
            abs = this.path.toAbsolutePath();
        }
        if (!PathResource.isSameName(abs, normal = this.path.normalize())) {
            return normal;
        }
        try {
            Path real;
            void var1_1;
            if (Files.isSymbolicLink(this.path)) {
                return this.path.getParent().resolve(Files.readSymbolicLink(this.path));
            }
            if (Files.exists(this.path, new LinkOption[0]) && !PathResource.isSameName((Path)var1_1, real = abs.toRealPath(FOLLOW_LINKS))) {
                return real;
            }
        }
        catch (IOException e) {
            LOG.ignore(e);
        }
        catch (Exception e) {
            void var2_5;
            LOG.warn("bad alias ({} {}) for {}", e.getClass().getName(), var2_5.getMessage(), this.path);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameName(Path pathA, Path pathB) {
        void var3_3;
        int bCount;
        int aCount = pathA.getNameCount();
        if (aCount != (bCount = pathB.getNameCount())) {
            return false;
        }
        void i = var3_3;
        while (i-- > 0) {
            if (pathA.getName((int)i).toString().equals(pathB.getName((int)i).toString())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public PathResource(File file) {
        this(var1_1.toPath());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PathResource(Path path) {
        void var1_1;
        void var2_2;
        block2: {
            Path absPath = path;
            try {
                absPath = path.toRealPath(NO_FOLLOW_LINKS);
            }
            catch (IOError | IOException e) {
                void var3_3;
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Unable to get real/canonical path for {}", path, var3_3);
            }
        }
        this.path = var2_2;
        this.assertValidPath((Path)var1_1);
        this.uri = this.path.toUri();
        this.alias = this.checkAliasPath();
        this.belongsToDefaultFileSystem = this.path.getFileSystem() == FileSystems.getDefault();
    }

    /*
     * WARNING - void declaration
     */
    private PathResource(PathResource parent, String childPath) {
        void var2_2;
        void var1_1;
        this.path = parent.path.getFileSystem().getPath(parent.path.toString(), childPath);
        if (((Resource)this).isDirectory() && !childPath.endsWith("/")) {
            childPath = childPath + "/";
        }
        this.uri = URIUtil.addPath(var1_1.uri, (String)var2_2);
        this.alias = this.checkAliasPath();
        this.belongsToDefaultFileSystem = this.path.getFileSystem() == FileSystems.getDefault();
    }

    /*
     * WARNING - void declaration
     */
    public PathResource(URI uri) throws IOException {
        void var2_2;
        Path path2;
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("not an absolute uri");
        }
        if (!uri.getScheme().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("not file: scheme");
        }
        try {
            path2 = Paths.get(uri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IllegalArgumentException path2 = illegalArgumentException;
            throw illegalArgumentException;
        }
        catch (Exception e) {
            void var1_1;
            LOG.ignore(e);
            throw new IOException("Unable to build Path from: " + var1_1, e);
        }
        this.path = path2.toAbsolutePath();
        this.uri = var2_2.toUri();
        this.alias = this.checkAliasPath();
        this.belongsToDefaultFileSystem = this.path.getFileSystem() == FileSystems.getDefault();
    }

    /*
     * WARNING - void declaration
     */
    public PathResource(URL url) throws IOException, URISyntaxException {
        this(var1_1.toURI());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSame(Resource resource) {
        block4: {
            try {
                Path path;
                if (resource instanceof PathResource) {
                    path = ((PathResource)resource).getPath();
                    return Files.isSameFile(this.getPath(), path);
                }
                if (path instanceof FileResource) {
                    path = ((Resource)((FileResource)((Object)path))).getFile().toPath();
                    return Files.isSameFile(this.getPath(), path);
                }
            }
            catch (IOException e) {
                void var1_2;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("ignored", (Throwable)var1_2);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Resource addPath(String subPath) throws IOException {
        void var1_1;
        if (URIUtil.canonicalPath(subPath) == null) {
            throw new MalformedURLException(subPath);
        }
        if ("/".equals(subPath)) {
            return this;
        }
        return new PathResource(this, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void assertValidPath(Path path) {
        String str = path.toString();
        int idx = StringUtil.indexOfControlChars(str);
        if (idx >= 0) {
            void var2_2;
            void var1_1;
            throw new InvalidPathException((String)var1_1, "Invalid Character at index " + (int)var2_2);
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delete() throws SecurityException {
        try {
            return Files.deleteIfExists(this.path);
        }
        catch (IOException e) {
            void var1_1;
            LOG.ignore((Throwable)var1_1);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathResource other = (PathResource)obj;
        if (this.path == null) {
            return other.path == null;
        }
        return this.path.equals(var1_1.path);
    }

    @Override
    public boolean exists() {
        return Files.exists(this.path, NO_FOLLOW_LINKS);
    }

    @Override
    public File getFile() throws IOException {
        if (!this.belongsToDefaultFileSystem) {
            return null;
        }
        return this.path.toFile();
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, StandardOpenOption.READ);
    }

    @Override
    public String getName() {
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return this.newSeekableByteChannel();
    }

    public SeekableByteChannel newSeekableByteChannel() throws IOException {
        return Files.newByteChannel(this.path, StandardOpenOption.READ);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public URL getURL() {
        try {
            return this.path.toUri().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public int hashCode() {
        int n = 31 + (this.path == null ? 0 : this.path.hashCode());
        return n;
    }

    @Override
    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.path, FOLLOW_LINKS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long lastModified() {
        try {
            FileTime fileTime = Files.getLastModifiedTime(this.path, FOLLOW_LINKS);
            return fileTime.toMillis();
        }
        catch (IOException e) {
            void var1_2;
            LOG.ignore((Throwable)var1_2);
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            return Files.size(this.path);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    @Override
    public boolean isAlias() {
        return this.alias != null;
    }

    public Path getAliasPath() {
        return this.alias;
    }

    @Override
    public URI getAlias() {
        if (this.alias == null) {
            return null;
        }
        return this.alias.toUri();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] list() {
        String[] stringArray;
        block10: {
            DirectoryStream<Path> dir = Files.newDirectoryStream(this.path);
            try {
                void var3_6;
                void var2_3;
                ArrayList<String> entries = new ArrayList<String>();
                for (Path entry : dir) {
                    String name = entry.getFileName().toString();
                    if (Files.isDirectory(entry, new LinkOption[0])) {
                        name = name + "/";
                    }
                    entries.add(name);
                }
                int size = entries.size();
                stringArray = var2_3.toArray(new String[var3_6]);
                if (dir == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (dir != null) {
                        try {
                            dir.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | DirectoryIteratorException e) {
                    void var1_2;
                    LOG.debug((Throwable)var1_2);
                    return null;
                }
            }
            dir.close();
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        if (dest instanceof PathResource) {
            Object destRes = (PathResource)dest;
            try {
                destRes = Files.move(this.path, ((PathResource)destRes).path, new CopyOption[0]);
                return Files.exists((Path)destRes, NO_FOLLOW_LINKS);
            }
            catch (IOException e) {
                void var1_2;
                LOG.ignore((Throwable)var1_2);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copyTo(File destination) throws IOException {
        void var1_1;
        if (((Resource)this).isDirectory()) {
            IO.copyDir(this.path.toFile(), destination);
            return;
        }
        Files.copy(this.path, var1_1.toPath(), new CopyOption[0]);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeTo(OutputStream outputStream, long start, long count) throws IOException {
        long length = count;
        if (count < 0L) {
            length = Files.size(this.path) - start;
        }
        try (SeekableByteChannel channel = Files.newByteChannel(this.path, StandardOpenOption.READ);){
            void var2_3;
            ByteBuffer buffer = BufferUtil.allocate(65536);
            this.skipTo(channel, buffer, start);
            for (long readTotal = 0L; readTotal < length; readTotal += (long)var2_3) {
                BufferUtil.clearToFill(buffer);
                int size = (int)Math.min(65536L, length - readTotal);
                buffer.limit(size);
                int readLen = channel.read(buffer);
                BufferUtil.flipToFlush(buffer, 0);
                BufferUtil.writeTo(buffer, outputStream);
            }
            if (channel == null) return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void skipTo(SeekableByteChannel channel, ByteBuffer buffer, long skipTo) throws IOException {
        try {
            if (channel.position() != skipTo) {
                channel.position(skipTo);
            }
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (skipTo > 0L) {
                long pos = 0L;
                int noProgressLoopLimit = 3;
                while (noProgressLoopLimit > 0 && pos < skipTo) {
                    BufferUtil.clearToFill(buffer);
                    int len = (int)Math.min(65536L, skipTo - pos);
                    buffer.limit(len);
                    long readLen = channel.read(buffer);
                    if (readLen == 0L) {
                        --noProgressLoopLimit;
                        continue;
                    }
                    if (readLen > 0L) {
                        pos += readLen;
                        noProgressLoopLimit = 3;
                        continue;
                    }
                    throw new IOException("EOF reached before SeekableByteChannel skip destination");
                }
                if (noProgressLoopLimit <= 0) {
                    void var3_3;
                    throw new IOException("No progress made to reach SeekableByteChannel skip position " + (long)var3_3);
                }
            }
            return;
        }
    }

    public String toString() {
        return this.uri.toASCIIString();
    }
}

