/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.Permission;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;

@Deprecated
public class FileResource
extends Resource {
    private static final Logger LOG = Log.getLogger(FileResource.class);
    private final File _file;
    private final URI _uri;
    private final URI _alias;

    /*
     * WARNING - void declaration
     */
    public FileResource(URL url) throws IOException, URISyntaxException {
        void var1_1;
        void var2_2;
        File file2;
        try {
            file2 = new File(url.toURI());
            this.assertValidPath(file2.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            URISyntaxException file2 = uRISyntaxException;
            throw uRISyntaxException;
        }
        catch (Exception e) {
            if (!url.toString().startsWith("file:")) {
                throw new IllegalArgumentException("!file:");
            }
            LOG.ignore(e);
            try {
                String fileUrl = "file:" + URIUtil.encodePath(url.toString().substring(5));
                URI uri = new URI(fileUrl);
                file2 = uri.getAuthority() == null ? new File(uri) : new File("//" + ((URI)((Object)file2)).getAuthority() + URIUtil.decodePath(url.getFile()));
            }
            catch (Exception ex22) {
                LOG.ignore(ex22);
                URLConnection ex22 = url.openConnection();
                Permission perm = ex22.getPermission();
                file2 = new File(perm == null ? url.getFile() : perm.getName());
            }
        }
        this._file = var2_2;
        this._uri = FileResource.normalizeURI(this._file, var1_1.toURI());
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    /*
     * WARNING - void declaration
     */
    public FileResource(URI uri) {
        File file;
        this._file = file = new File(uri);
        try {
            void var2_2;
            void var1_1;
            URI fileUri = this._file.toURI();
            this._uri = FileResource.normalizeURI(this._file, (URI)var1_1);
            this.assertValidPath(var2_2.toString());
            if (URIUtil.equalsIgnoreEncodings(this._uri.toASCIIString(), fileUri.toString())) {
                this._alias = FileResource.checkFileAlias(this._uri, this._file);
                return;
            }
            this._alias = this._file.toURI();
        }
        catch (URISyntaxException e) {
            void var3_4;
            FileResource fileResource = this;
            throw new InvalidPathException(fileResource, fileResource._file.toString(), e.getMessage(), (URISyntaxException)var3_4){
                final /* synthetic */ URISyntaxException val$e;
                final /* synthetic */ FileResource this$0;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$e = uRISyntaxException;
                    super((String)var2_2, (String)var3_3);
                    1 v0 = this;
                    v0.initCause(v0.val$e);
                }
            };
        }
    }

    /*
     * WARNING - void declaration
     */
    public FileResource(File file) {
        this.assertValidPath(file.toString());
        this._file = file;
        try {
            this._uri = FileResource.normalizeURI(this._file, this._file.toURI());
        }
        catch (URISyntaxException e) {
            void var1_2;
            FileResource fileResource = this;
            throw new InvalidPathException(fileResource, fileResource._file.toString(), e.getMessage(), (URISyntaxException)var1_2){
                final /* synthetic */ URISyntaxException val$e;
                final /* synthetic */ FileResource this$0;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$e = uRISyntaxException;
                    super((String)var2_2, (String)var3_3);
                    2 v0 = this;
                    v0.initCause(v0.val$e);
                }
            };
        }
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    /*
     * WARNING - void declaration
     */
    public FileResource(File base, String childPath) {
        void var3_3;
        String encoded = URIUtil.encodePath(childPath);
        this._file = new File(base, childPath);
        try {
            URI uri;
            uri = base.isDirectory() ? new URI(URIUtil.addEncodedPaths(base.toURI().toASCIIString(), encoded)) : new URI(base.toURI().toASCIIString() + (String)((Object)uri));
        }
        catch (URISyntaxException e) {
            void var2_2;
            void var1_1;
            throw new InvalidPathException(this, var1_1.toString() + (String)var2_2, e.getMessage(), e){
                final /* synthetic */ URISyntaxException val$e;
                final /* synthetic */ FileResource this$0;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$e = uRISyntaxException;
                    super((String)var2_2, (String)var3_3);
                    3 v0 = this;
                    v0.initCause(v0.val$e);
                }
            };
        }
        this._uri = var3_3;
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSame(Resource resource) {
        block4: {
            try {
                Path path;
                if (resource instanceof PathResource) {
                    path = ((PathResource)resource).getPath();
                    return Files.isSameFile(((Resource)this).getFile().toPath(), path);
                }
                if (path instanceof FileResource) {
                    path = ((Resource)((FileResource)((Object)path))).getFile().toPath();
                    return Files.isSameFile(((Resource)this).getFile().toPath(), path);
                }
            }
            catch (IOException e) {
                void var1_2;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("ignored", (Throwable)var1_2);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static URI normalizeURI(File file, URI uri) throws URISyntaxException {
        void var1_1;
        File file2;
        String u = uri.toASCIIString();
        if (file.isDirectory()) {
            if (!u.endsWith("/")) {
                u = u + "/";
            }
        } else if (file2.exists() && u.endsWith("/")) {
            u = u.substring(0, u.length() - 1);
        }
        return new URI((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static URI checkFileAlias(URI uri, File file) {
        try {
            String can;
            if (!URIUtil.equalsIgnoreEncodings(uri, file.toURI())) {
                return new File(uri).getAbsoluteFile().toURI();
            }
            URI abs = file.getAbsolutePath();
            if (!((String)((Object)abs)).equals(can = file.getCanonicalPath())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ALIAS abs={} can={}", abs, can);
                }
                URI alias = new File(can).toURI();
                return new URI("file://" + URIUtil.encodePath(alias.getPath()));
            }
        }
        catch (Exception e) {
            void var1_2;
            LOG.warn("bad alias for {}: {}", var1_2, e.toString());
            LOG.debug(e);
            try {
                return new URI("https://eclipse.org/bad/canonical/alias");
            }
            catch (Exception ex2) {
                void var0_1;
                void var2_4;
                LOG.ignore((Throwable)var2_4);
                throw new RuntimeException((Throwable)var0_1);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Resource addPath(String path) throws IOException {
        void var1_1;
        this.assertValidPath(path);
        if (URIUtil.canonicalPath(path) == null) {
            throw new MalformedURLException(path);
        }
        if ("/".equals(path)) {
            return this;
        }
        return new FileResource(this._file, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void assertValidPath(String path) {
        int idx = StringUtil.indexOfControlChars(path);
        if (idx >= 0) {
            void var2_2;
            void var1_1;
            throw new InvalidPathException((String)var1_1, "Invalid Character at index " + (int)var2_2);
        }
    }

    @Override
    public URI getAlias() {
        return this._alias;
    }

    @Override
    public boolean exists() {
        return this._file.exists();
    }

    @Override
    public long lastModified() {
        return this._file.lastModified();
    }

    @Override
    public boolean isDirectory() {
        return this._file.exists() && this._file.isDirectory() || this._uri.toASCIIString().endsWith("/");
    }

    @Override
    public long length() {
        return this._file.length();
    }

    @Override
    public String getName() {
        return this._file.getAbsolutePath();
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return FileChannel.open(this._file.toPath(), StandardOpenOption.READ);
    }

    @Override
    public boolean delete() throws SecurityException {
        return this._file.delete();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        if (dest instanceof FileResource) {
            void var1_1;
            return this._file.renameTo(((FileResource)var1_1)._file);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] list() {
        void var1_1;
        String[] list = this._file.list();
        if (list == null) {
            return null;
        }
        int i = list.length;
        while (i-- > 0) {
            if (!new File(this._file, list[i]).isDirectory() || list[i].endsWith("/")) continue;
            int n = i;
            list[n] = list[n] + "/";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof FileResource)) {
            return false;
        }
        FileResource f = (FileResource)o;
        return f._file == this._file || this._file != null && this._file.equals(var1_1._file);
    }

    public int hashCode() {
        if (this._file == null) {
            return super.hashCode();
        }
        return this._file.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void copyTo(File destination) throws IOException {
        void var1_1;
        if (((Resource)this).isDirectory()) {
            IO.copyDir(((Resource)this).getFile(), destination);
            return;
        }
        if (destination.exists()) {
            throw new IllegalArgumentException(destination + " exists");
        }
        IO.copy(((Resource)this).getFile(), (File)var1_1);
    }

    @Override
    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return false;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public URL getURL() {
        try {
            return this._uri.toURL();
        }
        catch (MalformedURLException e) {
            void var1_1;
            throw new IllegalStateException((Throwable)var1_1);
        }
    }

    @Override
    public URI getURI() {
        return this._uri;
    }

    public String toString() {
        return this._uri.toString();
    }
}

