/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.io.PrintStream;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Jetty StdErr Logging Implementation")
public class StdErrLog
extends AbstractLogger {
    private static final String EOL = System.lineSeparator();
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static int __tagpad = Integer.parseInt(Log.__props.getProperty("org.eclipse.jetty.util.log.StdErrLog.TAG_PAD", "0"));
    private static DateCache _dateCache;
    private static final boolean __source;
    private static final boolean __long;
    private static final boolean __escape;
    private int _level;
    private int _configuredLevel;
    private PrintStream _altStream;
    private boolean _source;
    private boolean _printLongNames = __long;
    private final String _name;
    protected final String _abbrevname;
    private boolean _hideStacks = false;

    public static void setTagPad(int pad) {
        __tagpad = pad;
    }

    /*
     * WARNING - void declaration
     */
    public static int getLoggingLevel(Properties props, String name) {
        void var1_2;
        Properties properties;
        int level = StdErrLog.lookupLoggingLevel(props, name);
        if (level == -1 && (level = StdErrLog.lookupLoggingLevel(properties, "log")) == -1) {
            level = 2;
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static StdErrLog getLogger(Class<?> clazz) {
        Class<?> clazz2;
        Logger log = Log.getLogger(clazz);
        if (log instanceof StdErrLog) {
            void var1_1;
            return (StdErrLog)var1_1;
        }
        throw new RuntimeException("Logger for " + clazz2 + " is not of type StdErrLog");
    }

    public StdErrLog() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public StdErrLog(String name) {
        this((String)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StdErrLog(String name, Properties props) {
        void var3_3;
        boolean sameObject;
        boolean bl = sameObject = props != Log.__props;
        if (props != null && var3_3 != false) {
            void var2_2;
            Log.__props.putAll((Map<?, ?>)var2_2);
        }
        this._name = name == null ? "" : name;
        this._abbrevname = StdErrLog.condensePackageString(this._name);
        this._configuredLevel = this._level = StdErrLog.getLoggingLevel(Log.__props, this._name);
        try {
            String source = StdErrLog.getLoggingProperty(Log.__props, this._name, "SOURCE");
            this._source = source == null ? __source : Boolean.parseBoolean(source);
        }
        catch (AccessControlException accessControlException) {
            this._source = __source;
        }
        try {
            void var1_1;
            String stacks = StdErrLog.getLoggingProperty(Log.__props, this._name, "STACKS");
            this._hideStacks = stacks != null && !Boolean.parseBoolean((String)var1_1);
            return;
        }
        catch (AccessControlException accessControlException) {
            return;
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    /*
     * WARNING - void declaration
     */
    public void setPrintLongNames(boolean printLongNames) {
        void var1_1;
        this._printLongNames = var1_1;
    }

    public boolean isPrintLongNames() {
        return this._printLongNames;
    }

    public boolean isHideStacks() {
        return this._hideStacks;
    }

    /*
     * WARNING - void declaration
     */
    public void setHideStacks(boolean hideStacks) {
        void var1_1;
        this._hideStacks = var1_1;
    }

    public boolean isSource() {
        return this._source;
    }

    /*
     * WARNING - void declaration
     */
    public void setSource(boolean source) {
        void var1_1;
        this._source = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg, Object ... args) {
        if (this._level <= 3) {
            void var3_3;
            void var2_2;
            void var1_1;
            StringBuilder builder = new StringBuilder(64);
            this.format(builder, ":WARN:", (String)var1_1, (Object[])var2_2);
            this.println((StringBuilder)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Throwable thrown) {
        void var1_1;
        this.warn("", (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg, Throwable thrown) {
        if (this._level <= 3) {
            void var3_3;
            void var2_2;
            void var1_1;
            StringBuilder builder = new StringBuilder(64);
            this.format(builder, ":WARN:", (String)var1_1, var2_2);
            this.println((StringBuilder)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg, Object ... args) {
        if (this._level <= 2) {
            void var3_3;
            void var2_2;
            void var1_1;
            StringBuilder builder = new StringBuilder(64);
            this.format(builder, ":INFO:", (String)var1_1, (Object[])var2_2);
            this.println((StringBuilder)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Throwable thrown) {
        void var1_1;
        this.info("", (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg, Throwable thrown) {
        if (this._level <= 2) {
            void var3_3;
            void var2_2;
            void var1_1;
            StringBuilder builder = new StringBuilder(64);
            this.format(builder, ":INFO:", (String)var1_1, var2_2);
            this.println((StringBuilder)var3_3);
        }
    }

    @Override
    @ManagedAttribute(value="is debug enabled for root logger Log.LOG")
    public boolean isDebugEnabled() {
        return this._level <= 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDebugEnabled(boolean enabled) {
        int level = enabled ? 1 : this.getConfiguredLevel();
        this.setLevel(level);
        String name = this.getName();
        for (Logger log : Log.getLoggers().values()) {
            void var2_3;
            if (!log.getName().startsWith(name) || !(log instanceof StdErrLog)) continue;
            StdErrLog logger = (StdErrLog)var2_3;
            int n = enabled ? 1 : logger.getConfiguredLevel();
            logger.setLevel(n);
        }
    }

    private int getConfiguredLevel() {
        return this._configuredLevel;
    }

    public int getLevel() {
        return this._level;
    }

    /*
     * WARNING - void declaration
     */
    public void setLevel(int level) {
        void var1_1;
        this._level = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setStdErrStream(PrintStream stream) {
        void var1_1;
        this._altStream = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, Object ... args) {
        if (this.isDebugEnabled()) {
            void var3_3;
            void var2_2;
            void var1_1;
            StringBuilder builder = new StringBuilder(64);
            this.format(builder, ":DBUG:", (String)var1_1, (Object[])var2_2);
            this.println((StringBuilder)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, long arg) {
        if (this.isDebugEnabled()) {
            void var2_2;
            void var1_1;
            StringBuilder builder = new StringBuilder(64);
            this.format(builder, ":DBUG:", (String)var1_1, (long)var2_2);
            this.println(builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Throwable thrown) {
        void var1_1;
        this.debug("", (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, Throwable thrown) {
        if (this.isDebugEnabled()) {
            void var3_3;
            void var2_2;
            void var1_1;
            StringBuilder builder = new StringBuilder(64);
            this.format(builder, ":DBUG:", (String)var1_1, var2_2);
            this.println((StringBuilder)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void println(StringBuilder builder) {
        void var1_1;
        if (this._altStream != null) {
            this._altStream.println(builder);
            return;
        }
        System.err.println(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void format(StringBuilder builder, String level, String msg, Object ... inArgs) {
        void var3_3;
        long now = System.currentTimeMillis();
        int ms = (int)(now % 1000L);
        String d = _dateCache.formatNow(now);
        this.tag(builder, d, ms, level);
        Object[] msgArgs = EMPTY_ARGS;
        int msgArgsLen = 0;
        Throwable cause = null;
        if (inArgs != null) {
            msgArgs = inArgs;
            msgArgsLen = inArgs.length;
            if (msgArgsLen > 0 && inArgs[msgArgsLen - 1] instanceof Throwable) {
                cause = (Throwable)inArgs[msgArgsLen - 1];
                --msgArgsLen;
            }
        }
        if (msg == null) {
            msg = "";
            for (int i = 0; i < msgArgsLen; ++i) {
                msg = msg + "{} ";
            }
        }
        String braces = "{}";
        int start = 0;
        for (int i = 0; i < msgArgsLen; ++i) {
            Object arg = msgArgs[i];
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                this.escape(builder, msg.substring(start));
                builder.append(" ");
                if (arg != null) {
                    builder.append(arg);
                }
                start = msg.length();
                continue;
            }
            this.escape(builder, msg.substring(start, bracesIndex));
            if (arg != null) {
                builder.append(arg);
            }
            start = bracesIndex + braces.length();
        }
        this.escape(builder, var3_3.substring(start));
        if (cause != null) {
            void var1_1;
            if (this.isHideStacks()) {
                builder.append(": ").append(cause);
                return;
            }
            this.formatCause((StringBuilder)var1_1, cause, "");
        }
    }

    private void formatCause(StringBuilder builder, Throwable cause, String indent) {
        while (true) {
            builder.append(EOL).append(indent);
            this.escape(builder, cause.toString());
            StackTraceElement[] elements = cause.getStackTrace();
            for (int i = 0; elements != null && i < elements.length; ++i) {
                builder.append(EOL).append(indent).append("\tat ");
                this.escape(builder, elements[i].toString());
            }
            for (Throwable suppressed : cause.getSuppressed()) {
                builder.append(EOL).append(indent).append("Suppressed: ");
                this.formatCause(builder, suppressed, "\t|" + indent);
            }
            Throwable by = cause.getCause();
            if (by == null || by == cause) break;
            builder.append(EOL).append(indent).append("Caused by: ");
            cause = by;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void escape(StringBuilder builder, String str) {
        void var2_2;
        void var1_1;
        if (__escape) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (Character.isISOControl(c)) {
                    if (c == '\n') {
                        builder.append('|');
                        continue;
                    }
                    if (c == '\r') {
                        builder.append('<');
                        continue;
                    }
                    builder.append('?');
                    continue;
                }
                builder.append(c);
            }
            return;
        }
        var1_1.append((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void tag(StringBuilder builder, String d, int ms, String tag) {
        void var1_1;
        StackTraceElement[] stackTraceElementArray;
        builder.setLength(0);
        builder.append(d);
        if (ms > 99) {
            builder.append('.');
        } else if (ms > 9) {
            builder.append(".0");
        } else {
            builder.append(".00");
        }
        builder.append(ms).append(tag);
        String name = this._printLongNames ? this._name : this._abbrevname;
        String tname = Thread.currentThread().getName();
        int p = __tagpad > 0 ? name.length() + tname.length() - __tagpad : 0;
        if (p < 0) {
            builder.append(name).append(':').append("                                                  ", 0, -p).append(tname);
        } else if (p == 0) {
            void var3_4;
            builder.append((String)stackTraceElementArray).append(':').append((String)var3_4);
        }
        builder.append(':');
        if (this._source) {
            stackTraceElementArray = new Throwable();
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray.getStackTrace();
            stackTraceElementArray = stackTraceElementArray2;
            stackTraceElementArray = stackTraceElementArray2;
            int n = stackTraceElementArray2.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement frame = stackTraceElementArray[i];
                String clazz = frame.getClassName();
                if (clazz.equals(StdErrLog.class.getName()) || clazz.equals(Log.class.getName())) continue;
                if (!this._printLongNames && clazz.startsWith("org.eclipse.jetty.")) {
                    builder.append(StdErrLog.condensePackageString(clazz));
                } else {
                    builder.append(clazz);
                }
                builder.append('#').append(frame.getMethodName());
                if (frame.getFileName() != null) {
                    builder.append('(').append(frame.getFileName()).append(':').append(frame.getLineNumber()).append(')');
                }
                builder.append(':');
                break;
            }
        }
        var1_1.append(' ');
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Logger newLogger(String fullname) {
        void var1_1;
        StdErrLog logger = new StdErrLog(fullname);
        logger.setPrintLongNames(this._printLongNames);
        logger._altStream = this._altStream;
        if (this._level != this._configuredLevel) {
            logger._level = this._level;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder s = new StringBuilder();
        s.append("StdErrLog:");
        s.append(this._name);
        s.append(":LEVEL=");
        switch (this._level) {
            case 0: {
                s.append("ALL");
                break;
            }
            case 1: {
                s.append("DEBUG");
                break;
            }
            case 2: {
                s.append("INFO");
                break;
            }
            case 3: {
                s.append("WARN");
                break;
            }
            default: {
                s.append("?");
            }
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void ignore(Throwable ignored) {
        if (this._level <= 0) {
            void var2_2;
            void var1_1;
            StringBuilder builder = new StringBuilder(64);
            this.format(builder, ":IGNORED:", "", var1_1);
            this.println((StringBuilder)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        __source = Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.SOURCE", Log.__props.getProperty("org.eclipse.jetty.util.log.stderr.SOURCE", "false")));
        __long = Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.stderr.LONG", "false"));
        __escape = Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.stderr.ESCAPE", "true"));
        String[] stringArray = new String[]{"DEBUG", "org.eclipse.jetty.util.log.DEBUG", "org.eclipse.jetty.util.log.stderr.DEBUG"};
        Object object = stringArray;
        object = stringArray;
        int cfr_ignored_0 = stringArray.length;
        for (int i = 0; i < 3; ++i) {
            void var2_2;
            String deprecatedProp = object[i];
            if (System.getProperty(deprecatedProp) == null) continue;
            System.err.printf("System Property [%s] has been deprecated! (Use org.eclipse.jetty.LEVEL=DEBUG instead)%n", var2_2);
        }
        try {
            _dateCache = new DateCache("yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace(System.err);
        }
    }
}

