/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.lang.reflect.Method;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class LoggerLog
extends AbstractLogger {
    private final Object _logger;
    private final Method _debugMT;
    private final Method _debugMAA;
    private final Method _infoMT;
    private final Method _infoMAA;
    private final Method _warnMT;
    private final Method _warnMAA;
    private final Method _setDebugEnabledE;
    private final Method _getLoggerN;
    private final Method _getName;
    private volatile boolean _debug;

    /*
     * WARNING - void declaration
     */
    public LoggerLog(Object logger) {
        try {
            void var2_3;
            this._logger = logger;
            Class<?> lc = logger.getClass();
            this._debugMT = lc.getMethod("debug", String.class, Throwable.class);
            this._debugMAA = lc.getMethod("debug", String.class, Object[].class);
            this._infoMT = lc.getMethod("info", String.class, Throwable.class);
            this._infoMAA = lc.getMethod("info", String.class, Object[].class);
            this._warnMT = lc.getMethod("warn", String.class, Throwable.class);
            this._warnMAA = lc.getMethod("warn", String.class, Object[].class);
            Method isDebugEnabled = lc.getMethod("isDebugEnabled", new Class[0]);
            this._setDebugEnabledE = lc.getMethod("setDebugEnabled", Boolean.TYPE);
            this._getLoggerN = lc.getMethod("getLogger", String.class);
            this._getName = lc.getMethod("getName", new Class[0]);
            this._debug = (Boolean)var2_3.invoke(this._logger, new Object[0]);
            return;
        }
        catch (Exception x) {
            void var1_2;
            throw new IllegalStateException((Throwable)var1_2);
        }
    }

    @Override
    public String getName() {
        try {
            return (String)this._getName.invoke(this._logger, new Object[0]);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg, Object ... args) {
        try {
            void var2_2;
            this._warnMAA.invoke(this._logger, (Object[])var2_2);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Throwable thrown) {
        void var1_1;
        this.warn("", (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg, Throwable thrown) {
        Exception exception;
        try {
            void var2_2;
            this._warnMT.invoke(this._logger, exception, var2_2);
            return;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg, Object ... args) {
        try {
            void var2_2;
            this._infoMAA.invoke(this._logger, (Object[])var2_2);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Throwable thrown) {
        void var1_1;
        this.info("", (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg, Throwable thrown) {
        Exception exception;
        try {
            void var2_2;
            this._infoMT.invoke(this._logger, exception, var2_2);
            return;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return;
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this._debug;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDebugEnabled(boolean enabled) {
        try {
            void var1_1;
            this._setDebugEnabledE.invoke(this._logger, enabled);
            this._debug = var1_1;
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, Object ... args) {
        if (!this._debug) {
            return;
        }
        try {
            void var2_2;
            this._debugMAA.invoke(this._logger, (Object[])var2_2);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Throwable thrown) {
        void var1_1;
        this.debug("", (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, Throwable th) {
        Exception exception;
        if (!this._debug) {
            return;
        }
        try {
            void var2_2;
            this._debugMT.invoke(this._logger, exception, var2_2);
            return;
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, long value) {
        if (!this._debug) {
            return;
        }
        try {
            void var2_2;
            this._debugMAA.invoke(this._logger, new Long((long)var2_2));
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void ignore(Throwable ignored) {
        if (Log.isIgnored()) {
            void var1_1;
            this.debug("IGNORED EXCEPTION ", (Throwable)var1_1);
        }
    }

    @Override
    protected Logger newLogger(String fullname) {
        Exception exception;
        try {
            Object logger = this._getLoggerN.invoke(this._logger, fullname);
            return new LoggerLog(exception);
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
            return this;
        }
    }
}

