/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.Uptime;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.LoggerLog;
import org.eclipse.jetty.util.log.StdErrLog;

public class Log {
    public static final String EXCEPTION = "EXCEPTION ";
    public static final String IGNORED = "IGNORED EXCEPTION ";
    public static String __logClass;
    public static boolean __ignored;
    protected static final Properties __props;
    private static final ConcurrentMap<String, Logger> __loggers;
    private static boolean __initialized;
    private static Logger LOG;

    /*
     * WARNING - void declaration
     */
    private static void loadProperties(String resourceName, Properties props) {
        block9: {
            URL testProps = Loader.getResource(resourceName);
            if (testProps == null) break block9;
            try {
                InputStream in;
                block10: {
                    block8: {
                        in = testProps.openStream();
                        try {
                            Properties p = new Properties();
                            p.load(in);
                            for (Object key : p.keySet()) {
                                Object value = p.get(key);
                                if (value == null) continue;
                                props.put(key, value);
                            }
                            if (in == null) break block8;
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        break block10;
                    }
                    return;
                }
                in.close();
            }
            catch (IOException e) {
                void var2_3;
                URL uRL;
                System.err.println("[WARN] Error loading logging config: " + uRL);
                var2_3.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void initialized() {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            void var1_1;
            if (__initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            __initialized = true;
            boolean announce = Boolean.parseBoolean(__props.getProperty("org.eclipse.jetty.util.log.announce", "true"));
            try {
                Class logClass = Loader.loadClass(Log.class, __logClass);
                if (LOG == null || !LOG.getClass().equals(logClass)) {
                    LOG = (Logger)logClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (announce) {
                        void var2_3;
                        LOG.debug("Logging to {} via {}", LOG, var2_3.getName());
                    }
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Log.initStandardLogging(throwable);
            }
            if (var1_1 != false && LOG != null) {
                LOG.info(String.format("Logging initialized @%dms to %s", Uptime.getUptime(), LOG.getClass().getName()), new Object[0]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Objects.requireNonNull(LOG, "Root Logger may not be null");
            return;
        }
    }

    private static void initStandardLogging(Throwable e) {
        if (__ignored) {
            Throwable throwable;
            throwable.printStackTrace();
        }
        if (LOG == null) {
            LOG = new StdErrLog();
        }
    }

    public static Logger getLog() {
        Log.initialized();
        return LOG;
    }

    public static void setLog(Logger log) {
        LOG = Objects.requireNonNull(log, "Root Logger may not be null");
        __logClass = null;
    }

    public static Logger getRootLogger() {
        Log.initialized();
        return LOG;
    }

    static boolean isIgnored() {
        return __ignored;
    }

    public static void setLogToParent(String name) {
        Object object;
        ClassLoader loader = Log.class.getClassLoader();
        if (loader != null && loader.getParent() != null) {
            Object object2;
            try {
                object2 = ((ClassLoader)object2).getParent().loadClass("org.eclipse.jetty.util.log.Log");
                object2 = ((Class)object2).getMethod("getLogger", String.class);
                Object logger = ((Method)object2).invoke(null, name);
                Log.setLog(new LoggerLog(object));
                return;
            }
            catch (Exception exception) {
                object2 = exception;
                exception.printStackTrace();
                return;
            }
        }
        Log.setLog(Log.getLogger((String)object));
    }

    public static Logger getLogger(Class<?> clazz) {
        return Log.getLogger(clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static Logger getLogger(String name) {
        void var1_1;
        String string;
        Log.initialized();
        Logger logger = null;
        if (name == null) {
            logger = LOG;
        }
        if (logger == null) {
            logger = (Logger)__loggers.get(name);
        }
        if (logger == null && LOG != null) {
            logger = LOG.getLogger(name);
        }
        Objects.requireNonNull(logger, "Logger with name [" + string + "]");
        return var1_1;
    }

    static ConcurrentMap<String, Logger> getMutableLoggers() {
        return __loggers;
    }

    @ManagedAttribute(value="list of all instantiated loggers")
    public static Map<String, Logger> getLoggers() {
        return Collections.unmodifiableMap(__loggers);
    }

    public static Properties getProperties() {
        return __props;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(String x0, Properties x1) {
        void var1_1;
        Log.loadProperties(x0, (Properties)var1_1);
    }

    static {
        __props = new Properties();
        __loggers = new ConcurrentHashMap<String, Logger>();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Object run() {
                Log.access$000("jetty-logging.properties", __props);
                String osName = System.getProperty("os.name");
                if (osName != null && osName.length() > 0) {
                    osName = osName.toLowerCase(Locale.ENGLISH).replace(' ', '-');
                    Log.access$000("jetty-logging-" + osName + ".properties", __props);
                }
                Enumeration<?> systemKeyEnum = System.getProperties().propertyNames();
                while (systemKeyEnum.hasMoreElements()) {
                    void var3_3;
                    void var2_2;
                    String key = (String)systemKeyEnum.nextElement();
                    String val = System.getProperty(key);
                    if (val == null) continue;
                    __props.setProperty((String)var2_2, (String)var3_3);
                }
                __logClass = __props.getProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.Slf4jLog");
                __ignored = Boolean.parseBoolean(__props.getProperty("org.eclipse.jetty.util.log.IGNORED", "false"));
                return null;
            }
        });
    }
}

