/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JettyLogHandler
extends Handler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void config() {
        block8: {
            Object object = Thread.currentThread().getContextClassLoader();
            URL url = ((ClassLoader)object).getResource("logging.properties");
            if (url != null) {
                System.err.printf("Initializing java.util.logging from %s%n", url);
                try {
                    InputStream in = url.openStream();
                    try {
                        LogManager.getLogManager().readConfiguration(in);
                        if (in == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (in == null) throw throwable;
                        try {
                            ((InputStream)object).close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    in.close();
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace(System.err);
                }
            } else {
                System.err.printf("WARNING: java.util.logging failed to initialize: logging.properties not found%n", new Object[0]);
            }
        }
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
    }

    public JettyLogHandler() {
        if (Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.DEBUG", "false"))) {
            this.setLevel(Level.FINEST);
        }
        if (Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.IGNORED", "false"))) {
            this.setLevel(Level.ALL);
        }
        System.err.printf("%s Initialized at level [%s]%n", this.getClass().getName(), this.getLevel().getName());
    }

    /*
     * WARNING - void declaration
     */
    private synchronized String formatMessage(LogRecord record) {
        String msg = this.getMessage(record);
        try {
            Object[] params = record.getParameters();
            if (params == null || params.length == 0) {
                return msg;
            }
            if (Pattern.compile("\\{\\d+\\}").matcher(msg).find()) {
                void var1_1;
                return MessageFormat.format(msg, (Object[])var1_1);
            }
            return msg;
        }
        catch (Exception exception) {
            void var2_2;
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getMessage(LogRecord record) {
        void var1_1;
        ResourceBundle bundle = record.getResourceBundle();
        if (bundle != null) {
            try {
                void var2_2;
                return var2_2.getString(record.getMessage());
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return var1_1.getMessage();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void publish(LogRecord record) {
        void var3_3;
        Logger jettyLogger = this.getJettyLogger(record.getLoggerName());
        int level = record.getLevel().intValue();
        if (level >= Level.OFF.intValue()) {
            return;
        }
        Throwable cause = record.getThrown();
        String msg = this.formatMessage(record);
        if (level >= Level.WARNING.intValue()) {
            if (cause != null) {
                jettyLogger.warn(msg, cause);
                return;
            }
            jettyLogger.warn(msg, new Object[0]);
            return;
        }
        if (level >= Level.INFO.intValue()) {
            if (cause != null) {
                jettyLogger.info(msg, cause);
                return;
            }
            jettyLogger.info(msg, new Object[0]);
            return;
        }
        if (level >= Level.FINEST.intValue()) {
            void var1_1;
            if (cause != null) {
                jettyLogger.debug(msg, cause);
                return;
            }
            jettyLogger.debug((String)var1_1, new Object[0]);
            return;
        }
        if (var3_3 >= Level.ALL.intValue()) {
            void var2_2;
            var2_2.ignore(cause);
            return;
        }
    }

    private Logger getJettyLogger(String loggerName) {
        return Log.getLogger(loggerName);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

