/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JavaUtilLog
extends AbstractLogger {
    private static final String THIS_CLASS = JavaUtilLog.class.getName();
    private static final boolean __source = Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.SOURCE", Log.__props.getProperty("org.eclipse.jetty.util.log.javautil.SOURCE", "true")));
    private static boolean _initialized = false;
    private Level configuredLevel;
    private java.util.logging.Logger _logger;

    public JavaUtilLog() {
        this("org.eclipse.jetty.util.log.javautil");
    }

    /*
     * WARNING - void declaration
     */
    public JavaUtilLog(String name) {
        Class<JavaUtilLog> clazz = JavaUtilLog.class;
        synchronized (JavaUtilLog.class) {
            void var1_1;
            if (!_initialized) {
                _initialized = true;
                String properties = Log.__props.getProperty("org.eclipse.jetty.util.log.javautil.PROPERTIES", null);
                if (properties != null) {
                    void var3_4;
                    AccessController.doPrivileged(new PrivilegedAction<Object>(this, (String)var3_4){
                        final /* synthetic */ String val$properties;
                        final /* synthetic */ JavaUtilLog this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$properties = string;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public Object run() {
                            try {
                                URL props = Loader.getResource(this.val$properties);
                                if (props != null) {
                                    LogManager.getLogManager().readConfiguration(props.openStream());
                                }
                            }
                            catch (Throwable e) {
                                void var1_2;
                                System.err.println("[WARN] Error loading logging config: " + this.val$properties);
                                var1_2.printStackTrace(System.err);
                            }
                            return null;
                        }
                    });
                }
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            this._logger = java.util.logging.Logger.getLogger(name);
            switch (JavaUtilLog.lookupLoggingLevel(Log.__props, (String)var1_1)) {
                case 0: {
                    this._logger.setLevel(Level.ALL);
                    break;
                }
                case 1: {
                    this._logger.setLevel(Level.FINE);
                    break;
                }
                case 2: {
                    this._logger.setLevel(Level.INFO);
                    break;
                }
                case 3: {
                    this._logger.setLevel(Level.WARNING);
                    break;
                }
                case 10: {
                    this._logger.setLevel(Level.OFF);
                }
            }
            this.configuredLevel = this._logger.getLevel();
            return;
        }
    }

    @Override
    public String getName() {
        return this._logger.getName();
    }

    /*
     * WARNING - void declaration
     */
    protected void log(Level level, String msg, Throwable thrown) {
        void var1_1;
        LogRecord record = new LogRecord(level, msg);
        if (thrown != null) {
            record.setThrown(thrown);
        }
        record.setLoggerName(this._logger.getName());
        if (__source) {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                StackTraceElement e = stack[i];
                if (e.getClassName().equals(THIS_CLASS)) continue;
                record.setSourceClassName(e.getClassName());
                record.setSourceMethodName(e.getMethodName());
                break;
            }
        }
        this._logger.log((LogRecord)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg, Object ... args) {
        if (this._logger.isLoggable(Level.WARNING)) {
            void var2_2;
            void var1_1;
            this.log(Level.WARNING, this.format((String)var1_1, (Object[])var2_2), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Throwable thrown) {
        if (this._logger.isLoggable(Level.WARNING)) {
            void var1_1;
            this.log(Level.WARNING, "", (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg, Throwable thrown) {
        if (this._logger.isLoggable(Level.WARNING)) {
            void var2_2;
            void var1_1;
            this.log(Level.WARNING, (String)var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg, Object ... args) {
        if (this._logger.isLoggable(Level.INFO)) {
            void var2_2;
            void var1_1;
            this.log(Level.INFO, this.format((String)var1_1, (Object[])var2_2), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Throwable thrown) {
        if (this._logger.isLoggable(Level.INFO)) {
            void var1_1;
            this.log(Level.INFO, "", (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg, Throwable thrown) {
        if (this._logger.isLoggable(Level.INFO)) {
            void var2_2;
            void var1_1;
            this.log(Level.INFO, (String)var1_1, (Throwable)var2_2);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this._logger.isLoggable(Level.FINE);
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this.configuredLevel = this._logger.getLevel();
            this._logger.setLevel(Level.FINE);
            return;
        }
        this._logger.setLevel(this.configuredLevel);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, Object ... args) {
        if (this._logger.isLoggable(Level.FINE)) {
            void var2_2;
            void var1_1;
            this.log(Level.FINE, this.format((String)var1_1, (Object[])var2_2), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, long arg) {
        if (this._logger.isLoggable(Level.FINE)) {
            void var2_2;
            void var1_1;
            this.log(Level.FINE, this.format((String)var1_1, (long)var2_2), null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Throwable thrown) {
        if (this._logger.isLoggable(Level.FINE)) {
            void var1_1;
            this.log(Level.FINE, "", (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, Throwable thrown) {
        if (this._logger.isLoggable(Level.FINE)) {
            void var2_2;
            void var1_1;
            this.log(Level.FINE, (String)var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Logger newLogger(String fullname) {
        void var1_1;
        return new JavaUtilLog((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void ignore(Throwable ignored) {
        if (this._logger.isLoggable(Level.FINEST)) {
            void var1_1;
            this.log(Level.FINEST, "IGNORED EXCEPTION ", (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String format(String msg, Object ... args) {
        void var1_1;
        void var2_2;
        msg = String.valueOf(msg);
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (void arg : var2_2) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                builder.append(msg.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = msg.length();
                continue;
            }
            builder.append(msg, start, bracesIndex);
            builder.append(arg);
            start = bracesIndex + braces.length();
        }
        builder.append(var1_1.substring(start));
        return builder.toString();
    }
}

