/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.compression;

import java.util.zip.Deflater;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.compression.CompressionPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class DeflaterPool
extends CompressionPool<Deflater> {
    private final int compressionLevel;
    private final boolean nowrap;

    /*
     * WARNING - void declaration
     */
    public DeflaterPool(int capacity, int compressionLevel, boolean nowrap) {
        super((int)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.compressionLevel = var2_2;
        this.nowrap = var3_3;
    }

    @Override
    protected Deflater newObject() {
        return new Deflater(this.compressionLevel, this.nowrap);
    }

    @Override
    protected void end(Deflater deflater) {
        deflater.end();
    }

    @Override
    protected void reset(Deflater deflater) {
        deflater.reset();
    }

    /*
     * WARNING - void declaration
     */
    public static DeflaterPool ensurePool(Container container) {
        Container container2;
        void var1_2;
        DeflaterPool pool = container.getBean(DeflaterPool.class);
        if (pool != null) {
            return pool;
        }
        int capacity = -1;
        ThreadPool.SizedThreadPool threadPool = container.getBean(ThreadPool.SizedThreadPool.class);
        if (threadPool != null) {
            void var2_4;
            capacity = var2_4.getMaxThreads();
        }
        DeflaterPool deflaterPool = new DeflaterPool((int)var1_2, -1, true);
        container2.addBean(deflaterPool, true);
        return deflaterPool;
    }
}

