/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class FileDestroyable
implements Destroyable {
    private static final Logger LOG = Log.getLogger(FileDestroyable.class);
    final List<File> _files = new ArrayList<File>();

    public FileDestroyable() {
    }

    /*
     * WARNING - void declaration
     */
    public FileDestroyable(String file) throws IOException {
        void var1_1;
        this._files.add(Resource.newResource((String)var1_1).getFile());
    }

    /*
     * WARNING - void declaration
     */
    public FileDestroyable(File file) {
        void var1_1;
        this._files.add((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addFile(String file) throws IOException {
        Resource r = Resource.newResource(file);
        try {
            this._files.add(r.getFile());
            if (r != null) {
                r.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (r != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addFile(File file) {
        void var1_1;
        this._files.add((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addFiles(Collection<File> files) {
        void var1_1;
        this._files.addAll((Collection<File>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeFile(String file) throws IOException {
        Resource r = Resource.newResource(file);
        try {
            this._files.remove(r.getFile());
            if (r != null) {
                r.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (r != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeFile(File file) {
        void var1_1;
        this._files.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void destroy() {
        for (File file : this._files) {
            void var2_2;
            if (!file.exists()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Destroy {}", file);
            }
            IO.delete((File)var2_2);
        }
    }
}

